/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnResDNList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnModifyResGroup
implements FStruct {
    public BigInteger iGID;
    public byte[] strLabel = null;
    public BigInteger iParentGID = null;
    public AsnResDNList lstResDNRemove = new AsnResDNList();
    public AsnResDNList lstResDNAdd = new AsnResDNList();

    public AsnModifyResGroup() {
    }

    public AsnModifyResGroup(AsnModifyResGroup arg) {
        this.iGID = arg.iGID;
        if (arg.strLabel != null) {
            this.strLabel = new byte[arg.strLabel.length];
            System.arraycopy(arg.strLabel, 0, this.strLabel, 0, arg.strLabel.length);
        }
        if (arg.iParentGID != null) {
            this.iParentGID = arg.iParentGID;
        }
        this.lstResDNRemove = new AsnResDNList(arg.lstResDNRemove);
        this.lstResDNAdd = new AsnResDNList(arg.lstResDNAdd);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iGID);
        if (this.strLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strLabel);
        }
        if (this.iParentGID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.iParentGID);
        }
        this.lstResDNRemove.serialize(enc);
        this.lstResDNAdd.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iGID = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.iParentGID = dec.deserializeInteger();
        }
        this.lstResDNRemove.deserialize(dec);
        this.lstResDNAdd.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iGID = ");
        os.print(this.iGID.toString());
        os.println(',');
        if (this.strLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strLabel));
            os.println(',');
        }
        if (this.iParentGID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iParentGID = ");
            os.print(this.iParentGID.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstResDNRemove = ");
        this.lstResDNRemove.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lstResDNAdd = ");
        this.lstResDNAdd.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

