/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnMapItem
implements FStruct {
    public byte[] key;
    public byte[] strValue = null;
    public BigInteger iValue = null;

    public AsnMapItem() {
    }

    public AsnMapItem(AsnMapItem arg) {
        this.key = new byte[arg.key.length];
        System.arraycopy(arg.key, 0, this.key, 0, arg.key.length);
        if (arg.strValue != null) {
            this.strValue = new byte[arg.strValue.length];
            System.arraycopy(arg.strValue, 0, this.strValue, 0, arg.strValue.length);
        }
        if (arg.iValue != null) {
            this.iValue = arg.iValue;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.key);
        if (this.strValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strValue);
        }
        if (this.iValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.iValue);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.key = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strValue = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.iValue = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("key = ");
        os.print(FStruFormat.convertToString((byte[])this.key));
        os.println(',');
        if (this.strValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strValue = ");
            os.print(FStruFormat.convertToString((byte[])this.strValue));
            os.println(',');
        }
        if (this.iValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iValue = ");
            os.print(this.iValue.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

