/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnMapIfModDevIPAddrNotify
implements FStruct {
    public BigInteger iDevID;
    public byte[] strDevIPAddr;
    public byte[] strDevSubnetMask;

    public AsnMapIfModDevIPAddrNotify() {
    }

    public AsnMapIfModDevIPAddrNotify(AsnMapIfModDevIPAddrNotify arg) {
        this.iDevID = arg.iDevID;
        this.strDevIPAddr = new byte[arg.strDevIPAddr.length];
        System.arraycopy(arg.strDevIPAddr, 0, this.strDevIPAddr, 0, arg.strDevIPAddr.length);
        this.strDevSubnetMask = new byte[arg.strDevSubnetMask.length];
        System.arraycopy(arg.strDevSubnetMask, 0, this.strDevSubnetMask, 0, arg.strDevSubnetMask.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iDevID);
        enc.serializeOctetString(this.strDevIPAddr);
        enc.serializeOctetString(this.strDevSubnetMask);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iDevID = dec.deserializeInteger();
        this.strDevIPAddr = dec.deserializeOctetString();
        this.strDevSubnetMask = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevIPAddr = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevIPAddr));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strDevSubnetMask = ");
        os.print(FStruFormat.convertToString((byte[])this.strDevSubnetMask));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

