/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.DateTimeType;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnLogInfo
implements FStruct {
    public BigInteger oTID;
    public BigInteger userID;
    public BigInteger oTSID;
    public BigInteger cmdID;
    public byte[] operteObject;
    public BigInteger ipAddr;
    public DateTimeType operateTime = new DateTimeType();
    public BigInteger errorcode;
    public byte[] operDesc;
    public BigInteger result;
    public BigInteger nLogType;
    public BigInteger nLogClass = null;
    public BigInteger nLogGroupID = null;

    public AsnLogInfo() {
    }

    public AsnLogInfo(AsnLogInfo arg) {
        this.oTID = arg.oTID;
        this.userID = arg.userID;
        this.oTSID = arg.oTSID;
        this.cmdID = arg.cmdID;
        this.operteObject = new byte[arg.operteObject.length];
        System.arraycopy(arg.operteObject, 0, this.operteObject, 0, arg.operteObject.length);
        this.ipAddr = arg.ipAddr;
        this.operateTime = new DateTimeType(arg.operateTime);
        this.errorcode = arg.errorcode;
        this.operDesc = new byte[arg.operDesc.length];
        System.arraycopy(arg.operDesc, 0, this.operDesc, 0, arg.operDesc.length);
        this.result = arg.result;
        this.nLogType = arg.nLogType;
        if (arg.nLogClass != null) {
            this.nLogClass = arg.nLogClass;
        }
        if (arg.nLogGroupID != null) {
            this.nLogGroupID = arg.nLogGroupID;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.oTID);
        enc.serializeInteger(this.userID);
        enc.serializeInteger(this.oTSID);
        enc.serializeInteger(this.cmdID);
        enc.serializeOctetString(this.operteObject);
        enc.serializeInteger(this.ipAddr);
        this.operateTime.serialize(enc);
        enc.serializeInteger(this.errorcode);
        enc.serializeOctetString(this.operDesc);
        enc.serializeInteger(this.result);
        enc.serializeInteger(this.nLogType);
        if (this.nLogClass != null) {
            enc.serializeInteger(this.nLogClass);
        }
        if (this.nLogGroupID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.nLogGroupID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oTID = dec.deserializeInteger();
        this.userID = dec.deserializeInteger();
        this.oTSID = dec.deserializeInteger();
        this.cmdID = dec.deserializeInteger();
        this.operteObject = dec.deserializeOctetString();
        this.ipAddr = dec.deserializeInteger();
        this.operateTime.deserialize(dec);
        this.errorcode = dec.deserializeInteger();
        this.operDesc = dec.deserializeOctetString();
        this.result = dec.deserializeInteger();
        this.nLogType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)0, (int)2))) {
            this.nLogClass = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.nLogGroupID = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oTID = ");
        os.print(this.oTID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userID = ");
        os.print(this.userID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oTSID = ");
        os.print(this.oTSID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cmdID = ");
        os.print(this.cmdID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operteObject = ");
        os.print(FStruFormat.convertToString((byte[])this.operteObject));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddr = ");
        os.print(this.ipAddr.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operateTime = ");
        this.operateTime.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorcode = ");
        os.print(this.errorcode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operDesc = ");
        os.print(FStruFormat.convertToString((byte[])this.operDesc));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("result = ");
        os.print(this.result.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nLogType = ");
        os.print(this.nLogType.toString());
        os.println(',');
        if (this.nLogClass != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("nLogClass = ");
            os.print(this.nLogClass.toString());
            os.println(',');
        }
        if (this.nLogGroupID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("nLogGroupID = ");
            os.print(this.nLogGroupID.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

