/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnLinkAttr
implements FStruct {
    public byte[] strLinkID;
    public byte[] strLeftObjID;
    public BigInteger iLeftObjType;
    public byte[] strRightObjID;
    public BigInteger iRightObjType;
    public byte[] strLabel = null;
    public byte[] strComment = null;
    public BigInteger iViewID = null;
    public BigInteger iLineWidth = null;
    public BigInteger iLineType = null;
    public BigInteger iDirection = null;
    public BigInteger iStatusDmPID = null;

    public AsnLinkAttr() {
    }

    public AsnLinkAttr(AsnLinkAttr arg) {
        this.strLinkID = new byte[arg.strLinkID.length];
        System.arraycopy(arg.strLinkID, 0, this.strLinkID, 0, arg.strLinkID.length);
        this.strLeftObjID = new byte[arg.strLeftObjID.length];
        System.arraycopy(arg.strLeftObjID, 0, this.strLeftObjID, 0, arg.strLeftObjID.length);
        this.iLeftObjType = arg.iLeftObjType;
        this.strRightObjID = new byte[arg.strRightObjID.length];
        System.arraycopy(arg.strRightObjID, 0, this.strRightObjID, 0, arg.strRightObjID.length);
        this.iRightObjType = arg.iRightObjType;
        if (arg.strLabel != null) {
            this.strLabel = new byte[arg.strLabel.length];
            System.arraycopy(arg.strLabel, 0, this.strLabel, 0, arg.strLabel.length);
        }
        if (arg.strComment != null) {
            this.strComment = new byte[arg.strComment.length];
            System.arraycopy(arg.strComment, 0, this.strComment, 0, arg.strComment.length);
        }
        if (arg.iViewID != null) {
            this.iViewID = arg.iViewID;
        }
        if (arg.iLineWidth != null) {
            this.iLineWidth = arg.iLineWidth;
        }
        if (arg.iLineType != null) {
            this.iLineType = arg.iLineType;
        }
        if (arg.iDirection != null) {
            this.iDirection = arg.iDirection;
        }
        if (arg.iStatusDmPID != null) {
            this.iStatusDmPID = arg.iStatusDmPID;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strLinkID);
        enc.serializeOctetString(this.strLeftObjID);
        enc.serializeInteger(this.iLeftObjType);
        enc.serializeOctetString(this.strRightObjID);
        enc.serializeInteger(this.iRightObjType);
        if (this.strLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strLabel);
        }
        if (this.strComment != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strComment);
        }
        if (this.iViewID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.iViewID);
        }
        if (this.iLineWidth != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(this.iLineWidth);
        }
        if (this.iLineType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)4));
            enc.serializeInteger(this.iLineType);
        }
        if (this.iDirection != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)5));
            enc.serializeInteger(this.iDirection);
        }
        if (this.iStatusDmPID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)6));
            enc.serializeInteger(this.iStatusDmPID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strLinkID = dec.deserializeOctetString();
        this.strLeftObjID = dec.deserializeOctetString();
        this.iLeftObjType = dec.deserializeInteger();
        this.strRightObjID = dec.deserializeOctetString();
        this.iRightObjType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strComment = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.iViewID = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.iLineWidth = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)4))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)4));
            this.iLineType = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)5))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)5));
            this.iDirection = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)6))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)6));
            this.iStatusDmPID = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLinkID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLinkID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLeftObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strLeftObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iLeftObjType = ");
        os.print(this.iLeftObjType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strRightObjID = ");
        os.print(FStruFormat.convertToString((byte[])this.strRightObjID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iRightObjType = ");
        os.print(this.iRightObjType.toString());
        os.println(',');
        if (this.strLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.strLabel));
            os.println(',');
        }
        if (this.strComment != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strComment = ");
            os.print(FStruFormat.convertToString((byte[])this.strComment));
            os.println(',');
        }
        if (this.iViewID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iViewID = ");
            os.print(this.iViewID.toString());
            os.println(',');
        }
        if (this.iLineWidth != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iLineWidth = ");
            os.print(this.iLineWidth.toString());
            os.println(',');
        }
        if (this.iLineType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iLineType = ");
            os.print(this.iLineType.toString());
            os.println(',');
        }
        if (this.iDirection != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iDirection = ");
            os.print(this.iDirection.toString());
            os.println(',');
        }
        if (this.iStatusDmPID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iStatusDmPID = ");
            os.print(this.iStatusDmPID.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

