/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnIPAddrSegment
implements FStruct {
    public byte[] strFromIP;
    public byte[] strToIP;
    public byte[] strMask;

    public AsnIPAddrSegment() {
    }

    public AsnIPAddrSegment(AsnIPAddrSegment arg) {
        this.strFromIP = new byte[arg.strFromIP.length];
        System.arraycopy(arg.strFromIP, 0, this.strFromIP, 0, arg.strFromIP.length);
        this.strToIP = new byte[arg.strToIP.length];
        System.arraycopy(arg.strToIP, 0, this.strToIP, 0, arg.strToIP.length);
        this.strMask = new byte[arg.strMask.length];
        System.arraycopy(arg.strMask, 0, this.strMask, 0, arg.strMask.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strFromIP);
        enc.serializeOctetString(this.strToIP);
        enc.serializeOctetString(this.strMask);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strFromIP = dec.deserializeOctetString();
        this.strToIP = dec.deserializeOctetString();
        this.strMask = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strFromIP = ");
        os.print(FStruFormat.convertToString((byte[])this.strFromIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strToIP = ");
        os.print(FStruFormat.convertToString((byte[])this.strToIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strMask = ");
        os.print(FStruFormat.convertToString((byte[])this.strMask));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

