/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnFaultTRNmInfo
implements FStruct {
    public BigInteger lServerID;
    public byte[] strServerIP;
    public BigInteger lServerLstPort;
    public BigInteger lServerUdpPort;

    public AsnFaultTRNmInfo() {
    }

    public AsnFaultTRNmInfo(AsnFaultTRNmInfo arg) {
        this.lServerID = arg.lServerID;
        this.strServerIP = new byte[arg.strServerIP.length];
        System.arraycopy(arg.strServerIP, 0, this.strServerIP, 0, arg.strServerIP.length);
        this.lServerLstPort = arg.lServerLstPort;
        this.lServerUdpPort = arg.lServerUdpPort;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.lServerID);
        enc.serializeOctetString(this.strServerIP);
        enc.serializeInteger(this.lServerLstPort);
        enc.serializeInteger(this.lServerUdpPort);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.lServerID = dec.deserializeInteger();
        this.strServerIP = dec.deserializeOctetString();
        this.lServerLstPort = dec.deserializeInteger();
        this.lServerUdpPort = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lServerID = ");
        os.print(this.lServerID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strServerIP = ");
        os.print(FStruFormat.convertToString((byte[])this.strServerIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lServerLstPort = ");
        os.print(this.lServerLstPort.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("lServerUdpPort = ");
        os.print(this.lServerUdpPort.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

