/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDevMaintenanceInfo
implements FStruct {
    public BigInteger iIndex;
    public byte[] szSupporter;
    public byte[] szDept;
    public byte[] szPhoneNo;
    public byte[] szEmail;
    public byte[] szReserve1 = null;

    public AsnDevMaintenanceInfo() {
    }

    public AsnDevMaintenanceInfo(AsnDevMaintenanceInfo arg) {
        this.iIndex = arg.iIndex;
        this.szSupporter = new byte[arg.szSupporter.length];
        System.arraycopy(arg.szSupporter, 0, this.szSupporter, 0, arg.szSupporter.length);
        this.szDept = new byte[arg.szDept.length];
        System.arraycopy(arg.szDept, 0, this.szDept, 0, arg.szDept.length);
        this.szPhoneNo = new byte[arg.szPhoneNo.length];
        System.arraycopy(arg.szPhoneNo, 0, this.szPhoneNo, 0, arg.szPhoneNo.length);
        this.szEmail = new byte[arg.szEmail.length];
        System.arraycopy(arg.szEmail, 0, this.szEmail, 0, arg.szEmail.length);
        if (arg.szReserve1 != null) {
            this.szReserve1 = new byte[arg.szReserve1.length];
            System.arraycopy(arg.szReserve1, 0, this.szReserve1, 0, arg.szReserve1.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.iIndex);
        enc.serializeOctetString(this.szSupporter);
        enc.serializeOctetString(this.szDept);
        enc.serializeOctetString(this.szPhoneNo);
        enc.serializeOctetString(this.szEmail);
        if (this.szReserve1 != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.szReserve1);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.iIndex = dec.deserializeInteger();
        this.szSupporter = dec.deserializeOctetString();
        this.szDept = dec.deserializeOctetString();
        this.szPhoneNo = dec.deserializeOctetString();
        this.szEmail = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.szReserve1 = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iIndex = ");
        os.print(this.iIndex.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("szSupporter = ");
        os.print(FStruFormat.convertToString((byte[])this.szSupporter));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("szDept = ");
        os.print(FStruFormat.convertToString((byte[])this.szDept));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("szPhoneNo = ");
        os.print(FStruFormat.convertToString((byte[])this.szPhoneNo));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("szEmail = ");
        os.print(FStruFormat.convertToString((byte[])this.szEmail));
        os.println(',');
        if (this.szReserve1 != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("szReserve1 = ");
            os.print(FStruFormat.convertToString((byte[])this.szReserve1));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

