/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.AsnNodeTab;
import com.swimap.imap.common.asn1.common.AsnTopoStatus;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnContainerTab
implements FStruct {
    public AsnNodeTab oMainNodeTab = new AsnNodeTab();
    public BigInteger iDevID;
    public AsnTopoStatus oStatus = new AsnTopoStatus();
    public byte[] strAlias = null;

    public AsnContainerTab() {
    }

    public AsnContainerTab(AsnContainerTab arg) {
        this.oMainNodeTab = new AsnNodeTab(arg.oMainNodeTab);
        this.iDevID = arg.iDevID;
        this.oStatus = new AsnTopoStatus(arg.oStatus);
        if (arg.strAlias != null) {
            this.strAlias = new byte[arg.strAlias.length];
            System.arraycopy(arg.strAlias, 0, this.strAlias, 0, arg.strAlias.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oMainNodeTab.serialize(enc);
        enc.serializeInteger(this.iDevID);
        this.oStatus.serialize(enc);
        if (this.strAlias != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.strAlias);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oMainNodeTab.deserialize(dec);
        this.iDevID = dec.deserializeInteger();
        this.oStatus.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.strAlias = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oMainNodeTab = ");
        this.oMainNodeTab.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDevID = ");
        os.print(this.iDevID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oStatus = ");
        this.oStatus.print(os, indent + 2);
        os.println(',');
        if (this.strAlias != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strAlias = ");
            os.print(FStruFormat.convertToString((byte[])this.strAlias));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

