/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnColumnValue
implements FStruct {
    public byte[] strColumnName;
    public BigInteger intValue = null;
    public byte[] strValue = null;

    public AsnColumnValue() {
    }

    public AsnColumnValue(AsnColumnValue arg) {
        this.strColumnName = new byte[arg.strColumnName.length];
        System.arraycopy(arg.strColumnName, 0, this.strColumnName, 0, arg.strColumnName.length);
        if (arg.intValue != null) {
            this.intValue = arg.intValue;
        }
        if (arg.strValue != null) {
            this.strValue = new byte[arg.strValue.length];
            System.arraycopy(arg.strValue, 0, this.strValue, 0, arg.strValue.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strColumnName);
        if (this.intValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.intValue);
        }
        if (this.strValue != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strValue);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strColumnName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.intValue = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strValue = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strColumnName = ");
        os.print(FStruFormat.convertToString((byte[])this.strColumnName));
        os.println(',');
        if (this.intValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("intValue = ");
            os.print(this.intValue.toString());
            os.println(',');
        }
        if (this.strValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strValue = ");
            os.print(FStruFormat.convertToString((byte[])this.strValue));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

