/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import com.swimap.imap.common.asn1.common.ASNULList;
import com.swimap.imap.common.asn1.common.AsnDistinguishedResource;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnAlmLocInfo
implements FStruct {
    public BigInteger locateType;
    public BigInteger ulDevSerialNo = null;
    public ASNULList lstSerialNo = null;
    public AsnDistinguishedResource res = new AsnDistinguishedResource();
    public byte[] strParas = null;

    public AsnAlmLocInfo() {
    }

    public AsnAlmLocInfo(AsnAlmLocInfo arg) {
        this.locateType = arg.locateType;
        if (arg.ulDevSerialNo != null) {
            this.ulDevSerialNo = arg.ulDevSerialNo;
        }
        if (arg.lstSerialNo != null) {
            this.lstSerialNo = new ASNULList(arg.lstSerialNo);
        }
        this.res = new AsnDistinguishedResource(arg.res);
        if (arg.strParas != null) {
            this.strParas = new byte[arg.strParas.length];
            System.arraycopy(arg.strParas, 0, this.strParas, 0, arg.strParas.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.locateType);
        if (this.ulDevSerialNo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.ulDevSerialNo);
        }
        if (this.lstSerialNo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.lstSerialNo.serialize(enc);
        }
        this.res.serialize(enc);
        if (this.strParas != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.strParas);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.locateType = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.ulDevSerialNo = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.lstSerialNo = new ASNULList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.lstSerialNo.deserialize(dec);
        }
        this.res.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.strParas = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("locateType = ");
        os.print(this.locateType.toString());
        os.println(',');
        if (this.ulDevSerialNo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("ulDevSerialNo = ");
            os.print(this.ulDevSerialNo.toString());
            os.println(',');
        }
        if (this.lstSerialNo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("lstSerialNo = ");
            this.lstSerialNo.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("res = ");
        this.res.print(os, indent + 2);
        os.println(',');
        if (this.strParas != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("strParas = ");
            os.print(FStruFormat.convertToString((byte[])this.strParas));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

