/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnAddiInfo
implements FStruct {
    public byte[] columnName;
    public BigInteger type;
    public byte[] value;

    public AsnAddiInfo() {
    }

    public AsnAddiInfo(AsnAddiInfo arg) {
        this.columnName = new byte[arg.columnName.length];
        System.arraycopy(arg.columnName, 0, this.columnName, 0, arg.columnName.length);
        this.type = arg.type;
        this.value = new byte[arg.value.length];
        System.arraycopy(arg.value, 0, this.value, 0, arg.value.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.columnName);
        enc.serializeInteger(this.type);
        enc.serializeOctetString(this.value);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.columnName = dec.deserializeOctetString();
        this.type = dec.deserializeInteger();
        this.value = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("columnName = ");
        os.print(FStruFormat.convertToString((byte[])this.columnName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("type = ");
        os.print(this.type.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(FStruFormat.convertToString((byte[])this.value));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

