/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.imap.common.asn1.common;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AddressControlList
implements FStruct {
    public byte[] strWorkStationAddress;
    public byte[] strLocationComment;

    public AddressControlList() {
    }

    public AddressControlList(AddressControlList arg) {
        this.strWorkStationAddress = new byte[arg.strWorkStationAddress.length];
        System.arraycopy(arg.strWorkStationAddress, 0, this.strWorkStationAddress, 0, arg.strWorkStationAddress.length);
        this.strLocationComment = new byte[arg.strLocationComment.length];
        System.arraycopy(arg.strLocationComment, 0, this.strLocationComment, 0, arg.strLocationComment.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.strWorkStationAddress);
        enc.serializeOctetString(this.strLocationComment);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.strWorkStationAddress = dec.deserializeOctetString();
        this.strLocationComment = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strWorkStationAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.strWorkStationAddress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strLocationComment = ");
        os.print(FStruFormat.convertToString((byte[])this.strLocationComment));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

