/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.topo.adapter.message;

import com.swimap.external.topo.adapter.message.EmfDayLightDate;
import java.util.Date;
import java.util.TimeZone;

public class EmfZoneInfo {
    public int m_iZone;
    private String m_szZoneName;
    public int m_iDayLightOffset;
    public EmfDayLightDate m_oDayLightStartTime;
    public EmfDayLightDate m_oDayLightEndTime;
    private static int localZoneRowOffset = 480;
    private String displayInfo;

    public EmfZoneInfo() {
        TimeZone localZone = TimeZone.getDefault();
        this.m_szZoneName = localZone.getID();
        localZoneRowOffset = localZone.getRawOffset() / 1000 / 60;
        this.displayInfo = "";
        this.m_iZone = localZoneRowOffset;
        this.m_iDayLightOffset = 0;
        this.m_oDayLightStartTime = new EmfDayLightDate();
        this.m_oDayLightEndTime = new EmfDayLightDate();
    }

    public EmfZoneInfo(int iZone, int iDayLightOffset, EmfDayLightDate oDayLightStartTime, EmfDayLightDate oDayLightEndTime) {
        TimeZone localZone = TimeZone.getDefault();
        this.m_szZoneName = localZone.getID();
        localZoneRowOffset = localZone.getRawOffset() / 1000 / 60;
        this.displayInfo = "";
        this.m_iZone = iZone;
        this.m_iDayLightOffset = iDayLightOffset;
        this.m_oDayLightStartTime = oDayLightStartTime;
        this.m_oDayLightEndTime = oDayLightEndTime;
        this.m_szZoneName = this.blurZoneNameByOffset(iZone);
    }

    public EmfZoneInfo(int iZone, int iDayLightOffset, EmfDayLightDate oDayLightStartTime, EmfDayLightDate oDayLightEndTime, String zoneName) {
        TimeZone localZone = TimeZone.getDefault();
        this.m_szZoneName = localZone.getID();
        localZoneRowOffset = localZone.getRawOffset() / 1000 / 60;
        this.displayInfo = "";
        this.m_iZone = iZone;
        this.m_iDayLightOffset = iDayLightOffset;
        this.m_oDayLightStartTime = oDayLightStartTime;
        this.m_oDayLightEndTime = oDayLightEndTime;
        this.m_szZoneName = zoneName == null || zoneName.isEmpty() ? this.blurZoneNameByOffset(iZone) : zoneName;
    }

    public Date GetDayLightStartTime(int iYear) {
        Date rangeStartTmp = null;
        if (this.m_oDayLightStartTime.m_iMonth < this.m_oDayLightEndTime.m_iMonth) {
            if (0 == this.m_oDayLightStartTime.m_iDayLightType) {
                rangeStartTmp = new Date(iYear, this.m_oDayLightStartTime.m_iMonth, this.m_oDayLightStartTime.m_iDay, this.m_oDayLightStartTime.m_iHour, this.m_oDayLightStartTime.m_iMinute, this.m_oDayLightStartTime.m_iSecond);
            }
            if (1 == this.m_oDayLightStartTime.m_iDayLightType) {
                // empty if block
            }
            return rangeStartTmp;
        }
        return rangeStartTmp;
    }

    public Date StandardTimeToLocalTime(Date oStandardTime) {
        Date oLocalTime = null;
        return oLocalTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("iZone=" + this.m_iZone).append(" ").append("iDayLightOffset" + this.m_iDayLightOffset).append(" ").append("StartTime:[" + this.m_oDayLightStartTime + "],EndTime:[" + this.m_oDayLightEndTime + "]");
        return sb.toString();
    }

    public String getZoneName() {
        return this.m_szZoneName;
    }

    public void setZoneName(String zoneName) {
        this.m_szZoneName = zoneName;
    }

    private String blurZoneNameByOffset(int offset) {
        String tempName = "";
        String[] ids = TimeZone.getAvailableIDs(this.m_iZone * 1000 * 60);
        if (ids != null && ids.length > 0) {
            tempName = ids[0];
        }
        return tempName;
    }

    private void constructDisplayName() {
        String[] ids = TimeZone.getAvailableIDs(this.m_iZone * 1000 * 60);
        TimeZone zone = null;
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                if (id == null || !id.equals(this.m_szZoneName)) continue;
                zone = TimeZone.getTimeZone(id);
                break;
            }
            if (zone != null) {
                StringBuffer name = new StringBuffer("");
                name.append("(UTC");
                name.append(EmfZoneInfo.ms2Hm(zone.getRawOffset()));
                name.append(")--");
                name.append(zone.getDisplayName());
                name.append(" (");
                name.append(this.m_szZoneName);
                name.append(")");
                this.displayInfo = name.toString();
            }
        } else {
            StringBuffer name = new StringBuffer("");
            name.append("GMT");
            name.append(EmfZoneInfo.ms2Hm(Integer.valueOf(this.m_iZone).intValue()));
            this.displayInfo = name.toString();
        }
    }

    public static String ms2Hm(long ms) {
        long h = ms / 3600000L;
        long m = ms % 3600000L / 60000L;
        if (ms < 0L) {
            String HH = Long.toString(-h);
            String mm = Long.toString(-m);
            HH = HH.length() >= 2 ? HH : "0" + HH;
            HH = "-" + HH;
            mm = mm.length() >= 2 ? mm : "0" + mm;
            return new String(HH + ":" + mm);
        }
        String HH = Long.toString(h);
        String mm = Long.toString(m);
        HH = HH.length() >= 2 ? HH : "0" + HH;
        HH = "+" + HH;
        mm = mm.length() >= 2 ? mm : "0" + mm;
        return new String(HH + ":" + mm);
    }

    public String getDisplayInfo() {
        this.constructDisplayName();
        return this.displayInfo;
    }
}

