/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.topo.adapter.message;

import com.swimap.external.resource.client.emf.EmfTopoElementIf;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EmfTopoViewEvent {
    public static final String VIEWID = "VIEWID";
    public static final String VIEWTYPEID = "VIEWTYPEID";
    public static final int SELECTED = 0;
    public static final int UNSELECTED = 1;
    public static final int SELECTION_CHANGE = 0;
    public static final int VIEW_MOUSE_LEFT_CLICK = 1;
    private int eventId = -1;
    private List oldSelObjects = null;
    private List newSelObjects = null;
    private List unSelObjects = null;
    private Map source = null;

    public EmfTopoViewEvent(int eventId, List oldSelObjects, List newSelObjects, Map source) {
        this.eventId = eventId;
        this.oldSelObjects = oldSelObjects;
        this.newSelObjects = newSelObjects;
        this.source = source;
        this.initUnSelected();
    }

    public EmfTopoViewEvent(int eventId, List selectObject, Map source) {
        this.eventId = eventId;
        this.newSelObjects = selectObject;
        this.unSelObjects = new LinkedList();
        this.source = source;
    }

    public int getEventID() {
        return this.eventId;
    }

    public List getSelectObject() {
        return this.newSelObjects;
    }

    public List getUnSelectObject() {
        return this.getUnSelectObject(0);
    }

    public Map getSourcce() {
        return this.source;
    }

    public List getObjects(int sourceType, int objectType) {
        List lRest = null;
        if (sourceType == 0) {
            lRest = this.getObjectByType(this.newSelObjects, objectType);
        } else if (sourceType == 1) {
            lRest = this.getUnSelectObject(objectType);
        }
        return lRest;
    }

    private List getUnSelectObject(int objectType) {
        LinkedList<EmfTopoElementIf> lRest = new LinkedList<EmfTopoElementIf>();
        if (null != this.unSelObjects) {
            for (EmfTopoElementIf topoElementInfo : this.unSelObjects) {
                if (null == topoElementInfo || topoElementInfo.getElementType() != objectType && 0 != objectType) continue;
                lRest.add(topoElementInfo);
            }
        }
        return lRest;
    }

    private List getObjectByType(List objects, int objectType) {
        LinkedList<EmfTopoElementIf> lRest = new LinkedList<EmfTopoElementIf>();
        if (null != objects) {
            for (EmfTopoElementIf topoElement : objects) {
                if (null == topoElement || topoElement.getElementType() != objectType && 0 != objectType) continue;
                lRest.add(topoElement);
            }
        }
        return lRest;
    }

    private void initUnSelected() {
        if (this.unSelObjects == null) {
            this.unSelObjects = new LinkedList();
            if (null != this.oldSelObjects) {
                for (EmfTopoElementIf topoElementInfo : this.oldSelObjects) {
                    if (null != this.newSelObjects && this.newSelObjects.contains(topoElementInfo) || null == topoElementInfo) continue;
                    this.unSelObjects.add(topoElementInfo);
                }
            }
        }
    }
}

