/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.topo.adapter.message;

import com.swimap.imap.common.asn1.common.AsnDayLightRuleStruc;
import com.swimap.imap.common.asn1.common.AsnZoneDayLightType;
import com.swimap.imap.common.asn1.common.AsnZoneDayOfWeek;
import com.swimap.imap.common.asn1.common.AsnZoneWeekOfMonth;
import java.math.BigInteger;

public class EmfDayLightDate {
    public static final int EMF_DAYLIGHT_SAVING_TIME_TYPE_MM_DD = 0;
    public static final int EMF_DAYLIGHT_SAVING_TIME_TYPE_MM_WW_DD = 1;
    public static final int EMF_DAYLIGHT_SAVING_TIME_TYPE_DATE_WEEK = 2;
    public int m_iDayLightType = 0;
    public int m_iMonth = 1;
    public int m_iWeekOfMonth = 1;
    public int m_iDayOfWeek = 1;
    public int m_iDay = 1;
    public int m_iHour = 0;
    public int m_iMinute = 0;
    public int m_iSecond = 0;

    public EmfDayLightDate(int iDayLightType, int iMonth, int iWeekOfMonth, int iDayOfWeek, int iDay, int iHour, int iMinute, int iSecond) {
        this.m_iDayLightType = iDayLightType;
        this.m_iMonth = iMonth;
        this.m_iWeekOfMonth = iWeekOfMonth;
        this.m_iDayOfWeek = iDayOfWeek;
        this.m_iDay = iDay;
        this.m_iHour = iHour;
        this.m_iMinute = iMinute;
        this.m_iSecond = iSecond;
    }

    public EmfDayLightDate(int iDayLightType, int iMonth, int iWeekOfMonthOrDayOfMonth, int iDayOfWeek, int iHour, int iMinute) {
        this.defaultInit();
        this.m_iDayLightType = iDayLightType;
        this.m_iMonth = iMonth;
        this.m_iHour = iHour;
        this.m_iMinute = iMinute;
        if (iDayLightType == 1) {
            this.m_iWeekOfMonth = iWeekOfMonthOrDayOfMonth;
            this.m_iDayOfWeek = iDayOfWeek;
        } else {
            this.m_iDay = iWeekOfMonthOrDayOfMonth;
            this.m_iDayOfWeek = iDayOfWeek;
        }
    }

    public EmfDayLightDate(int iDayLightType, int iMonth, int iDay, int iHour, int iMinute) {
        this.defaultInit();
        this.m_iDayLightType = iDayLightType;
        this.m_iMonth = iMonth;
        this.m_iDay = iDay;
        this.m_iHour = iHour;
        this.m_iMinute = iMinute;
    }

    public EmfDayLightDate(int iDayLightType, int iMonth, int iWeekOfMonth, int iDayOfWeek) {
        this.defaultInit();
        this.m_iDayLightType = iDayLightType;
        this.m_iMonth = iMonth;
        this.m_iWeekOfMonth = iWeekOfMonth;
        this.m_iDayOfWeek = iDayOfWeek;
    }

    public EmfDayLightDate(int iDayLightType, int iMonth, int iDay) {
        this.defaultInit();
        this.m_iDayLightType = iDayLightType;
        this.m_iMonth = iMonth;
        this.m_iDay = iDay;
    }

    public EmfDayLightDate() {
        this.defaultInit();
    }

    private void defaultInit() {
        this.m_iDayLightType = 0;
        this.m_iMonth = 1;
        this.m_iWeekOfMonth = 1;
        this.m_iDayOfWeek = 1;
        this.m_iDay = 1;
        this.m_iHour = 0;
        this.m_iMinute = 0;
        this.m_iSecond = 0;
    }

    public static AsnDayLightRuleStruc transDayLightDateToAsn(EmfDayLightDate oEmfDayLightDate) {
        AsnDayLightRuleStruc oRet = new AsnDayLightRuleStruc();
        if (oEmfDayLightDate == null) {
            oRet.iMonth = BigInteger.valueOf(0L);
            oRet.iDay = BigInteger.valueOf(0L);
            oRet.iHour = BigInteger.valueOf(0L);
            oRet.iMinute = BigInteger.valueOf(0L);
            oRet.iSecond = BigInteger.valueOf(0L);
            oRet.iWeekofMonth = new AsnZoneWeekOfMonth(0);
            oRet.iDayOfWeek = new AsnZoneDayOfWeek(0);
            oRet.iDayLightRuleType = new AsnZoneDayLightType(0);
            return oRet;
        }
        oRet.iMonth = BigInteger.valueOf(oEmfDayLightDate.m_iMonth);
        oRet.iDay = BigInteger.valueOf(oEmfDayLightDate.m_iDay);
        oRet.iHour = BigInteger.valueOf(oEmfDayLightDate.m_iHour);
        oRet.iMinute = BigInteger.valueOf(oEmfDayLightDate.m_iMinute);
        oRet.iSecond = BigInteger.valueOf(oEmfDayLightDate.m_iSecond);
        oRet.iWeekofMonth = new AsnZoneWeekOfMonth(oEmfDayLightDate.m_iWeekOfMonth);
        oRet.iDayOfWeek = new AsnZoneDayOfWeek(oEmfDayLightDate.m_iDayOfWeek);
        oRet.iDayLightRuleType = new AsnZoneDayLightType(oEmfDayLightDate.m_iDayLightType);
        return oRet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("iDayLightType=" + this.m_iDayLightType).append(" ").append("iMonth=" + this.m_iMonth).append(" ").append("iWeekOfMonth=" + this.m_iWeekOfMonth).append(" ").append("iDayOfWeek=" + this.m_iDayOfWeek).append(" ").append("iDay=" + this.m_iDay).append(" ").append("iHour=" + this.m_iHour).append(" ").append("iMinute=" + this.m_iMinute).append(" ").append("iSecond=" + this.m_iSecond).append(" ");
        return sb.toString();
    }
}

