/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.topo.adapter.message;

import com.swimap.external.topo.adapter.message.TopoFilterRule;

public class DevTypeFilterRule
implements TopoFilterRule {
    protected int m_iDevTypeID;
    protected int m_iDevVersionID;
    protected boolean m_bVisible = true;

    public DevTypeFilterRule(int iDevTypeID, int iDevVersionID, boolean bVisible) {
        this.m_iDevTypeID = iDevTypeID;
        this.m_iDevVersionID = iDevVersionID;
        this.m_bVisible = bVisible;
    }

    public DevTypeFilterRule(String sSwitch, boolean bVisible) {
        int pos = sSwitch.indexOf(":");
        String devType = sSwitch.substring("Node_".length(), pos);
        String devVer = sSwitch.substring(pos + 1);
        this.m_iDevTypeID = Integer.parseInt(devType);
        this.m_iDevVersionID = Integer.parseInt(devVer);
        this.m_bVisible = bVisible;
    }

    @Override
    public boolean isVisible() {
        return this.m_bVisible;
    }

    @Override
    public boolean match(String strSwitch) {
        boolean rest = false;
        if (strSwitch == null) {
            return rest;
        }
        if (this.m_iDevTypeID == -1 && strSwitch.startsWith("Node_")) {
            rest = true;
        }
        if (this.m_iDevTypeID != -1 && this.m_iDevVersionID == -1 && strSwitch.startsWith("Node_" + this.m_iDevTypeID)) {
            rest = true;
        }
        if (strSwitch.equals("Node_" + this.m_iDevTypeID + ":" + this.m_iDevVersionID)) {
            rest = true;
        }
        return rest;
    }

    public String toString() {
        return "Node_" + this.m_iDevTypeID + ":" + this.m_iDevVersionID;
    }
}

