/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.iview.templates.textfield.ipaddress.IPv6Address;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class EmfTopoUtilExternal {
    private static Graphics2D standardGraphics = new BufferedImage(10, 10, 2).createGraphics();
    private static FontMetrics metrics = standardGraphics.getFontMetrics();

    public static void setToolTipText(JComponent component, String text) {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        String tipText = null;
        int width = Toolkit.getDefaultToolkit().getScreenSize().width / 3;
        if (text != null && text.length() > 0) {
            tipText = text;
            if (component.getToolTipText() != null && !component.getToolTipText().equals(EmfTopoUtilExternal.formatMultiLine(tipText, width))) {
                toolTipManager.setEnabled(false);
            } else if (component.getToolTipText() == null || component.getToolTipText().trim().length() == 0) {
                toolTipManager.setEnabled(false);
            }
        } else if (text == null || text.trim().length() == 0) {
            toolTipManager.setEnabled(false);
        }
        toolTipManager.setEnabled(true);
        component.setToolTipText(EmfTopoUtilExternal.formatMultiLine(tipText, width));
    }

    public static String formatMultiLine(String text, int width) {
        if (text == null || text.equals("")) {
            return text;
        }
        String content = EmfTopoUtilExternal.getMultiLine(text, width, metrics);
        return "<html>" + content + "</html>";
    }

    private static String getMultiLine(String text, int width, FontMetrics metrics) {
        int iTextLength = metrics.stringWidth(text);
        if (iTextLength <= width) {
            return text;
        }
        int iMultiple = iTextLength / width;
        int endIndex = text.length() / iMultiple / 2;
        String s = text.substring(0, endIndex);
        while (metrics.stringWidth(s) > width) {
            s = s.substring(0, s.length() / 2);
        }
        int iSubLength = s.length();
        int i = 1;
        while (metrics.stringWidth(s) < width) {
            s = text.substring(0, iSubLength + i);
            ++i;
        }
        String next = text.substring(s.length());
        if (next.equals("")) {
            return s;
        }
        return s + "<br>" + EmfTopoUtilExternal.getMultiLine(next, width, metrics);
    }

    public static boolean isValidIP(String szIP) {
        if (szIP == null || szIP.equals("")) {
            return false;
        }
        if (szIP.indexOf("..") != -1) {
            return false;
        }
        if (String.valueOf(szIP.charAt(0)).equals(".") || String.valueOf(szIP.charAt(szIP.length() - 1)).equals(".")) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(szIP, ".");
        int iCount = st.countTokens();
        if (iCount != 4) {
            return false;
        }
        for (int i = 0; i < iCount; ++i) {
            String s = st.nextToken().trim();
            try {
                int iSeg = Integer.parseInt(s);
                if (iSeg >= 0 && iSeg <= 255) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidIP(String szIP, int nMode) {
        if (1 == nMode || -1 == nMode) {
            return false;
        }
        return IPv6Address.checkIPAddress((String)szIP, (int)nMode, (boolean)false, (boolean)false);
    }
}

