/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class EmfTableUtil {
    private static int DEFAULT_COLUMN_WIDTH = 75;

    public static void setColumnWidthAverageTable(JTable oTable, int iWidth) {
        TableColumn oColumn = null;
        TableColumnModel oCmodel = oTable.getColumnModel();
        int iTotalCount = oCmodel.getColumnCount();
        int iVisibleCount = 0;
        for (int iTmp = 0; iTmp < iTotalCount; ++iTmp) {
            oColumn = oCmodel.getColumn(iTmp);
            if (oColumn.getPreferredWidth() <= 0) continue;
            ++iVisibleCount;
        }
        for (int i = 0; i < iTotalCount; ++i) {
            oColumn = oCmodel.getColumn(i);
            if (oColumn.getPreferredWidth() <= 0) continue;
            if (iWidth > -1) {
                oColumn.setPreferredWidth(iWidth / iVisibleCount);
                continue;
            }
            oColumn.setPreferredWidth(oTable.getWidth() / iVisibleCount);
        }
    }

    public static void setColumnWidthAverageTableEx(JTable oTable, int iWidth) {
        TableColumn oColumn = null;
        TableColumnModel oCmodel = oTable.getColumnModel();
        int iTotalCount = oCmodel.getColumnCount();
        int iVisibleCount = 0;
        for (int iTmp = 0; iTmp < iTotalCount; ++iTmp) {
            oColumn = oCmodel.getColumn(iTmp);
            if (oColumn.getPreferredWidth() <= 0) continue;
            ++iVisibleCount;
        }
        if (iVisibleCount == 0) {
            return;
        }
        int iAvgWidth = 0;
        int iRemainder = 0;
        if (iWidth > -1) {
            iAvgWidth = iWidth / iVisibleCount;
            iRemainder = iWidth % iVisibleCount;
        } else {
            iAvgWidth = oTable.getWidth() / iVisibleCount;
            iRemainder = oTable.getWidth() % iVisibleCount;
        }
        for (int i = 0; i < iTotalCount; ++i) {
            oColumn = oCmodel.getColumn(i);
            if (oColumn.getPreferredWidth() <= 0) continue;
            if (iRemainder > 0) {
                oColumn.setPreferredWidth(iAvgWidth + 1);
                --iRemainder;
                continue;
            }
            oColumn.setPreferredWidth(iAvgWidth);
        }
    }

    public static void setColumnWidthUseNameAndAverageTable(JTable oTable, int iWidth) {
        TableColumn oColumn = null;
        TableColumnModel oCmodel = oTable.getColumnModel();
        int iTotalCount = oCmodel.getColumnCount();
        int iVisibleCount = 0;
        int iTotalWidth = 0;
        ArrayList<Integer> oColumnNameWidth = new ArrayList<Integer>();
        for (int index = 0; index < iTotalCount; ++index) {
            oColumn = oCmodel.getColumn(index);
            if (oColumn.getPreferredWidth() <= 0) continue;
            ++iVisibleCount;
            TableCellRenderer oRender = oColumn.getHeaderRenderer();
            Component oComp = oRender.getTableCellRendererComponent(oTable, oColumn.getHeaderValue(), false, false, 0, 0);
            iTotalWidth = iTotalWidth + oComp.getPreferredSize().width + 10;
            oColumnNameWidth.add(index, new Integer(oComp.getPreferredSize().width + 10));
        }
        if (iVisibleCount == 0) {
            return;
        }
        int iAverageWidth = 0;
        int iRemainder = 0;
        if (iWidth > -1) {
            iAverageWidth = (iWidth - iTotalWidth) / iVisibleCount;
            iRemainder = (iWidth - iTotalWidth) % iVisibleCount;
        } else {
            iAverageWidth = (oTable.getWidth() - iTotalWidth) / iVisibleCount;
            iRemainder = (oTable.getWidth() - iTotalWidth) % iVisibleCount;
        }
        if (iAverageWidth < 0) {
            iAverageWidth = 0;
        }
        for (int index = 0; index < iTotalCount; ++index) {
            oColumn = oCmodel.getColumn(index);
            if (oColumn.getPreferredWidth() <= 0) continue;
            if (iRemainder > 0) {
                oColumn.setPreferredWidth((Integer)oColumnNameWidth.get(index) + iAverageWidth + 1);
                --iRemainder;
                continue;
            }
            oColumn.setPreferredWidth((Integer)oColumnNameWidth.get(index) + iAverageWidth);
        }
    }

    public static void autoSizeAllColumnWidth(JTable jtable) {
        EmfTableUtil.autoSizeLastColumnWidth(jtable, DEFAULT_COLUMN_WIDTH);
    }

    public static void autoSizeLastColumnWidth(JTable jtable, int i) {
        if (null == jtable) {
            return;
        }
        Container container = jtable.getParent();
        if (null == container || !(container instanceof JViewport)) {
            return;
        }
        JViewport jviewport = (JViewport)container;
        Object obj = null;
        TableColumnModel tablecolumnmodel = jtable.getColumnModel();
        int j = jviewport.getExtentSize().width;
        int k = EmfTableUtil.autoSizeColumnWidth(jtable, i);
        int l = j - k;
        if (0 < l) {
            EmfTableUtil.setDiffColumnWidth(jtable, l, -1);
        }
    }

    public static int autoSizeColumnWidth(JTable jtable, int i) {
        if (null == jtable) {
            return 0;
        }
        jtable.setAutoResizeMode(0);
        DefaultTableCellRenderer defaulttablecellrenderer = null;
        TableColumnModel tablecolumnmodel = jtable.getColumnModel();
        int j = 0;
        int k = tablecolumnmodel.getColumnCount();
        for (int l = 0; l < k; ++l) {
            TableColumn tablecolumn = tablecolumnmodel.getColumn(l);
            TableCellRenderer obj = tablecolumn.getHeaderRenderer();
            if (null == obj) {
                if (null == defaulttablecellrenderer) {
                    defaulttablecellrenderer = new DefaultTableCellRenderer();
                }
                obj = defaulttablecellrenderer;
            }
            Component component = obj.getTableCellRendererComponent(jtable, tablecolumn.getHeaderValue(), false, false, 0, 0);
            int i1 = component.getPreferredSize().width + 10;
            i1 = i1 <= i ? i : i1;
            j += i1;
            tablecolumn.setPreferredWidth(i1);
        }
        return j;
    }

    public static void setDiffColumnWidth(JTable jtable, int i, int j) {
        if (null == jtable) {
            return;
        }
        int k = jtable.getColumnCount();
        int l = j;
        if (-1 == j) {
            l = k - 1;
        }
        TableColumnModel tablecolumnmodel = jtable.getColumnModel();
        TableColumn tablecolumn = tablecolumnmodel.getColumn(l);
        tablecolumn.setPreferredWidth(i + tablecolumn.getPreferredWidth());
    }
}

