/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.CommonResource;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.common.adapter.message.util.EmfSelectPrintRangeDialog;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class EmfSelectSaveAsOptionDialog
extends EmfSelectPrintRangeDialog {
    public static final int TXTFORMAT = 0;
    public static final int HTMLFORMAT = 1;
    public static final int CVSFORMAT = 2;
    public static final int XLSFORMAT = 3;
    protected JLabel pathLabel;
    protected JTextField pathInputer = new JTextField();
    protected JButton pathChooser = new JButton();
    protected HashSet fileFilterSet = new HashSet();
    private boolean checkRepeat = false;
    private int nfileFormat = 0;

    public EmfSelectSaveAsOptionDialog(Component owner, int minValue, int maxValue, String filename) {
        super(owner, minValue, maxValue);
        this.setTitle(CommonResource.getString("COMMON_DIALOG_SAVE_OPTION"));
        this.fileFilterSet.add(FileChooser.CSV_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.HTML_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.TXT_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.XLS_FILECHOOSERFILTER);
        String pathStr = CommonResource.getString("COMMON_DIALOG_FILE_NAME");
        this.pathLabel = new JLabel(pathStr + ":");
        String absoluteRootPath = CommonUtil.getDefaultSavePath();
        if (!absoluteRootPath.endsWith(File.separator)) {
            absoluteRootPath = absoluteRootPath + File.separator;
        }
        this.pathInputer.setText(absoluteRootPath + filename);
        this.pathInputer.setEditable(false);
        this.pathChooser.setMaximumSize(new Dimension(29, 21));
        this.pathChooser.setMinimumSize(new Dimension(29, 21));
        this.pathChooser.setPreferredSize(new Dimension(29, 21));
        this.pathChooser.setText("...");
        JPanel pathPanel = new JPanel(new BorderLayout(4, 4));
        pathPanel.add((Component)this.pathInputer, "Center");
        pathPanel.add((Component)this.pathChooser, "East");
        this.addProperty(this.pathLabel, pathPanel);
        this.setSize(350, 180);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setUIName();
        this.addListeners();
    }

    private void setUIName() {
        String className = this.getClass().getName();
        this.pathLabel.setName(className + ".pathLabel");
        this.pathInputer.setName(className + ".pathInputer");
        this.pathChooser.setName(className + ".pathChooser");
    }

    private void addListeners() {
        this.pathChooser.addActionListener(this);
        this.pathInputer.addFocusListener(this);
        this.pathChooser.addFocusListener(this);
    }

    public String getFileName() {
        return this.pathInputer.getText();
    }

    public int getStartRow() {
        return super.getResult()[0];
    }

    public int getEndRow() {
        return super.getResult()[1];
    }

    public int getFileFormat() {
        return this.nfileFormat;
    }

    public boolean hasCheckRepeat() {
        return this.checkRepeat;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (object == this.pathChooser) {
            this.doChoosePath();
        }
        super.actionPerformed(e);
    }

    public String getFileFormatName() {
        switch (this.nfileFormat) {
            case 0: {
                return "txt";
            }
            case 2: {
                return "csv";
            }
            case 1: {
                return "html";
            }
            case 3: {
                return "xls";
            }
        }
        return "";
    }

    @Override
    protected void doOK() {
        String sFileName = this.pathInputer.getText();
        if (sFileName == null || sFileName.length() == 0) {
            String message = CommonResource.getString("COMMON_DIALOG_INPUTFILENAME");
            EmfOptionPane.showMessageDialog(this, message);
            return;
        }
        String sName = sFileName.substring(sFileName.lastIndexOf(System.getProperty("file.separator")));
        if (0 > sName.indexOf(".")) {
            sFileName = sFileName + ".txt";
        }
        this.pathInputer.setText(sFileName);
        String extendFileName = sFileName.substring(sFileName.lastIndexOf(".") + 1);
        extendFileName = extendFileName.toLowerCase();
        if (sFileName.endsWith(".txt")) {
            this.nfileFormat = 0;
        } else if (sFileName.endsWith(".html")) {
            this.nfileFormat = 1;
        } else if (sFileName.endsWith(".csv")) {
            this.nfileFormat = 2;
        } else if (sFileName.endsWith(".xls")) {
            this.nfileFormat = 3;
        } else {
            sFileName = sFileName + ".txt";
            this.pathInputer.setText(sFileName);
            String message = CommonResource.getString("COMMON_DIALOG_INPUTFILENAME");
            EmfOptionPane.showMessageDialog(this, message);
            return;
        }
        super.doOK();
    }

    protected void doChoosePath() {
        int returnVal;
        File fDir = new File(System.getProperty("user.dir"));
        String filePath = fDir.getAbsolutePath();
        SaveFileChooser chooser = new SaveFileChooser(filePath);
        chooser.setTitle(this.getTitle());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.CSV_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.HTML_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.TXT_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.XLS_FILECHOOSERFILTER);
        chooser.setSelectedFile(new File(this.pathInputer.getText()));
        FileFilter fileFilter = this.getFileFilter(this.pathInputer.getText());
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        }
        if ((returnVal = chooser.showSaveDialog((Component)this)) == 0) {
            String usedFilter;
            String fileName = chooser.getSelectFilePath();
            FileFilter filter = chooser.getFileFilter();
            if (filter instanceof FileChooserFilter) {
                FileChooserFilter fileChooserFilter = (FileChooserFilter)filter;
                usedFilter = (String)fileChooserFilter.getAllFilters().get(0);
                usedFilter = "." + usedFilter;
            } else {
                usedFilter = "";
            }
            if (!fileName.toLowerCase().endsWith(usedFilter)) {
                fileName = fileName + usedFilter;
            }
            this.pathInputer.setText(fileName);
            this.checkRepeat = true;
        } else {
            this.checkRepeat = false;
        }
    }

    private FileFilter getFileFilter(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        String extender = filename.substring(index + 1);
        for (FileChooserFilter tmpFileFilter : this.fileFilterSet) {
            LinkedList fileFilterList = tmpFileFilter.getAllFilters();
            ListIterator fileFilter = fileFilterList.listIterator();
            while (fileFilter.hasNext()) {
                if (!extender.equals((String)fileFilter.next())) continue;
                return tmpFileFilter;
            }
        }
        return null;
    }

    public boolean showWithConfirm() {
        this.setVisible(true);
        return super.getResult() != null;
    }
}

