/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.CommonResource;
import com.swimap.external.common.adapter.message.util.EmfBaseDialog;
import com.swimap.external.common.adapter.message.util.EmfIntegerTextField;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.common.adapter.message.util.WindowOpenedListener4FocusText;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EmfSelectPrintRangeDialog
extends EmfBaseDialog
implements ActionListener,
FocusListener {
    protected JLabel minLabel;
    protected EmfIntegerTextField minInputer;
    protected JLabel maxLabel;
    protected EmfIntegerTextField maxInputer;
    protected JButton okButton;
    protected JButton cancelButton;
    private JPanel buttonsPanel = new JPanel(new FlowLayout(2));
    private JPanel contentPanel = new JPanel(new GridBagLayout());
    private int[] results = new int[3];

    public EmfSelectPrintRangeDialog(Component owner, int minValue, int maxValue) {
        super(JOptionPane.getFrameForComponent(owner), true);
        this.setDefaultCloseOperation(2);
        this.setTitle(CommonResource.getString("COMMON_DIALOG_RANGE_SELECT"));
        this.results[0] = minValue;
        this.results[1] = maxValue;
        this.results[2] = maxValue - minValue + 1;
        String fromStr = CommonResource.getString("COMMON_DIALOG_START_ROW");
        this.minLabel = new JLabel(fromStr + ":");
        this.minInputer = new EmfIntegerTextField(minValue, maxValue, minValue);
        this.addProperty(this.minLabel, this.minInputer);
        String toStr = CommonResource.getString("COMMON_DIALOG_END_ROW");
        this.maxLabel = new JLabel(toStr + ":");
        this.maxInputer = new EmfIntegerTextField(minValue, maxValue, maxValue);
        this.addProperty(this.maxLabel, this.maxInputer);
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(-4, -4, -4, -4));
        String okStr = CommonResource.getString("COMMON_DIALOG_OK");
        this.okButton = new JButton(okStr);
        this.okButton.setPreferredSize(new Dimension(80, 21));
        this.buttonsPanel.add(this.okButton);
        this.setEnterButton(this.okButton);
        String cancelStr = CommonResource.getString("COMMON_DIALOG_CANCEL");
        this.cancelButton = new JButton(cancelStr);
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.buttonsPanel.add(this.cancelButton);
        this.setEscapeButton(this.cancelButton);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.contentPanel, "Center");
        container.add((Component)this.buttonsPanel, "South");
        this.setSize(285, 140);
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setResizable(false);
        this.setUIName();
        this.addListeners();
    }

    private void setUIName() {
        String className = this.getClass().getName();
        this.minLabel.setName(className + ".fromLabel");
        this.minInputer.setName(className + ".fromTextField");
        this.maxLabel.setName(className + ".toLabel");
        this.maxInputer.setName(className + ".toTextField");
        this.contentPanel.setName(className + ".contentPanel");
        this.okButton.setName(className + ".okButton");
        this.cancelButton.setName(className + ".cannelButton");
        this.buttonsPanel.setName(className + ".buttonsPanel");
    }

    private void addListeners() {
        this.addWindowListener(new WindowOpenedListener4FocusText(this.minInputer){

            @Override
            public void windowClosing(WindowEvent e) {
                EmfSelectPrintRangeDialog.this.doCancel();
            }
        });
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.minInputer.addFocusListener(this);
        this.maxInputer.addFocusListener(this);
    }

    protected void addProperty(JLabel label, JComponent component) {
        int propertyCount = this.contentPanel.getComponentCount() / 2;
        if (label == null) {
            label = new JLabel();
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = propertyCount;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 12, 6);
        this.contentPanel.add((Component)label, constraints);
        if (component == null) {
            component = new JPanel();
        }
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = propertyCount;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 6, 12, 0);
        this.contentPanel.add((Component)component, constraints);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object object = e.getSource();
        if (this.okButton.equals(object)) {
            this.doOK();
        } else if (this.cancelButton.equals(object)) {
            this.doCancel();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.minInputer.verify();
        this.maxInputer.verify();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    protected void doOK() {
        if (!this.minInputer.verify() || !this.maxInputer.verify() || this.minInputer.getValue() > this.maxInputer.getValue()) {
            String message = CommonResource.getString("COMMON_DIALOG_TIPOFROWS");
            EmfOptionPane.showMessageDialog(this, message);
            this.minInputer.requestFocus();
        } else {
            this.results[0] = this.minInputer.getValue();
            this.results[1] = this.maxInputer.getValue();
            this.results[2] = this.results[1] - this.results[0] + 1;
            this.dispose();
        }
    }

    protected void doCancel() {
        this.results = null;
        this.dispose();
    }

    public int[] getResult() {
        return this.results;
    }
}

