/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.EmfCommonRes;
import com.swimap.external.common.adapter.message.util.EmfFixSizeFileChooser;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.common.adapter.message.util.EmfValueVerifier;
import com.swimap.external.common.adapter.message.util.WindowOpenedListener4FocusText;
import com.swimap.imap12.util.InmIntegerTextField;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.FileChooser;
import com.swimap.iview.util.FileChooserFilter;
import com.swimap.iview.util.SaveFileChooser;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.XYConstraints;
import com.swimap.iview.util.XYLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class EmfSaveToFileDialog
extends JDialog {
    private static final int MAX_FILENAME_LENGTH = 256;
    protected String INVALID_FILENAME = "\\/:*?\"<>|~!@#$%^&(){}[],<>;`-=+'";
    String sFileName;
    JPanel rangePanel = new JPanel();
    Border rangeBorder;
    TitledBorder rangeTitledBorder;
    XYLayout xYLayout1 = new XYLayout();
    JLabel fromLabel = new JLabel();
    JLabel toLabel = new JLabel();
    InmIntegerTextField fromTextField = new InmIntegerTextField();
    InmIntegerTextField toTextField = new InmIntegerTextField();
    JLabel pathLabel = new JLabel();
    protected JTextField pathTextField = new JTextField();
    JButton chooseFileButton = new JButton();
    String messageTitle = null;
    boolean isConfirmed = false;
    GridBagLayout rangeGridBagLayout = new GridBagLayout();
    private String m_szInitFileName = null;
    int nfileFormat = -1;
    private int startRow;
    private int endRow;
    private boolean checkRepeat = false;
    JPanel jPanel1 = new JPanel();
    JButton cancelButton = new JButton();
    JButton OKButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    private HashSet fileFilterSet = new HashSet();
    private String sUserEncoding = "UTF-8";

    public EmfSaveToFileDialog(Component parentComponent, int startRow, int endRow, String messageTitle, String szFileName) {
        super(JOptionPane.getFrameForComponent(parentComponent), EmfSaveToFileDialog.getString("COMMON_DIALOG_SAVE_OPTION"), true);
        this.messageTitle = messageTitle;
        this.startRow = startRow;
        this.endRow = endRow;
        this.m_szInitFileName = szFileName;
        this.fromTextField.setRange(1, this.endRow);
        this.toTextField.setRange(1, this.endRow);
        this.fromTextField.setInputVerifier((InputVerifier)new EmfValueVerifier());
        this.toTextField.setInputVerifier((InputVerifier)new EmfValueVerifier());
        this.fileFilterSet.add(FileChooser.CSV_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.HTML_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.TXT_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.XLS_FILECHOOSERFILTER);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pathTextField.setEditable(false);
        this.setSize(new Dimension(360, 200));
        this.setResizable(false);
    }

    public EmfSaveToFileDialog(Dialog window, int startRow, int endRow, String messageTitle, String szFileName) {
        super(window, EmfSaveToFileDialog.getString("COMMON_DIALOG_SAVE_OPTION"), true);
        this.messageTitle = messageTitle;
        this.startRow = startRow;
        this.endRow = endRow;
        this.m_szInitFileName = szFileName;
        this.fromTextField.setRange(1, this.endRow);
        this.toTextField.setRange(1, this.endRow);
        this.fromTextField.setInputVerifier((InputVerifier)new EmfValueVerifier());
        this.toTextField.setInputVerifier((InputVerifier)new EmfValueVerifier());
        this.fileFilterSet.add(FileChooser.CSV_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.HTML_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.TXT_FILECHOOSERFILTER);
        this.fileFilterSet.add(FileChooser.XLS_FILECHOOSERFILTER);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pathTextField.setEditable(false);
        this.setSize(new Dimension(360, 200));
        this.setResizable(false);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.rangePanel.setLayout(this.rangeGridBagLayout);
        this.fromLabel.setText(EmfSaveToFileDialog.getString("COMMON_DIALOG_START_ROW") + ":");
        this.toLabel.setText(EmfSaveToFileDialog.getString("COMMON_DIALOG_END_ROW") + ":");
        this.fromTextField.setText(String.valueOf(this.startRow));
        this.toTextField.setText(String.valueOf(this.endRow));
        this.fromTextField.requestFocusInWindow();
        String absoluteRootPath = CommonUtil.getDefaultSavePath();
        this.pathTextField.setText(absoluteRootPath + System.getProperty("file.separator") + this.m_szInitFileName);
        this.pathLabel.setText(EmfSaveToFileDialog.getString("COMMON_DIALOG_FILE_NAME") + ":");
        this.chooseFileButton.setMaximumSize(new Dimension(29, 21));
        this.chooseFileButton.setMinimumSize(new Dimension(29, 21));
        this.chooseFileButton.setPreferredSize(new Dimension(29, 21));
        this.chooseFileButton.setText(". . . ");
        this.chooseFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmfSaveToFileDialog.this.chooseFileButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText(EmfSaveToFileDialog.getString("COMMON_DIALOG_CANCEL"));
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmfSaveToFileDialog.this.cancelButton_actionPerformed();
            }
        });
        this.OKButton.setText(EmfSaveToFileDialog.getString("COMMON_DIALOG_OK"));
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmfSaveToFileDialog.this.OKButton_actionPerformed();
            }
        });
        this.OKButton.setPreferredSize(new Dimension(80, 21));
        this.getContentPane().add((Component)this.rangePanel, "Center");
        this.rangePanel.add((Component)this.fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.rangePanel.add((Component)this.toLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.rangePanel.add((Component)this.fromTextField, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 12, 0, 12), 0, 0));
        this.rangePanel.add((Component)this.toTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 12), 0, 0));
        this.rangePanel.add((Component)this.pathLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.rangePanel.add((Component)this.pathTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 12, 0, 0), 0, 0));
        this.rangePanel.add((Component)this.chooseFileButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(15, 5, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.setLayout((LayoutManager)this.xYLayout1);
        this.jPanel1.setPreferredSize(new Dimension(360, 40));
        this.jPanel1.add((Component)this.OKButton, new XYConstraints(180, 10, 80, 21));
        this.jPanel1.add((Component)this.cancelButton, new XYConstraints(264, 10, 80, 21));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                EmfSaveToFileDialog.this.cancelButton_actionPerformed();
            }
        });
        this.addWindowListener(new WindowOpenedListener4FocusText((JTextComponent)this.fromTextField));
        this.setEnterAndEscPress(this, this.OKButton, this.cancelButton);
        this.setNameForAuto();
    }

    private void setNameForAuto() {
        if (this.fromTextField != null) {
            this.fromTextField.setName("EmfSaveToFileDialog_fromTextField");
        }
        if (this.toTextField != null) {
            this.toTextField.setName("EmfSaveToFileDialog_toTextField");
        }
        if (this.pathTextField != null) {
            this.pathTextField.setName("EmfSaveToFileDialog_pathTextField");
        }
        if (this.chooseFileButton != null) {
            this.chooseFileButton.setName("EmfSaveToFileDialog_chooseFileButton");
        }
        if (this.OKButton != null) {
            this.OKButton.setName("EmfSaveToFileDialog_OKButton");
        }
        if (this.cancelButton != null) {
            this.cancelButton.setName("EmfSaveToFileDialog_cancelButton");
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EmfSaveToFileDialog.this.cancelButton.requestFocus();
                }
            });
        }
        super.setVisible(b);
    }

    public void setEnterAndEscPress(JDialog dialog, final JButton enterButton, final JButton escButton) {
        if (null != enterButton) {
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
            dialog.getRootPane().getInputMap(2).put(enter, "ENTER");
            dialog.getRootPane().getActionMap().put("ENTER", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (enterButton.isEnabled()) {
                        enterButton.requestFocus();
                    }
                    enterButton.doClick();
                }
            });
        }
        if (null != escButton) {
            KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
            dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
            dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    escButton.doClick();
                }
            });
        }
    }

    protected void chooseFileButton_actionPerformed(ActionEvent e) {
        int returnVal;
        File fDir = new File(System.getProperty("user.dir"));
        String filePath = fDir.getAbsolutePath();
        SaveFileChooser chooser = new SaveFileChooser(filePath);
        chooser.setEncodingEnabled(true);
        chooser.setTitle(this.getTitle());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.CSV_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.HTML_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.TXT_FILECHOOSERFILTER);
        chooser.addChoosableFileFilter((FileFilter)FileChooser.XLS_FILECHOOSERFILTER);
        chooser.setSelectedFile(new File(this.pathTextField.getText()));
        FileFilter fileFilter = this.getFileFilter(this.pathTextField.getText());
        if (fileFilter != null) {
            chooser.setFileFilter(fileFilter);
        }
        if ((returnVal = chooser.showSaveDialog((Component)this)) == 0) {
            String usedFilter;
            String fileName = chooser.getSelectFilePath();
            FileFilter filter = chooser.getFileFilter();
            if (filter instanceof FileChooserFilter) {
                FileChooserFilter fileChooserFilter = (FileChooserFilter)filter;
                usedFilter = (String)fileChooserFilter.getAllFilters().get(0);
                usedFilter = "." + usedFilter;
            } else {
                usedFilter = "";
            }
            if (!fileName.toLowerCase().endsWith(usedFilter)) {
                fileName = fileName + usedFilter;
            }
            this.pathTextField.setText(fileName);
            this.checkRepeat = true;
        } else {
            this.checkRepeat = false;
        }
        this.sUserEncoding = chooser.getUserEncoding();
    }

    private FileFilter getFileFilter(String fileName) {
        String fileExtend = null;
        int fileExtendIndex = fileName.lastIndexOf(".");
        if (fileExtendIndex == -1) {
            return null;
        }
        fileExtend = fileName.substring(fileExtendIndex + 1);
        for (FileChooserFilter tmpFileFilter : this.fileFilterSet) {
            LinkedList fileFilterList = tmpFileFilter.getAllFilters();
            ListIterator fileFilter = fileFilterList.listIterator();
            while (fileFilter.hasNext()) {
                if (!fileExtend.equals((String)fileFilter.next())) continue;
                return tmpFileFilter;
            }
        }
        return null;
    }

    public String getUserEncoding() {
        return this.sUserEncoding;
    }

    public int getFileFormat() {
        return this.nfileFormat;
    }

    public String getFileName() {
        return this.sFileName;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public boolean hasCheckRepeat() {
        return this.checkRepeat;
    }

    public static boolean validateInput(String startRow, String endRow) {
        if (startRow.length() == 0 || endRow.length() == 0) {
            return false;
        }
        int start = Integer.parseInt(startRow);
        int end = Integer.parseInt(endRow);
        if (start == 0 || end == 0) {
            return false;
        }
        return start <= end;
    }

    void OKButton_actionPerformed() {
        String toText;
        this.sFileName = this.pathTextField.getText();
        if (null == this.sFileName || 0 == this.sFileName.length()) {
            EmfOptionPane.showMessageDialog(this, EmfSaveToFileDialog.getString("COMMON_DIALOG_INPUTFILENAME"));
            this.isConfirmed = false;
            return;
        }
        String fromText = this.fromTextField.getText();
        if (!EmfSaveToFileDialog.validateInput(fromText, toText = this.toTextField.getText())) {
            EmfOptionPane.showMessageDialog(this, EmfSaveToFileDialog.getString("COMMON_DIALOG_TIPOFROWS"));
            this.isConfirmed = false;
            return;
        }
        this.startRow = Integer.parseInt(fromText);
        this.endRow = Integer.parseInt(toText);
        String sName = this.sFileName.substring(this.sFileName.lastIndexOf(System.getProperty("file.separator")));
        if (0 > sName.indexOf(".")) {
            this.sFileName = this.sFileName + ".txt";
        }
        this.pathTextField.setText(this.sFileName);
        String extendFileName = this.sFileName.substring(this.sFileName.lastIndexOf(".") + 1);
        extendFileName = extendFileName.toLowerCase();
        if (extendFileName.equals("txt")) {
            this.nfileFormat = 0;
        } else if (extendFileName.equals("html")) {
            this.nfileFormat = 1;
        } else if (extendFileName.equals("csv")) {
            this.nfileFormat = 2;
        } else if (extendFileName.equals("xls")) {
            this.nfileFormat = 3;
        } else {
            EmfOptionPane.showMessageDialog(this, EmfSaveToFileDialog.getString("COMMON_DIALOG_INPUTFILENAME"));
            this.isConfirmed = false;
            return;
        }
        this.isConfirmed = true;
        this.dispose();
    }

    void cancelButton_actionPerformed() {
        this.isConfirmed = false;
        this.dispose();
    }

    public boolean showWithConfirm() {
        ScreenToolKit.centerLocateToScreen((Component)this);
        this.setVisible(true);
        return this.isConfirmed;
    }

    public static String getString(String szKey) {
        String szDesc = null;
        try {
            EmfCommonRes.geInstance();
            szDesc = EmfCommonRes.getString(szKey);
        }
        catch (Exception e) {
            return szKey;
        }
        return szDesc;
    }

    class filenamechooser
    extends EmfFixSizeFileChooser {
        @Override
        public void approveSelection() {
            String strValidName;
            String selectFileName = this.getSelectedFile().getAbsolutePath();
            FileFilter filter = this.getFileFilter();
            if (filter instanceof TexFilter) {
                if (!selectFileName.toLowerCase().endsWith(".txt")) {
                    selectFileName = selectFileName + ".txt";
                }
            } else if (filter instanceof HtmlFilter) {
                if (!selectFileName.toLowerCase().endsWith(".htm") && !selectFileName.toLowerCase().endsWith(".html")) {
                    selectFileName = selectFileName + ".html";
                }
            } else if (filter instanceof CsvFilter) {
                if (!selectFileName.toLowerCase().endsWith(".csv")) {
                    selectFileName = selectFileName + ".csv";
                }
            } else if (filter instanceof XlsFilter) {
                if (!selectFileName.toLowerCase().endsWith(".xls")) {
                    selectFileName = selectFileName + ".xls";
                }
            } else if (!(selectFileName.toLowerCase().endsWith(".txt") || selectFileName.toLowerCase().endsWith(".html") || selectFileName.toLowerCase().endsWith(".csv") || selectFileName.toLowerCase().endsWith(".xls"))) {
                selectFileName = selectFileName + ".txt";
            }
            if ((strValidName = selectFileName.substring(selectFileName.indexOf(".") + 1)).indexOf(".") >= 0) {
                EmfOptionPane.showMessageDialog(this, EmfSaveToFileDialog.getString("Filename_Invalid"));
                return;
            }
            if (selectFileName.getBytes().length > 256) {
                EmfOptionPane.showMessageDialog(this, EmfSaveToFileDialog.getString("Pathname_Invalid"));
                return;
            }
            super.approveSelection();
        }

        public filenamechooser(File fDir, int iFileNameLength, String strInvalidString) {
            super(fDir);
            this.initInputTextField(iFileNameLength, strInvalidString);
        }

        private void initInputTextField(int iFileNameLength, String strInvalidString) {
            JTextField textField = this.getTextField(this);
            if (textField != null) {
                textField.setDocument(new limitDocument(textField, iFileNameLength, strInvalidString));
            }
        }

        public JTextField getTextField(Component comp) {
            if (comp instanceof JTextField) {
                return (JTextField)comp;
            }
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                for (int i = 0; i < cont.getComponentCount(); ++i) {
                    JTextField field = this.getTextField(cont.getComponent(i));
                    if (field == null) continue;
                    return field;
                }
            }
            return null;
        }

        class limitDocument
        extends PlainDocument {
            private JTextComponent textComponent;
            int limitLength = 0;
            String strLimitInput = "";

            public limitDocument(JTextComponent tc, int iLength, String stLimitInput) {
                this.textComponent = tc;
                this.strLimitInput = stLimitInput;
                this.limitLength = iLength;
            }

            @Override
            public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
                if (s == null) {
                    super.insertString(offset, s, attributeSet);
                    return;
                }
                String prevStr = this.textComponent.getText();
                if (prevStr.getBytes().length + s.getBytes().length > this.limitLength) {
                    return;
                }
                String st = null;
                for (int i = 0; i < s.length(); ++i) {
                    st = s.substring(i, i + 1);
                    if (this.strLimitInput.indexOf(st) < 0) continue;
                    return;
                }
                super.insertString(offset, s, attributeSet);
            }
        }
    }

    public class HtmlFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true == f.getName().endsWith(".html") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Html File(*.html)";
        }
    }

    public class XlsFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true == f.getName().endsWith(".xls") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Excel File(*.xls)";
        }
    }

    public class CsvFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true == f.getName().endsWith(".csv") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Excel File(*.csv)";
        }
    }

    public class TexFilter
    extends FileFilter {
        @Override
        public boolean accept(File f) {
            return true == f.getName().endsWith(".txt") || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Txt File(*.txt)";
        }
    }
}

