/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.iview.templates.print.PrintSupportor;
import com.swimap.iview.templates.print.tools.TablePrintable;
import com.swimap.iview.util.DebugTracer;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFrame;

public class EmfPrintSupportor
extends PrintSupportor {
    public static final int TXTFORMAT = 0;
    public static final int HTMLFORMAT = 1;
    public static final int CVSFORMAT = 2;
    public static final int XLSFORMAT = 3;

    public static boolean emfSaveToFile(JFrame mainFrame, String fileName, TablePrintable tablePrintable, String fileType, boolean hasCheckRepeat) {
        if (!EmfPrintSupportor.isFileVaild(mainFrame, fileName, fileType, hasCheckRepeat)) {
            return false;
        }
        return EmfPrintSupportor.saveToFileNoCheck((JFrame)mainFrame, (String)fileName, (TablePrintable)tablePrintable, (String)fileType);
    }

    private static boolean emfIsFileNameValid(String sFileName) {
        String sTrueFileName;
        String invalidStr = "*\"?/|<>";
        int i = sFileName.lastIndexOf(System.getProperty("file.separator"));
        int j = sFileName.lastIndexOf(".");
        if (j >= 0 && (sTrueFileName = sFileName.substring(i + 1, j)) != null && !sTrueFileName.equals("")) {
            char[] ac = sTrueFileName.toCharArray();
            if (ac[0] == '.' || ac[sTrueFileName.length() - 1] == '.') {
                return false;
            }
            for (int k = 0; k < sTrueFileName.length(); ++k) {
                if (invalidStr.indexOf(String.valueOf(sTrueFileName.charAt(k))) < 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFileVaild(JFrame mainFrame, String fileName, String fileType, boolean hasCheckRepeat) {
        String fileNameIgnoreCase = fileName.toLowerCase();
        if (fileType.equals("html")) {
            if (!fileNameIgnoreCase.endsWith(".html") && !fileNameIgnoreCase.endsWith(".htm")) {
                fileName = new StringBuffer(fileName).append(".html").toString();
            }
        } else if (fileType.equals("txt")) {
            if (!fileNameIgnoreCase.endsWith(".txt")) {
                fileName = new StringBuffer(fileName).append(".txt").toString();
            }
        } else if (fileType.equals("csv")) {
            if (!fileNameIgnoreCase.endsWith(".csv")) {
                fileName = new StringBuffer(fileName).append(".csv").toString();
            }
        } else if (fileType.equals("xls")) {
            if (!fileNameIgnoreCase.endsWith(".xls")) {
                fileName = new StringBuffer(fileName).append(".xls").toString();
            }
        } else if (fileType.equals("xml")) {
            if (!fileNameIgnoreCase.endsWith(".xml")) {
                fileName = new StringBuffer(fileName).append(".xml").toString();
            }
        } else {
            EmfOptionPane.showErrorMessageDialog(mainFrame, res.getString("FILE_TYPE_NOT_HTML_TXT"));
            return false;
        }
        if (!EmfPrintSupportor.emfIsFileNameValid(fileName)) {
            EmfOptionPane.showErrorMessageDialog(mainFrame, res.getString("FILENAME_ERROR"));
            return false;
        }
        File file = new File(fileName);
        if (!hasCheckRepeat && file.exists()) {
            if (file.canWrite()) {
                int option = EmfOptionPane.showConfirmDialog((Component)mainFrame, res.getString("confirmTitle"), res.getString("coverFile"));
                if (option != 0) {
                    return false;
                }
            } else {
                EmfOptionPane.showErrorMessageDialog(mainFrame, res.getString("readOnly"));
                return false;
            }
        }
        BufferedWriter out = null;
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            out = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception e) {
            DebugTracer.trace((Exception)e);
            EmfOptionPane.showErrorMessageDialog(mainFrame, res.getString("SAVE_EXIT"));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
            }
            catch (Exception e) {
                DebugTracer.trace((Exception)e);
            }
        }
        return true;
    }
}

