/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.iview.templates.spinbox.NumericSpinnerModel;
import com.swimap.iview.templates.spinbox.Spinner;
import com.swimap.iview.templates.spinbox.SpinnerModel;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class EmfNumericSpinner
extends Spinner {
    private static final long serialVersionUID = 3131283614952488162L;
    private int step = 1;
    private boolean isNullEnabled = false;
    private int min = 0;
    private int max = 0;
    private List changeListener = new ArrayList();
    FocusListener focusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            int currentValue = Integer.parseInt(EmfNumericSpinner.this.getValue().toString());
            if (currentValue < EmfNumericSpinner.this.getMinValue()) {
                EmfNumericSpinner.this.setValue(new Integer(EmfNumericSpinner.this.getMinValue()));
            } else if (currentValue > EmfNumericSpinner.this.getMaxValue()) {
                EmfNumericSpinner.this.setValue(new Integer(EmfNumericSpinner.this.getMaxValue()));
            } else {
                JTextField field = (JTextField)EmfNumericSpinner.this.getEditor();
                if (field.getText().trim().equals("") || field.getText().trim().equals("-")) {
                    field.setText(String.valueOf(currentValue));
                }
            }
        }
    };

    public EmfNumericSpinner() {
    }

    public EmfNumericSpinner(int min, int max) {
        this();
        this.setRange(min, max);
    }

    public EmfNumericSpinner(int min, int max, int width, int height) {
        this();
        this.setRange(min, max);
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setValueWithoutActivateListener(Object value) {
        for (ChangeListener l : this.changeListener) {
            this.getModel().removeChangeListener(l);
        }
        this.setValue(value);
        for (ChangeListener l : this.changeListener) {
            this.getModel().addChangeListener(l);
        }
    }

    public void setDisplayingValueWithoutActivateListener(int value) {
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        this.setValueWithoutActivateListener(new Integer(value));
    }

    public void setValue(Object value) {
        if (value instanceof Integer) {
            super.setValue(value);
        } else if (value instanceof BigInteger) {
            String i = value.toString();
            super.setValue((Object)Integer.valueOf(i));
        } else if (value instanceof String) {
            super.setValue((Object)new Integer(value.toString()));
        } else {
            throw new RuntimeException("Only Integer, BigInteger or String can be used here  " + value.getClass());
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener.add(l);
        this.getModel().addChangeListener(l);
    }

    public void removeAllChangeListener() {
        for (ChangeListener l : this.changeListener) {
            this.getModel().removeChangeListener(l);
        }
        this.changeListener = new ArrayList();
    }

    public void setDisplayingValue(int value) {
        if (value < this.min || value > this.max) {
            value = this.min;
        }
        this.setValue(new Integer(value));
    }

    public BigInteger getBigIntegerValue() {
        Object o = this.getValue();
        Integer i = (Integer)o;
        return BigInteger.valueOf(i.intValue());
    }

    public int getIntValue() {
        Object o = this.getValue();
        Integer i = (Integer)o;
        return i;
    }

    public void setRange(int min, int max, int step) {
        this.setStep(step);
        this.setRange(min, max);
    }

    public void setRange(int min, int max) {
        this.min = min;
        this.max = max;
        int currentValue = Integer.parseInt(this.getValue().toString());
        if (currentValue < min || currentValue > max) {
            currentValue = min;
        }
        NumericSpinnerModel model = new NumericSpinnerModel(currentValue, min, max, this.step);
        this.setModel(model);
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.min).append(", ").append(this.max).append("]");
        this.setToolTipText(sb.toString());
        if (!this.isNullEnabled) {
            this.unRegisterFocusListener(this.focusListener);
            this.registerFocusListener(this.focusListener);
        }
    }

    public void setModel(NumericSpinnerModel model) {
        for (ChangeListener l : this.changeListener) {
            model.addChangeListener(l);
            this.getModel().removeChangeListener(l);
        }
        super.setModel((SpinnerModel)model);
    }

    public void registerFocusListener(FocusListener listener) {
        JTextField field = (JTextField)this.getEditor();
        field.addFocusListener(listener);
    }

    public void unRegisterFocusListener(FocusListener listener) {
        JTextField field = (JTextField)this.getEditor();
        field.removeFocusListener(listener);
    }

    public int getMinValue() {
        return this.min;
    }

    public int getMaxValue() {
        return this.max;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
        this.setRange(this.min, this.max);
    }

    public void requestFocus() {
        super.getEditor().requestFocus();
    }
}

