/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.EmfIntegerDocument;
import javax.swing.JTextField;

public class EmfIntegerTextField
extends JTextField {
    private int min;
    private int max;
    private int dvalue;

    public EmfIntegerTextField(int min, int max, int dvalue) {
        this.min = min;
        this.max = max;
        this.dvalue = dvalue > max ? max : (dvalue < min ? min : dvalue);
        this.setDocument(new EmfIntegerDocument(0, max));
        this.setText(String.valueOf(this.dvalue));
    }

    public boolean verify() {
        int value = this.getValue();
        if (value >= this.min && value <= this.max) {
            return true;
        }
        this.revert();
        return false;
    }

    public void revert() {
        this.setText(String.valueOf(this.dvalue));
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getDefaultValue() {
        return this.dvalue;
    }

    public int getValue() {
        String text = this.getText();
        if (text.matches("\\d+")) {
            return Integer.parseInt(text);
        }
        return 0;
    }
}

