/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class EmfIntegerDocument
extends PlainDocument {
    private static final String REGULATION = "0|([1-9]\\d*)";
    private int min = 0;
    private int max = Integer.MAX_VALUE;
    private boolean isReplacing = false;

    public EmfIntegerDocument(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.validateInsertString(offs, 0, str)) {
            super.insertString(offs, str, a);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        if (this.isReplacing) {
            return;
        }
        while (this.getLength() > 1 && "0".equals(this.getText(0, 1))) {
            this.remove(0, 1);
        }
    }

    @Override
    public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.validateInsertString(offset, length, text)) {
            try {
                this.isReplacing = true;
                super.replace(offset, length, text, attrs);
            }
            catch (BadLocationException e) {
                throw e;
            }
            finally {
                this.isReplacing = false;
            }
        }
    }

    private boolean validateInsertString(int offset, int length, String text) throws BadLocationException {
        if (text == null || text.equals("")) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getText(0, offset));
        sb.append(text);
        sb.append(this.getText(offset += length, this.getLength() - offset));
        String fText = sb.toString();
        if (fText.matches(REGULATION)) {
            int value = Integer.parseInt(fText);
            return value >= this.min && value <= this.max;
        }
        return false;
    }
}

