/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.CommonUtilities;
import com.swimap.external.common.adapter.message.util.EmfCommonRes;
import com.swimap.external.common.adapter.message.util.GuiStandard;
import com.swimap.external.common.adapter.message.util.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class EmfDialog
extends JDialog {
    public static final String ACTION_OK = "ACTION_OK";
    public static final String ACTION_APPLY = "ACTION_APPLY";
    public static final String ACTION_CANCEL = "ACTION_CANCEL";
    public static final Color BORDER_COLOR = GuiStandard.BORDER_COLOR;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected ActionListener actionListener;
    protected WindowListener windowListener;
    private boolean isUILayouted;

    public EmfDialog(Frame owner) throws HeadlessException {
        this(owner, false);
    }

    public EmfDialog(Frame owner, boolean modal) throws HeadlessException {
        this(owner, null, modal);
    }

    public EmfDialog(Frame owner, String title) throws HeadlessException {
        this(owner, title, false);
    }

    public EmfDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        EmfCommonRes.geInstance();
        this.okButton = new JButton(EmfCommonRes.getString("OK"));
        EmfCommonRes.geInstance();
        this.applyButton = new JButton(EmfCommonRes.getString("APPLY"));
        EmfCommonRes.geInstance();
        this.cancelButton = new JButton(EmfCommonRes.getString("CANCEL"));
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmfDialog.this.proccessActions(e);
            }
        };
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EmfDialog.this.cancelButton.doClick();
            }
        };
        this.isUILayouted = false;
        this.initActions();
    }

    public EmfDialog(Dialog owner) throws HeadlessException {
        this(owner, false);
    }

    public EmfDialog(Dialog owner, boolean modal) throws HeadlessException {
        this(owner, null, modal);
    }

    public EmfDialog(Dialog owner, String title) throws HeadlessException {
        this(owner, title, false);
    }

    public EmfDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        EmfCommonRes.geInstance();
        this.okButton = new JButton(EmfCommonRes.getString("OK"));
        EmfCommonRes.geInstance();
        this.applyButton = new JButton(EmfCommonRes.getString("APPLY"));
        EmfCommonRes.geInstance();
        this.cancelButton = new JButton(EmfCommonRes.getString("CANCEL"));
        this.actionListener = new /* invalid duplicate definition of identical inner class */;
        this.windowListener = new /* invalid duplicate definition of identical inner class */;
        this.isUILayouted = false;
        this.initActions();
    }

    private void initActions() {
        this.okButton.setActionCommand(ACTION_OK);
        this.applyButton.setActionCommand(ACTION_APPLY);
        this.cancelButton.setActionCommand(ACTION_CANCEL);
        this.applyButton.setMnemonic('A');
        this.okButton.addActionListener(this.actionListener);
        this.applyButton.addActionListener(this.actionListener);
        this.cancelButton.addActionListener(this.actionListener);
        this.applyButton.setEnabled(false);
        this.addWindowListener(this.windowListener);
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.okButton.setName(name + ".okButton");
        this.applyButton.setName(name + ".applyButton");
        this.cancelButton.setName(name + ".cancelButton");
    }

    @Override
    public void show() {
        this.layoutUI();
        this.cancelButton.requestFocus();
        super.show();
    }

    protected void layoutUI() {
        if (!this.isUILayouted) {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add(this.getButtonPanel(), "South");
        }
        this.getContentPane().add(this.getContentPanel(), "Center");
        this.isUILayouted = true;
    }

    protected JButton[] getButtons() {
        CommonUtilities.bindDefaultKeyActions(this, this.okButton, this.cancelButton);
        return new JButton[]{this.okButton, this.cancelButton, this.applyButton};
    }

    protected Component getButtonPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(12, 5, 9, 5));
        btnPanel.setLayout(new FlowLayout(2, 4, 0));
        JButton[] buttons = this.getButtons();
        GuiUtils.formatButtons(buttons);
        if (null != buttons) {
            for (int i = 0; i < buttons.length; ++i) {
                if (null == buttons[i]) continue;
                btnPanel.add(buttons[i]);
            }
        }
        return btnPanel;
    }

    @Override
    public void dispose() {
        this.okButton.removeActionListener(this.actionListener);
        this.applyButton.removeActionListener(this.actionListener);
        this.cancelButton.removeActionListener(this.actionListener);
        this.removeWindowListener(this.windowListener);
        super.dispose();
    }

    protected abstract Component getContentPanel();

    protected abstract void proccessActions(ActionEvent var1);
}

