/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.EmfCompTitledBorder;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class EmfCompTitledPane
extends JPanel {
    protected EmfCompTitledBorder compTitledBorder;
    protected JComponent title;
    protected Container content;

    public EmfCompTitledPane() {
        this(new JLabel("Title"), null);
    }

    public EmfCompTitledPane(JComponent component, Border border) {
        this(component, new JPanel(), border);
    }

    public EmfCompTitledPane(JComponent component, Container container, Border border) {
        this.title = component;
        this.compTitledBorder = new EmfCompTitledBorder(border, component);
        this.setBorder(this.compTitledBorder);
        this.content = container;
        this.setLayout(new BorderLayout());
        if (null != component) {
            this.add(component);
        }
        if (null != this.content) {
            this.add(this.content);
        }
    }

    public JComponent getTitleComponent() {
        return this.title;
    }

    public void setTitleComponent(JComponent newComponent) {
        this.remove(this.title);
        this.add(newComponent);
        this.compTitledBorder.setTitleComponent(newComponent);
        this.title = newComponent;
    }

    public Container getContentPane() {
        return this.content;
    }

    public void setContentPane(Container container) {
        if (null != this.content) {
            this.remove(this.content);
        }
        this.content = container;
        if (null != this.content) {
            this.add(this.content);
        }
        this.validate();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = this.compTitledBorder.getComponentRect(rect, insets);
        this.title.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        this.content.setBounds(rect);
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.title == null) {
            return super.getMaximumSize();
        }
        Dimension maxDim = this.title.getMaximumSize();
        maxDim.width += EmfCompTitledBorder.getTextInsetH() * 2;
        if (this.content != null) {
            Dimension contentMaxDim = this.content.getMaximumSize();
            maxDim.width = Math.max(maxDim.width, contentMaxDim.width);
            maxDim.height += contentMaxDim.height;
        }
        Insets insets = this.getInsets();
        maxDim.width += insets.left + insets.right;
        maxDim.height += insets.bottom;
        return maxDim;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.title == null) {
            return super.getMinimumSize();
        }
        Dimension minDim = this.title.getMinimumSize();
        minDim.width += EmfCompTitledBorder.getTextInsetH() * 2;
        if (this.content != null) {
            Dimension contentMinDim = this.content.getMinimumSize();
            minDim.width = Math.max(minDim.width, contentMinDim.width);
            minDim.height += contentMinDim.height;
        }
        Insets insets = this.getInsets();
        minDim.width += insets.left + insets.right;
        minDim.height += insets.bottom;
        return minDim;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.title == null) {
            return super.getPreferredSize();
        }
        Dimension preDim = this.title.getPreferredSize();
        preDim.width += EmfCompTitledBorder.getTextInsetH() * 2;
        if (this.content != null) {
            Dimension contentPreDim = this.content.getPreferredSize();
            preDim.width = Math.max(preDim.width, contentPreDim.width);
            preDim.height += contentPreDim.height;
        }
        Insets insets = this.getInsets();
        preDim.width += insets.left + insets.right;
        preDim.height += insets.bottom;
        return preDim;
    }
}

