/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.eam.client.EamClientInterface;
import com.swimap.iview.framework.Main;
import com.swimap.iview.util.log.IviewLogger;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class EmfCommonLimitTextField
extends JTextField {
    private static final IviewLogger logger = IviewLogger.getLogger(EmfCommonLimitTextField.class, (String)"TM");
    public static final int LEN_EX = -1;
    public static final int CONTAIN_LIMIT_CHAR = -2;
    public static final int NOT_IN_VALID_CHAR = -3;
    private final int ILIMIT_LENGTH = 30;
    public static final String ST_LIMIT_INPUT = "~`!@#$%^&*(){[}]|\\:;'\"<,>.?/\uff5e\u00b7\uff01\u25ce\uff03\uffe5\uff05\u2026\u2026\u203b\u00d7\uff08\uff09\u300e\u3010\u300f\u3011\u00f7\u00a7\uff1a\uff1b\u2018\u201c\u201d\u300a\uff0c\u300b\u3002\uff1f\u3001";
    protected int limitLength = 0;
    protected String stLimitInput = "";
    protected String stValidInput = null;

    public EmfCommonLimitTextField() {
        this(0, null);
    }

    public EmfCommonLimitTextField(int iLimitLength) {
        this(iLimitLength, null);
    }

    public EmfCommonLimitTextField(String stLimitInput) {
        this(0, stLimitInput);
    }

    public EmfCommonLimitTextField(int iLimitLength, String stLimitInput) {
        this(iLimitLength, stLimitInput, null);
    }

    public EmfCommonLimitTextField(int iLimitLength, String stLimitInput, String stValidInput) {
        this.limitLength = iLimitLength <= 0 ? this.ILIMIT_LENGTH : iLimitLength;
        boolean isSupportSpecialCodeFlag = false;
        try {
            EamClientInterface eam = (EamClientInterface)Main.instance().getModuleManager().getLocalModule("eam");
            isSupportSpecialCodeFlag = eam.isSupportSpecialCodeFlag();
        }
        catch (Exception e) {
            logger.trace((Object)"EmfCommonLimitTextField() RpcCommunicationMgr.isSupportSpecialCodeFlag() error.", (Throwable)e);
            isSupportSpecialCodeFlag = false;
        }
        this.stLimitInput = isSupportSpecialCodeFlag ? "" : (stLimitInput == null ? ST_LIMIT_INPUT : stLimitInput);
        this.stValidInput = stValidInput;
        this.setDocument(new limitDocument(this));
    }

    public void setLimitLength(int length) {
        if (length <= 0) {
            return;
        }
        this.limitLength = length;
    }

    public void setLimitInputString(String stLimit) {
        this.stLimitInput = stLimit;
    }

    public void setValidInputString(String stValid) {
        this.stValidInput = stValid;
    }

    protected void notifyInvalid(int reason) {
    }

    class limitDocument
    extends PlainDocument {
        private JTextComponent textComponent;

        public limitDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            int i;
            if (s == null) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            String prevStr = this.textComponent.getText();
            if (prevStr.getBytes().length + s.getBytes().length > EmfCommonLimitTextField.this.limitLength) {
                EmfCommonLimitTextField.this.notifyInvalid(-1);
                return;
            }
            String st = null;
            for (i = 0; i < s.length(); ++i) {
                st = s.substring(i, i + 1);
                if (st.charAt(0) == '\t') {
                    return;
                }
                if (EmfCommonLimitTextField.this.stLimitInput.indexOf(st) < 0) continue;
                EmfCommonLimitTextField.this.notifyInvalid(-2);
                return;
            }
            if (EmfCommonLimitTextField.this.stValidInput != null && EmfCommonLimitTextField.this.stValidInput.length() > 0) {
                for (i = 0; i < s.length(); ++i) {
                    st = s.substring(i, i + 1);
                    if (EmfCommonLimitTextField.this.stValidInput.indexOf(st) != -1) continue;
                    EmfCommonLimitTextField.this.notifyInvalid(-3);
                    return;
                }
            }
            super.insertString(offset, s, attributeSet);
        }
    }
}

