/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

public class EmfColorFilter
extends RGBImageFilter {
    private boolean brighter = true;
    private int percent = 50;
    private double degree = 2.0;
    private Color color = Color.red;
    private Color DefaultBorder;
    private Color border = this.DefaultBorder = new Color(40, 40, 40);

    public EmfColorFilter(boolean brighter, int percent, double degree, Color color) {
        this.brighter = brighter;
        this.percent = percent;
        this.degree = degree;
        if (color == null) {
            throw new NullPointerException("color value is null");
        }
        this.color = color;
        this.canFilterIndexColorModel = true;
        this.border = Color.white;
    }

    public void setBorderColor(Color oColor) {
        this.border = oColor;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int gray = (int)((0.3 * (double)(rgb >> 16 & 0xFF) + 0.59 * (double)(rgb >> 8 & 0xFF) + 0.11 * (double)(rgb & 0xFF)) / 3.0);
        gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
        if (gray < 0) {
            gray = 0;
        }
        if (gray > 255) {
            gray = 255;
        }
        gray = this.sharpen(gray);
        int intColor = this.color.getRGB();
        int r = (intColor >> 16 & 0xFF) * gray / 255;
        int g = (intColor >> 8 & 0xFF) * gray / 255;
        int b = (intColor & 0xFF) * gray / 255;
        Color mcolor = new Color(rgb);
        if (mcolor.equals(Color.white)) {
            if (this.border.equals(Color.white)) {
                return this.sharpen(this.DefaultBorder.getRGB());
            }
            return this.border.getRGB();
        }
        return rgb & 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    private int sharpen(int c) {
        int returnValue;
        double midPoint = 127.5;
        double x = (double)c / midPoint;
        if (c < 128) {
            double y = c == 0 ? 0.0 : Math.pow(x, this.degree);
            returnValue = (int)((midPoint + 0.001) * y);
        } else {
            double y = c == 255 ? 2.0 : 2.0 - Math.pow(2.0 - x, this.degree);
            returnValue = (int)((midPoint + 0.001) * y);
        }
        return returnValue;
    }
}

