/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.common.adapter.message.util;

import com.swimap.external.common.adapter.message.util.CommonLogger;
import com.swimap.external.common.adapter.message.util.EmfCommonRes;
import com.swimap.external.common.adapter.message.util.EmfOptionPane;
import com.swimap.external.common.adapter.message.util.EmfProgressDlg;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.templates.textfield.ipaddress.IPv6Address;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class CommonUtilities {
    public static final int IPV4 = 4;
    public static final int IPV6 = 6;
    public static final String ROOT = "ROOT";
    private static final String OPERATE_SUCCESS = "OPERATE_SUCCESS";
    private static final String OPERATE_FAILD = "OPERATE_FAILD";

    public static void bindDefaultKeyActions(JDialog dialog, final JButton enterButton, final JButton escButton) {
        if (null != dialog) {
            CommonLogger.debug("bind default keys");
            if (null != enterButton) {
                CommonLogger.debug("bind enter key");
                KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
                dialog.getRootPane().getInputMap(2).put(enter, "ENTER");
                dialog.getRootPane().getActionMap().put("ENTER", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        enterButton.requestFocusInWindow();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                enterButton.doClick();
                            }
                        });
                    }
                });
            }
            if (null != escButton) {
                CommonLogger.debug("bind esc key");
                KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
                dialog.getRootPane().getInputMap(2).put(escape, "ESCAPE");
                dialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        escButton.doClick();
                    }
                });
            }
        }
    }

    public static String getConfigItem(String sFile, String sItemPath) {
        CommonLogger.debug(sFile + ":" + sItemPath);
        String rest = null;
        if (null != sItemPath) {
            try {
                CommStyleInfo oStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(sFile);
                String[] sItemPaths = sItemPath.split(":");
                DescContainer desc = CommonUtilities.getConfigElement(oStyleInfo, sItemPaths);
                rest = desc.getParasItemValue(sItemPaths[sItemPaths.length - 1]);
            }
            catch (Exception e) {
                CommonLogger.error(sFile + ":" + sItemPath, e);
            }
        }
        return rest;
    }

    public static boolean setConfigItem(String sFile, String sItemPath, String value) {
        CommonLogger.debug(sFile + ":" + sItemPath + ":" + value);
        boolean rest = false;
        if (null != sItemPath) {
            try {
                DescContainer desc;
                CommStyleInfo oStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(sFile);
                String[] sItemPaths = sItemPath.split(":");
                if (null != oStyleInfo && null != (desc = CommonUtilities.getConfigElement(oStyleInfo, sItemPaths)) && (rest = desc.setParasItem(sItemPaths[sItemPaths.length - 1], value))) {
                    CommonLogger.debug("write back:" + sFile + ":" + sItemPath + ":" + value);
                    oStyleInfo.writeBack();
                    rest = true;
                }
            }
            catch (Exception e) {
                CommonLogger.error(sFile + ":" + sItemPath + "::" + value, e);
            }
        }
        return rest;
    }

    public static DescContainer getConfigElement(String sFile, String sItemPath) {
        DescContainer rest = null;
        if (null != sItemPath) {
            try {
                sItemPath = sItemPath + ":DUMMYSECTION";
                String[] sItemPaths = sItemPath.split(":");
                CommStyleInfo oStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(sFile);
                if (null != oStyleInfo) {
                    rest = CommonUtilities.getConfigElement(oStyleInfo, sItemPaths);
                }
            }
            catch (Exception e) {
                CommonLogger.error(sFile + ":" + sItemPath, e);
            }
        }
        return rest;
    }

    public static AreaDescContainer getConfigArea(String sFile, String sAreaName) {
        AreaDescContainer rest = null;
        if (null != sAreaName) {
            try {
                CommStyleInfo oStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(sFile);
                if (null != oStyleInfo) {
                    rest = ROOT.equals(sAreaName) ? oStyleInfo.getAreaDescContainer(0) : oStyleInfo.getAreaDescContainer(sAreaName);
                }
            }
            catch (Exception e) {
                CommonLogger.error(sFile + ":" + sAreaName, e);
            }
        }
        return rest;
    }

    private static DescContainer getConfigElement(CommStyleInfo oStyleInfo, String[] sItemPath) {
        DescContainer rest = null;
        try {
            if (null != oStyleInfo && null != sItemPath && sItemPath.length > 2) {
                AreaDescContainer oArea = null;
                DescContainer oContainer = null;
                oArea = ROOT.equals(sItemPath[0]) ? oStyleInfo.getAreaDescContainer(0) : oStyleInfo.getAreaDescContainer(sItemPath[0]);
                if (null != oArea) {
                    oContainer = oArea.getDescContainer(sItemPath[1]);
                    try {
                        for (int i = 2; i < sItemPath.length - 1; ++i) {
                            oContainer = oContainer.getDescContainer(sItemPath[i]);
                        }
                        rest = oContainer;
                    }
                    catch (Exception e) {
                        CommonLogger.error(oStyleInfo + ":" + sItemPath, e);
                    }
                }
            }
        }
        catch (Exception e) {
            CommonLogger.error(oStyleInfo + ":" + sItemPath, e);
        }
        return rest;
    }

    public static void setFrameFrozen(Component component, boolean isFrozen) {
        if (component != null) {
            Window window = null;
            window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (window instanceof RootPaneContainer) {
                ScreenToolKit.setComponentCursorBusy((RootPaneContainer)((RootPaneContainer)((Object)window)), (boolean)isFrozen);
            }
        }
    }

    public static void synInvoke(final Runnable run, final Component component, boolean showProgressDialog) {
        EmfProgressDlg progressDlg;
        Component parent = CommonUtilities.getTopComponent(component);
        EmfProgressDlg emfProgressDlg = progressDlg = parent instanceof Dialog ? new EmfProgressDlg((Dialog)parent) : new EmfProgressDlg((Frame)parent);
        if (showProgressDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenToolKit.centerLocateToScreen((Component)progressDlg);
                    progressDlg.setVisible(true);
                }
            });
        }
        SyncCommand sc = new SyncCommand(){

            public Object call() throws Exception {
                CommonUtilities.setFrameFrozen(component, true);
                run.run();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommonUtilities.setFrameFrozen(component, false);
                        progressDlg.setVisible(false);
                    }
                });
                return null;
            }
        };
        sc.startCall();
    }

    private static Component getTopComponent(Component component) {
        Component parent = null;
        Component component2 = parent = component instanceof Window ? component : SwingUtilities.getWindowAncestor(component);
        if (!(parent instanceof Frame) && !(parent instanceof Dialog)) {
            parent = FrameworkUtilities.getMainFrame();
        }
        return parent;
    }

    public static void showErrorDialog(String message) {
        CommonUtilities.showErrorDialog(null, message, null);
    }

    public static void showErrorDialog(Window wndParent, String message) {
        CommonUtilities.showErrorDialog(wndParent, message, null);
    }

    public static void showErrorDialog(String message, Object data) {
        CommonUtilities.showErrorDialog(null, message, data);
    }

    public static void showErrorDialog(Window wndParent, String message, Object data) {
        EmfCommonRes.geInstance();
        CommonUtilities.showErrorDialog(wndParent, EmfCommonRes.getString("Error"), message, data);
    }

    public static void showErrorDialog(Window wndParent, String title, String message, Object detail) {
        if (detail instanceof String[][]) {
            String[] stringArray = new String[2];
            EmfCommonRes.geInstance();
            stringArray[0] = EmfCommonRes.getString("OPER_OBJ");
            EmfCommonRes.geInstance();
            stringArray[1] = EmfCommonRes.getString("REASON");
            String[] column = stringArray;
            CommonUtilities.showErrorDialog(wndParent, title, message, column, (String[][])detail);
        } else if (null != detail) {
            CommonUtilities.showMessageDialog(wndParent, 0, title, message, detail.toString());
        } else {
            EmfOptionPane.showErrorMessageDialog(null, message);
        }
    }

    public static void showErrorDialog(Window oParent, String title, String message, String[] column, String[][] data) {
        if (null != data && null != column) {
            String[][] headedTable = new String[data.length + 1][column.length];
            headedTable[0] = column;
            System.arraycopy(data, 0, headedTable, 1, data.length);
            CommonUtilities.showMessageDialog(oParent, 0, title, message, headedTable);
        }
    }

    public static void showErrorDialog(Dialog oParent, String title, String message, String[] column, String[][] data) {
        if (null != data && null != column) {
            String[][] headedTable = new String[data.length + 1][column.length];
            headedTable[0] = column;
            System.arraycopy(data, 0, headedTable, 1, data.length);
            CommonUtilities.showMessageDialog(oParent, 0, title, message, headedTable);
        }
    }

    public static void showMessageDialog(Window oParent, int iStyle, String title, String message, Object detail) {
        if (null == oParent) {
            oParent = FrameworkUtilities.getMainFrame();
        } else if (!oParent.isVisible()) {
            oParent = FrameworkUtilities.getMainFrame();
        }
        DetailMessageDlg dlg = null;
        if (oParent instanceof Dialog) {
            dlg = new DetailMessageDlg((Dialog)oParent, title, (Object)message, iStyle, detail);
        } else if (oParent instanceof Frame) {
            dlg = new DetailMessageDlg((Frame)oParent, title, (Object)message, iStyle, detail);
        } else {
            return;
        }
        dlg.show();
    }

    public static boolean isValidEMail(String mail) {
        boolean rest = false;
        if (null != mail) {
            rest = Pattern.matches("[^\\@]+@\\w+(\\.\\w+)*", mail);
        }
        return rest;
    }

    public static boolean isValidPhone(String phone) {
        boolean rest = false;
        if (null != phone) {
            String validChars = "[0-9\\+\\-\\*\\#]*";
            rest = Pattern.matches(validChars + "(\\(" + validChars + "\\))*" + validChars, phone);
        }
        return rest;
    }

    public static boolean isValidIP(String IP, int ver) {
        boolean rest = false;
        if (4 == ver) {
            rest = IPv6Address.checkIPAddress((String)IP, (int)3, (boolean)false, (boolean)false);
        } else if (6 == ver) {
            rest = IPv6Address.checkIPAddress((String)IP, (int)0, (boolean)true, (boolean)false) || IPv6Address.checkIPAddress((String)IP, (int)2, (boolean)true, (boolean)false) || IPv6Address.checkIPAddress((String)IP, (int)1, (boolean)true, (boolean)false);
        }
        return rest;
    }

    public static boolean isValidIPV4(String IP) {
        return CommonUtilities.isValidIP(IP, 4);
    }

    public static boolean isValidIPV6(String IP) {
        return CommonUtilities.isValidIP(IP, 6);
    }

    public static boolean isValidIP(String IP) {
        return CommonUtilities.isValidIPV4(IP) || CommonUtilities.isValidIPV6(IP);
    }

    public static boolean isValidFile(String sfile) {
        boolean rest = false;
        if (null != sfile) {
            File file = new File(sfile);
            rest = file.exists();
            Object var2_2 = null;
        }
        return rest;
    }

    public static String displayOperaResult(String opera, boolean isSuccess) {
        String key = "";
        String result = "";
        key = isSuccess ? OPERATE_SUCCESS : OPERATE_FAILD;
        try {
            EmfCommonRes.geInstance();
            result = EmfCommonRes.getString(key, opera);
        }
        catch (Exception e) {
            CommonLogger.debug(e.getMessage());
        }
        return result;
    }
}

