/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.compare.common;

import com.huawei.dc.compare.common.CBitMatrix;
import com.huawei.dc.compare.common.CIntMatrix;
import com.huawei.dc.compare.common.StructMatchPair;
import com.huawei.dc.compare.common.StructPointInMatrix;
import java.util.ArrayList;

public class CMatrixManagement {
    private int m_iOriginB = 0;
    private int m_iOriginC = 0;
    private CBitMatrix m_oBitMatrix;
    private CIntMatrix m_oIntMatrix;
    private int m_iMatrixSize;

    public CMatrixManagement(int iMatrixSize) {
        this.m_oBitMatrix = new CBitMatrix(iMatrixSize, iMatrixSize);
        this.m_oIntMatrix = new CIntMatrix(iMatrixSize, iMatrixSize);
        this.m_iMatrixSize = iMatrixSize;
    }

    void setOrigin(int iPosB, int iPosC) {
        if (iPosB > this.m_iOriginB && iPosC > this.m_iOriginC && iPosB < this.m_iOriginB + this.m_iMatrixSize && iPosC < this.m_iOriginC + this.m_iMatrixSize) {
            this.m_oBitMatrix.moveAreatoOrigin(iPosB - this.m_iOriginB, iPosC - this.m_iOriginC);
        } else {
            this.m_oBitMatrix.clear();
        }
        this.m_iOriginB = iPosB;
        this.m_iOriginC = iPosC;
    }

    int[] getOrigin() {
        int[] result = new int[]{this.m_iOriginB, this.m_iOriginC};
        return result;
    }

    void setMatchPairToMatrix(int iPosB, int iPosC) {
        if (iPosB >= this.m_iOriginB && iPosC >= this.m_iOriginC) {
            this.m_oBitMatrix.setValue(iPosB - this.m_iOriginB, iPosC - this.m_iOriginC, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean getResultWithEndPoint(ArrayList vecMatchPair, int iEndPosB, int iEndPosC) {
        try {
            int uiBoardSize = 1;
            if (iEndPosB < this.m_iOriginB) return false;
            uiBoardSize = iEndPosB - this.m_iOriginB + 1;
            if (iEndPosC < this.m_iOriginC) return false;
            if (iEndPosC - this.m_iOriginC >= uiBoardSize) {
                uiBoardSize = iEndPosC - this.m_iOriginC + 1;
            }
            if (!this.SetIntMatrixWithBitMatrix(uiBoardSize, uiBoardSize)) {
                return false;
            }
            ArrayList<StructPointInMatrix> deqStPoint = new ArrayList<StructPointInMatrix>();
            StructPointInMatrix stPointEnd = new StructPointInMatrix();
            stPointEnd.uiRow = uiBoardSize - 1;
            stPointEnd.uiCol = uiBoardSize - 1;
            StructPointInMatrix stPointMax = new StructPointInMatrix();
            stPointMax.uiRow = stPointEnd.uiRow;
            stPointMax.uiCol = stPointEnd.uiCol;
            StructPointInMatrix stPointPath = new StructPointInMatrix();
            stPointPath.uiRow = stPointEnd.uiRow;
            stPointPath.uiCol = stPointEnd.uiCol;
            StructPointInMatrix stPointExc = new StructPointInMatrix();
            int iMaxMatchsize = this.m_oIntMatrix.getValue(stPointEnd.uiRow, stPointEnd.uiCol);
            boolean bFindNextMax = false;
            boolean bRowFirst = true;
            while (iMaxMatchsize > 0 && (stPointPath.uiRow > 0 || stPointPath.uiCol > 0)) {
                bFindNextMax = false;
                if (bRowFirst) {
                    if (stPointPath.uiCol > 0) {
                        bRowFirst = false;
                    }
                } else if (stPointPath.uiRow > 0) {
                    --stPointPath.uiRow;
                    bRowFirst = true;
                } else {
                    --stPointPath.uiCol;
                }
                int iExc = 1;
                int iOutofRangeCount = 0;
                stPointExc.uiRow = --stPointPath.uiRow;
                stPointExc.uiCol = --stPointPath.uiCol;
                while (iOutofRangeCount < 2) {
                    block20: {
                        if (bRowFirst && !(iExc & true) || !bRowFirst && iExc & true) {
                            if (stPointPath.uiRow + (iExc >> 1) <= stPointEnd.uiRow && stPointPath.uiCol >= iExc >> 1) {
                                stPointExc.uiRow = stPointPath.uiRow + (iExc >> 1);
                                stPointExc.uiCol = stPointPath.uiCol - (iExc >> 1);
                                iOutofRangeCount = 0;
                                break block20;
                            } else {
                                ++iOutofRangeCount;
                                ++iExc;
                                continue;
                            }
                        }
                        if (stPointPath.uiRow >= iExc >> 1 && stPointPath.uiCol + (iExc >> 1) <= stPointEnd.uiCol) {
                            stPointExc.uiRow = stPointPath.uiRow - (iExc >> 1);
                            stPointExc.uiCol = stPointPath.uiCol + (iExc >> 1);
                            iOutofRangeCount = 0;
                        } else {
                            ++iOutofRangeCount;
                            ++iExc;
                            continue;
                        }
                    }
                    if (this.m_oIntMatrix.getValue(stPointExc.uiRow, stPointExc.uiCol) == iMaxMatchsize) {
                        bFindNextMax = true;
                        break;
                    }
                    ++iExc;
                }
                if (bFindNextMax) {
                    stPointMax.uiRow = stPointExc.uiRow;
                    stPointMax.uiCol = stPointExc.uiCol;
                    continue;
                }
                StructPointInMatrix stPointResult = new StructPointInMatrix();
                stPointResult.uiRow = stPointMax.uiRow;
                stPointResult.uiCol = stPointMax.uiCol;
                deqStPoint.add(stPointResult);
                if (0 == stPointMax.uiRow || 0 == stPointMax.uiCol) break;
                stPointEnd.uiRow = stPointMax.uiRow - 1;
                stPointEnd.uiCol = stPointMax.uiCol - 1;
                stPointMax.uiRow = stPointEnd.uiRow;
                stPointMax.uiCol = stPointEnd.uiCol;
                iMaxMatchsize = this.m_oIntMatrix.getValue(stPointEnd.uiRow, stPointEnd.uiCol);
                stPointPath.uiRow = stPointEnd.uiRow;
                stPointPath.uiCol = stPointEnd.uiCol;
            }
            StructMatchPair stMatchPair = new StructMatchPair();
            stMatchPair.iPosB = this.m_iOriginB;
            stMatchPair.iPosC = this.m_iOriginC;
            for (int i = deqStPoint.size() - 1; i >= 0; --i) {
                StructPointInMatrix tempDepStPoint = (StructPointInMatrix)deqStPoint.get(i);
                stMatchPair.iPosB = tempDepStPoint.getIPosB() + this.m_iOriginB;
                stMatchPair.iPosC = tempDepStPoint.getIPosC() + this.m_iOriginC;
                StructMatchPair MatchPairresult = new StructMatchPair();
                MatchPairresult.iPosB = tempDepStPoint.getIPosB() + this.m_iOriginB;
                MatchPairresult.iPosC = tempDepStPoint.getIPosC() + this.m_iOriginC;
                vecMatchPair.add(MatchPairresult);
            }
            if (stMatchPair.iPosB < this.m_iOriginB + this.m_iMatrixSize / 3 && stMatchPair.iPosC < this.m_iOriginB + this.m_iMatrixSize / 3) {
                this.setOrigin(this.m_iOriginB + this.m_iMatrixSize / 3, this.m_iOriginC + this.m_iMatrixSize / 3);
                return true;
            }
            this.setOrigin(stMatchPair.iPosB, stMatchPair.iPosC);
            return true;
        }
        catch (Exception e) {
            System.out.println("getResultWithEndPoint Exception:" + e);
        }
        return true;
    }

    boolean SetIntMatrixWithBitMatrix(int uiRowSize, int uiColSize) {
        if (uiRowSize > this.m_iMatrixSize || uiColSize > this.m_iMatrixSize) {
            return false;
        }
        try {
            int[] pUINTLst = new int[uiColSize];
            int size = pUINTLst.length;
            for (int i = 0; i < size; ++i) {
                pUINTLst[i] = 0;
            }
            int[] pUINTCur = new int[uiColSize];
            int size2 = pUINTCur.length;
            for (int i = 0; i < size2; ++i) {
                pUINTCur[i] = 0;
            }
            for (int uiRow = 0; uiRow < uiRowSize; ++uiRow) {
                for (int uiCol = 0; uiCol < uiColSize; ++uiCol) {
                    int iMaxMatchValue = 0;
                    int iLstPosValue = 0;
                    if (uiCol > 0) {
                        iMaxMatchValue = pUINTCur[uiCol - 1];
                        iLstPosValue = pUINTLst[uiCol - 1];
                    }
                    if (pUINTLst[uiCol] > iMaxMatchValue) {
                        iMaxMatchValue = pUINTLst[uiCol];
                    }
                    pUINTCur[uiCol] = iMaxMatchValue;
                    if (iMaxMatchValue != iLstPosValue || !this.m_oBitMatrix.getValue(uiRow, uiCol)) continue;
                    pUINTCur[uiCol] = iLstPosValue + 1;
                }
                this.m_oIntMatrix.setRowValue(uiRow, 0, uiColSize, pUINTCur);
                for (int i = 0; i < uiColSize; ++i) {
                    pUINTLst[i] = pUINTCur[i];
                }
            }
            pUINTLst = null;
            pUINTCur = null;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return true;
    }

    CBitMatrix getCBitMatrix() {
        return this.m_oBitMatrix;
    }

    void clean() {
        this.m_oBitMatrix.clear();
    }
}

