/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.compare.common;

import com.huawei.dc.compare.common.CMatrixManagement;
import com.huawei.dc.compare.common.StructMatchBlock;
import com.swimap.iview.util.DebugTracer;
import java.util.ArrayList;

public class CMatchBlockStorage {
    private int m_iOriginB;
    private int m_iOriginC;
    private int m_iMatrixSize;
    int DirectBlockB = 0;
    ArrayList m_lstMatchBlockB;
    ArrayList m_lstMatchBlockC;
    CMatrixManagement m_oMatrixManagement;

    public CMatchBlockStorage(int iMatrixSize) {
        this.m_iMatrixSize = iMatrixSize;
        this.setOrigin(0, 0);
        this.m_lstMatchBlockB = new ArrayList();
        this.m_lstMatchBlockC = new ArrayList();
        this.m_oMatrixManagement = new CMatrixManagement(iMatrixSize);
    }

    void setOrigin(int iPosB, int iPosC) {
        this.m_iOriginB = iPosB;
        this.m_iOriginC = iPosC;
    }

    int[] getOrigin() {
        int[] result = new int[]{this.m_iOriginB, this.m_iOriginC};
        return result;
    }

    void pushMatchBlock(int iPosB, int iPosC, int iBlockSize, int iDirect) {
        StructMatchBlock stMatchBlock = new StructMatchBlock();
        stMatchBlock.setIPosB(iPosB);
        stMatchBlock.setIPosC(iPosC);
        stMatchBlock.setIBlockSize(iBlockSize);
        if (iBlockSize > 0) {
            if (this.DirectBlockB == iDirect) {
                this.m_lstMatchBlockB.add(stMatchBlock);
            } else {
                this.m_lstMatchBlockC.add(stMatchBlock);
            }
        }
    }

    void eraseMatchBlock(int iPosB, int iPosC) {
        try {
            int i = 0;
            while (i < this.m_lstMatchBlockB.size()) {
                if (((StructMatchBlock)this.m_lstMatchBlockB.get((int)i)).iPosB >= iPosB) {
                    while (this.m_lstMatchBlockB.size() > i) {
                        this.m_lstMatchBlockB.remove(i);
                    }
                    break;
                }
                if (((StructMatchBlock)this.m_lstMatchBlockB.get((int)i)).iPosC >= iPosC) {
                    this.m_lstMatchBlockB.remove(i);
                    continue;
                }
                DebugTracer.trace((String)"do nothing...");
                ++i;
            }
            int j = 0;
            while (j < this.m_lstMatchBlockC.size()) {
                if (((StructMatchBlock)this.m_lstMatchBlockC.get((int)j)).iPosC >= iPosC) {
                    while (this.m_lstMatchBlockC.size() > j) {
                        this.m_lstMatchBlockC.remove(j);
                    }
                    break;
                }
                if (((StructMatchBlock)this.m_lstMatchBlockC.get((int)j)).iPosB >= iPosB) {
                    this.m_lstMatchBlockC.remove(j);
                    continue;
                }
                DebugTracer.trace((String)"do nothing...");
                ++j;
            }
        }
        catch (Exception e) {
            System.out.println("eraseMatchBlock Exception:" + e);
        }
    }

    public void getResult(ArrayList vecMatchPair) {
        try {
            this.m_oMatrixManagement.setOrigin(this.m_iOriginB, this.m_iOriginC);
            int iPosBMaxInMatrix = this.m_iOriginB;
            int iPosCMaxInMatrix = this.m_iOriginC;
            while (this.m_lstMatchBlockB.size() > 0 || this.m_lstMatchBlockC.size() > 0) {
                StructMatchBlock itrMatchBlock;
                boolean bInsertToMatrix = false;
                int i = 0;
                int j = 0;
                if (!this.m_lstMatchBlockB.isEmpty()) {
                    itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                    while (i < this.m_lstMatchBlockB.size() && null != itrMatchBlock && itrMatchBlock.iPosB < this.m_iMatrixSize + this.m_iOriginB) {
                        if (itrMatchBlock.iPosB < this.m_iOriginB || itrMatchBlock.iPosC < this.m_iOriginC) {
                            this.m_lstMatchBlockB.remove(i);
                            if (this.m_lstMatchBlockB.isEmpty()) continue;
                            itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                            continue;
                        }
                        if (itrMatchBlock.iPosC < this.m_iMatrixSize + this.m_iOriginC) {
                            this.m_oMatrixManagement.setMatchPairToMatrix(itrMatchBlock.iPosB, itrMatchBlock.iPosC);
                            bInsertToMatrix = true;
                            if (itrMatchBlock.iPosB > iPosBMaxInMatrix) {
                                iPosBMaxInMatrix = itrMatchBlock.iPosB;
                            }
                            if (itrMatchBlock.iPosC > iPosCMaxInMatrix) {
                                iPosCMaxInMatrix = itrMatchBlock.iPosC;
                            }
                            this.m_lstMatchBlockB.remove(i);
                            if (this.m_lstMatchBlockB.isEmpty()) continue;
                            itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                            continue;
                        }
                        DebugTracer.trace((String)"do nothing...");
                        if (++i >= this.m_lstMatchBlockB.size()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                    }
                }
                if (!this.m_lstMatchBlockC.isEmpty()) {
                    itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                    while (j < this.m_lstMatchBlockC.size() && null != itrMatchBlock && itrMatchBlock.iPosC < this.m_iMatrixSize + this.m_iOriginC) {
                        if (itrMatchBlock.iPosB < this.m_iOriginB || itrMatchBlock.iPosC < this.m_iOriginC) {
                            this.m_lstMatchBlockC.remove(j);
                            if (this.m_lstMatchBlockC.isEmpty()) continue;
                            itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                            continue;
                        }
                        if (itrMatchBlock.iPosB < this.m_iMatrixSize + this.m_iOriginB) {
                            this.m_oMatrixManagement.setMatchPairToMatrix(itrMatchBlock.iPosB, itrMatchBlock.iPosC);
                            bInsertToMatrix = true;
                            if (itrMatchBlock.iPosB > iPosBMaxInMatrix) {
                                iPosBMaxInMatrix = itrMatchBlock.iPosB;
                            }
                            if (itrMatchBlock.iPosC > iPosCMaxInMatrix) {
                                iPosCMaxInMatrix = itrMatchBlock.iPosC;
                            }
                            this.m_lstMatchBlockC.remove(j);
                            if (this.m_lstMatchBlockC.isEmpty()) continue;
                            itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                            continue;
                        }
                        DebugTracer.trace((String)"do nothing...");
                        if (++j >= this.m_lstMatchBlockC.size()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                    }
                }
                if (bInsertToMatrix) {
                    this.m_oMatrixManagement.getResultWithEndPoint(vecMatchPair, iPosBMaxInMatrix, iPosCMaxInMatrix);
                } else {
                    this.m_oMatrixManagement.setOrigin(this.m_iOriginB + this.m_iMatrixSize / 3, this.m_iOriginC + this.m_iMatrixSize / 3);
                }
                int[] result = this.m_oMatrixManagement.getOrigin();
                this.m_iOriginB = result[0];
                this.m_iOriginC = result[1];
            }
        }
        catch (Exception e) {
            System.out.println(e + "--------------------");
        }
    }

    void getResultWithRange(ArrayList vecMatchPair, int iPosBMin, int iPosCMin) {
        this.m_oMatrixManagement.setOrigin(this.m_iOriginB, this.m_iOriginC);
        int iPosBMaxInMatrix = this.m_iOriginB;
        int iPosCMaxInMatrix = this.m_iOriginC;
        while (this.m_iOriginB < iPosBMin || this.m_iOriginC < iPosCMin) {
            StructMatchBlock itrMatchBlock;
            boolean bInsertToMatrix = false;
            int i = 0;
            int j = 0;
            if (!this.m_lstMatchBlockB.isEmpty()) {
                itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                while (i < this.m_lstMatchBlockB.size() && null != itrMatchBlock && itrMatchBlock.iPosB < this.m_iMatrixSize + this.m_iOriginB) {
                    if (itrMatchBlock.iPosB < this.m_iOriginB || itrMatchBlock.iPosC < this.m_iOriginC) {
                        this.m_lstMatchBlockB.remove(i);
                        if (this.m_lstMatchBlockB.isEmpty()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                        continue;
                    }
                    if (itrMatchBlock.iPosC < this.m_iMatrixSize + this.m_iOriginC) {
                        this.m_oMatrixManagement.setMatchPairToMatrix(itrMatchBlock.iPosB, itrMatchBlock.iPosC);
                        bInsertToMatrix = true;
                        if (itrMatchBlock.iPosB > iPosBMaxInMatrix) {
                            iPosBMaxInMatrix = itrMatchBlock.iPosB;
                        }
                        if (itrMatchBlock.iPosC > iPosCMaxInMatrix) {
                            iPosCMaxInMatrix = itrMatchBlock.iPosC;
                        }
                        this.m_lstMatchBlockB.remove(i);
                        if (this.m_lstMatchBlockB.isEmpty()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                        continue;
                    }
                    System.out.println("do nothing");
                    if (++i >= this.m_lstMatchBlockB.size()) continue;
                    itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockB.get(i);
                }
            }
            if (!this.m_lstMatchBlockC.isEmpty()) {
                itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                while (j < this.m_lstMatchBlockC.size() && null != itrMatchBlock && itrMatchBlock.iPosC < this.m_iMatrixSize + this.m_iOriginC) {
                    if (itrMatchBlock.iPosB < this.m_iOriginB || itrMatchBlock.iPosC < this.m_iOriginC) {
                        this.m_lstMatchBlockC.remove(j);
                        if (this.m_lstMatchBlockC.isEmpty()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                        continue;
                    }
                    if (itrMatchBlock.iPosB < this.m_iMatrixSize + this.m_iOriginB) {
                        this.m_oMatrixManagement.setMatchPairToMatrix(itrMatchBlock.iPosB, itrMatchBlock.iPosC);
                        bInsertToMatrix = true;
                        if (itrMatchBlock.iPosB > iPosBMaxInMatrix) {
                            iPosBMaxInMatrix = itrMatchBlock.iPosB;
                        }
                        if (itrMatchBlock.iPosC > iPosCMaxInMatrix) {
                            iPosCMaxInMatrix = itrMatchBlock.iPosC;
                        }
                        this.m_lstMatchBlockC.remove(j);
                        if (this.m_lstMatchBlockC.isEmpty()) continue;
                        itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                        continue;
                    }
                    DebugTracer.trace((String)"do nothing...");
                    if (++j >= this.m_lstMatchBlockC.size()) continue;
                    itrMatchBlock = (StructMatchBlock)this.m_lstMatchBlockC.get(j);
                }
            }
            if (bInsertToMatrix) {
                this.m_oMatrixManagement.getResultWithEndPoint(vecMatchPair, iPosBMaxInMatrix, iPosCMaxInMatrix);
            } else {
                this.m_oMatrixManagement.setOrigin(this.m_iOriginB + this.m_iMatrixSize / 3, this.m_iOriginC + this.m_iMatrixSize / 3);
            }
            int[] result = this.m_oMatrixManagement.getOrigin();
            this.m_iOriginB = result[0];
            this.m_iOriginC = result[1];
        }
    }

    void clear() {
        this.m_lstMatchBlockB.clear();
        this.m_lstMatchBlockC.clear();
        this.m_lstMatchBlockB.trimToSize();
        this.m_lstMatchBlockC.trimToSize();
        this.m_oMatrixManagement.clean();
    }
}

