/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.compare.common;

import java.util.ArrayList;

public class CBitMatrix {
    private ArrayList m_vecBitMatrix = new ArrayList();
    int m_uiRowSize;
    int m_uiColSize;

    CBitMatrix(int uiRowSize, int uiColSize) {
        int uiColByteLen = (uiColSize + 7) / 8;
        for (int i = 0; i < uiRowSize; ++i) {
            char[] temp = new char[uiColByteLen];
            for (int j = 0; j < uiColByteLen; ++j) {
                temp[j] = '\u0000';
            }
            this.m_vecBitMatrix.add(temp);
        }
        this.m_uiRowSize = uiRowSize;
        this.m_uiColSize = uiColSize;
    }

    void setValue(int uiRow, int uiCol, boolean iState) {
        if (uiRow < this.m_uiRowSize && uiCol < this.m_uiColSize) {
            int uiColPos = uiCol / 8;
            int uiColOffset = uiCol % 8;
            if (iState) {
                char[] cArray = (char[])this.m_vecBitMatrix.get(uiRow);
                int n = uiColPos;
                cArray[n] = (char)(cArray[n] | 1 << uiColOffset);
            } else {
                char[] cArray = (char[])this.m_vecBitMatrix.get(uiRow);
                int n = uiColPos;
                cArray[n] = (char)(cArray[n] & 255 - (1 << uiColOffset));
            }
        }
    }

    boolean getValue(int uiRow, int uiCol) {
        if (uiRow < this.m_uiRowSize && uiCol < this.m_uiColSize) {
            int uiColPos = uiCol / 8;
            int uiColOffset = uiCol % 8;
            if ((((char[])this.m_vecBitMatrix.get(uiRow))[uiColPos] & 1 << uiColOffset) != 0) {
                return true;
            }
        }
        return false;
    }

    void moveAreatoOrigin(int uiAreaRow, int uiAreaCol) {
        int uiColByteLen = (this.m_uiColSize + 7) / 8;
        int uiAreaColByteOffset = uiAreaCol / 8;
        int uiAreaColBitOffset = uiAreaCol % 8;
        int uiRow = 0;
        int uiColByte = 0;
        char ucSwap = '\u0000';
        for (uiRow = 0; uiRow < this.m_uiRowSize; ++uiRow) {
            if (uiAreaRow + uiRow < this.m_uiRowSize) {
                for (uiColByte = 0; uiColByte < uiColByteLen; ++uiColByte) {
                    ucSwap = '\u0000';
                    if (uiColByte + uiAreaColByteOffset < uiColByteLen) {
                        ucSwap = (char)(((char[])this.m_vecBitMatrix.get(uiAreaRow + uiRow))[uiColByte + uiAreaColByteOffset] >> uiAreaColBitOffset);
                        if (uiAreaColBitOffset > 0 && uiAreaColBitOffset < 8 && uiColByte + uiAreaColByteOffset + 1 < uiColByteLen) {
                            ucSwap = (char)(ucSwap + (((char[])this.m_vecBitMatrix.get(uiAreaRow + uiRow))[uiColByte + uiAreaColByteOffset + 1] << 8 - uiAreaColBitOffset));
                        }
                    }
                    ((char[])this.m_vecBitMatrix.get((int)uiRow))[uiColByte] = ucSwap;
                }
                continue;
            }
            for (int i = 0; i < uiColByteLen; ++i) {
                ((char[])this.m_vecBitMatrix.get((int)uiRow))[i] = '\u0000';
            }
        }
    }

    void clear() {
        int uiColByteLen = (this.m_uiColSize + 7) / 8;
        for (int i = 0; i < this.m_vecBitMatrix.size(); ++i) {
            for (int j = 0; j < uiColByteLen; ++j) {
                ((char[])this.m_vecBitMatrix.get((int)i))[j] = '\u0000';
            }
        }
    }

    ArrayList getCBitmatrix() {
        return this.m_vecBitMatrix;
    }
}

