/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.compare;

import com.huawei.dc.compare.CmpListRender;
import com.huawei.dc.compare.DCDebugTracer;
import com.huawei.dc.compare.common.LCSStrWrapper;
import com.huawei.dc.compare.common.ResourceManager;
import com.huawei.dc.compare.common.UIConstants;
import com.huawei.dc.compare.datasource.ConfigFileControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class CompareFileDialog
extends JDialog {
    private static final int ZERO = 0;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FIVE = 5;
    private static final int NEGATIVE_ONE = -1;
    JPanel panel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel pnl_bottom = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JPanel pnl_left = new JPanel();
    JPanel pnl_right = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JList leftList = new JList();
    JList rightList = new JList();
    JSplitPane splitPane = new JSplitPane();
    ArrayList arrayList1 = new ArrayList();
    ArrayList arrayList2 = new ArrayList();
    JTextField leftFileText = new JTextField();
    JTextField rightFileText = new JTextField();
    JPanel pnl_selectText = new JPanel();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JTextField leftSelectText = new JTextField();
    JTextField rightSelectText = new JTextField();
    JScrollPane scpnl_left = new JScrollPane();
    JScrollPane scpnl_right = new JScrollPane();
    JPanel pnl_closeBtn = new JPanel();
    JButton closeBtn = new JButton();
    JButton nextBtn = new JButton();
    JButton preBtn = new JButton();
    private boolean hasSetLeftModel;
    private boolean hasSetRightModel;
    private ArrayList diffListDatas;
    private int[] m_iDiffLines;
    private int[] m_iDiffYCoordinates;
    private boolean m_isFirst = true;
    private Rectangle m_trackBounds;
    private int m_iFirstDiffIndex = -1;
    private int m_iLastDiffIndex = -1;
    private ResourceManager m_resMgr = ResourceManager.getInstance();

    public CompareFileDialog(Frame frame, String strTitle, boolean modal) {
        super(frame, strTitle, modal);
        try {
            this.jbInit();
            this.setControl();
            this.pack();
            this.setSize(new Dimension(800, 600));
            this.setLocationRelativeTo(null);
            this.setResizable(true);
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex.getMessage());
        }
        KeyStroke escKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.rootPane.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareFileDialog.this.dispose();
            }
        }, escKeyStroke, 2);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout1);
        this.panel1.setLayout(this.gridBagLayout1);
        this.panel1.setName("_JavaPanel_panel1");
        this.pnl_bottom.setLayout(this.gridBagLayout2);
        this.pnl_bottom.setName("_JavaPanel_jPanel1");
        this.pnl_left.setRequestFocusEnabled(true);
        this.pnl_left.setLayout(this.gridBagLayout3);
        this.pnl_left.setName("_JavaPanel_jPanel2");
        this.pnl_right.setLayout(this.gridBagLayout4);
        this.pnl_right.setName("_JavaPanel_jPanel3");
        this.leftFileText.setEditable(false);
        this.leftFileText.setName("_EditBox_leftFileText");
        this.rightFileText.setEditable(false);
        this.rightFileText.setName("_EditBox_rightFileText");
        this.pnl_selectText.setLayout(this.gridBagLayout5);
        this.pnl_selectText.setName("_JavaPanel_jPanel4");
        this.rightSelectText.setText("");
        this.rightSelectText.setName("_Label_jLabel2");
        this.leftSelectText.setName("_Label_jLabel1");
        this.leftFileText.setMargin(new Insets(4, 4, 4, 4));
        this.rightFileText.setMargin(new Insets(4, 4, 4, 4));
        this.leftSelectText.setText("");
        this.pnl_closeBtn.setName("_JavaPanel_jPanel5");
        this.pnl_closeBtn.setLayout(this.gridBagLayout1);
        Dimension btnSize = new Dimension(80, 21);
        this.closeBtn.setMaximumSize(btnSize);
        this.closeBtn.setMinimumSize(btnSize);
        this.closeBtn.setPreferredSize(btnSize);
        this.closeBtn.setText(this.m_resMgr.getResString("button.close"));
        this.closeBtn.setName("_PushButton_closeBtn");
        Dimension btnSize2 = new Dimension(30, 21);
        this.preBtn.setMaximumSize(btnSize2);
        this.preBtn.setMinimumSize(btnSize2);
        this.preBtn.setPreferredSize(btnSize2);
        this.preBtn.setName("_PushButton_preBtn");
        this.preBtn.setMargin(new Insets(0, 0, 0, 0));
        ImageIcon upicon = new ImageIcon(this.getClass().getResource("/com/huawei/dc/compare/res/image/up.gif"));
        this.preBtn.setIcon(upicon);
        this.preBtn.setToolTipText(this.m_resMgr.getResString("button.previous.tooltip"));
        this.nextBtn.setMaximumSize(btnSize2);
        this.nextBtn.setMinimumSize(btnSize2);
        this.nextBtn.setPreferredSize(btnSize2);
        this.nextBtn.setName("_PushButton_nextBtn");
        this.nextBtn.setMargin(new Insets(0, 0, 0, 0));
        ImageIcon downicon = new ImageIcon(this.getClass().getResource("/com/huawei/dc/compare/res/image/down.gif"));
        this.nextBtn.setIcon(downicon);
        this.nextBtn.setToolTipText(this.m_resMgr.getResString("button.next.tooltip"));
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.pnl_bottom, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnl_bottom.add((Component)this.leftFileText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 0, 18), 0, 0));
        this.pnl_bottom.add((Component)this.rightFileText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 0, 8), 0, 0));
        JPanel nevPnl = new JPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        nevPnl.setLayout(flowLayout);
        this.pnl_bottom.add((Component)nevPnl, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(8, 8, 0, 8), 0, 0));
        nevPnl.add(this.nextBtn);
        nevPnl.add(Box.createHorizontalStrut(4));
        nevPnl.add(this.preBtn);
        this.pnl_bottom.add((Component)this.pnl_left, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 0, 0), 0, 0));
        this.pnl_bottom.add((Component)this.pnl_right, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 0, 0, 8), 0, 0));
        this.pnl_bottom.add((Component)this.pnl_selectText, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 0, 8), 0, 0));
        this.pnl_bottom.add((Component)this.pnl_closeBtn, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 0, 8), 0, 0));
        this.pnl_left.add((Component)this.scpnl_left, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnl_right.add((Component)this.scpnl_right, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pnl_selectText.add((Component)this.leftSelectText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnl_selectText.add((Component)this.rightSelectText, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 0, 0), 0, 0));
        this.pnl_closeBtn.add((Component)this.closeBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.scpnl_left.getViewport().add(this.leftList);
        this.scpnl_left.setName("_ScrollPane_jScrollPane1");
        this.scpnl_right.getViewport().add(this.rightList);
        this.scpnl_right.setName("_ScrollPane_jScrollPane2");
        this.leftSelectText.setEditable(false);
        this.rightSelectText.setEditable(false);
        this.leftList.setSelectionMode(0);
        this.rightList.setSelectionMode(0);
        this.leftList.setFixedCellHeight(21);
        this.rightList.setFixedCellHeight(21);
        this.leftList.setCellRenderer(new CmpListRender());
        this.rightList.setCellRenderer(new CmpListRender());
        this.leftList.setSelectionModel(this.rightList.getSelectionModel());
        this.scpnl_left.getVerticalScrollBar().setUI(new VScrollBarUI());
        this.scpnl_right.getVerticalScrollBar().setUI(new VScrollBarUI());
        this.scpnl_left.getVerticalScrollBar().setModel(this.scpnl_right.getVerticalScrollBar().getModel());
        this.scpnl_left.getHorizontalScrollBar().setModel(this.scpnl_right.getHorizontalScrollBar().getModel());
        this.scpnl_left.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CompareFileDialog.this.getSelectedIndex(e.getY());
                CompareFileDialog.this.leftList.setSelectedIndex(index);
                CompareFileDialog.this.leftList.ensureIndexIsVisible(index);
            }
        });
        this.scpnl_right.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int index = CompareFileDialog.this.getSelectedIndex(e.getY());
                CompareFileDialog.this.leftList.setSelectedIndex(index);
                CompareFileDialog.this.leftList.ensureIndexIsVisible(index);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFilePathNE(String strLeftFilePath, String strRightFilePath) {
        ArrayList<String> leftFileInfoList = new ArrayList<String>();
        BufferedReader leftBuffer = null;
        try {
            leftBuffer = new BufferedReader(new FileReader(strLeftFilePath));
            String line = leftBuffer.readLine();
            while (line != null) {
                leftFileInfoList.add(line);
                line = leftBuffer.readLine();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            int n = -1;
            return n;
        }
        finally {
            if (leftBuffer != null) {
                try {
                    leftBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ArrayList<String> rightFileInfoList = new ArrayList<String>();
        BufferedReader rightBuffer = null;
        try {
            rightBuffer = new BufferedReader(new FileReader(strRightFilePath));
            String line = rightBuffer.readLine();
            while (line != null) {
                rightFileInfoList.add(line);
                line = rightBuffer.readLine();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            int n = -1;
            return n;
        }
        finally {
            if (rightBuffer != null) {
                try {
                    rightBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ConfigFileControl.getInstance().compareBetweenFile(leftFileInfoList, rightFileInfoList);
        this.setLeftModel(ConfigFileControl.getInstance().getCompareFileLeftModel());
        this.setRightModel(ConfigFileControl.getInstance().getCompareFileRightModel());
        this.getContentPane().repaint();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFilePath(String strLeftFilePath, String strRightFilePath) {
        this.setLeftFileInfo(strLeftFilePath);
        this.setRightFileInfo(strRightFilePath);
        ArrayList<String> leftFileInfoList = new ArrayList<String>();
        BufferedReader leftBuffer = null;
        try {
            leftBuffer = new BufferedReader(new FileReader(strLeftFilePath));
            String line = leftBuffer.readLine();
            while (line != null) {
                leftFileInfoList.add(line);
                line = leftBuffer.readLine();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            int n = -1;
            return n;
        }
        finally {
            if (leftBuffer != null) {
                try {
                    leftBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ArrayList<String> rightFileInfoList = new ArrayList<String>();
        BufferedReader rightBuffer = null;
        try {
            rightBuffer = new BufferedReader(new FileReader(strRightFilePath));
            String line = rightBuffer.readLine();
            while (line != null) {
                rightFileInfoList.add(line);
                line = rightBuffer.readLine();
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            int n = -1;
            return n;
        }
        finally {
            if (rightBuffer != null) {
                try {
                    rightBuffer.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        ConfigFileControl.getInstance().compareBetweenFile(leftFileInfoList, rightFileInfoList);
        this.setLeftModel(ConfigFileControl.getInstance().getCompareFileLeftModel());
        this.setRightModel(ConfigFileControl.getInstance().getCompareFileRightModel());
        this.initBtnStatus();
        this.getContentPane().repaint();
        return 0;
    }

    private void setControl() {
        this.leftList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CompareFileDialog.this.leftList.getModel().getSize() != 0) {
                    int iSelectedIndex = CompareFileDialog.this.leftList.getSelectedIndex();
                    CompareFileDialog.this.rightList.setSelectedIndex(iSelectedIndex);
                    if (null != CompareFileDialog.this.leftSelectText && null != CompareFileDialog.this.leftList.getSelectedValue()) {
                        CompareFileDialog.this.leftSelectText.setText(((LCSStrWrapper)CompareFileDialog.this.leftList.getSelectedValue()).toString());
                    }
                    if (null != CompareFileDialog.this.rightSelectText && null != CompareFileDialog.this.rightList.getSelectedValue()) {
                        CompareFileDialog.this.rightSelectText.setText(((LCSStrWrapper)CompareFileDialog.this.rightList.getSelectedValue()).toString());
                    }
                    CompareFileDialog.this.setButtonEnabled(iSelectedIndex);
                }
            }
        });
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CompareFileDialog.this.dispose();
            }
        });
        this.nextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == CompareFileDialog.this.diffListDatas || CompareFileDialog.this.diffListDatas.isEmpty()) {
                    return;
                }
                int selIndex = CompareFileDialog.this.leftList.getSelectedIndex();
                if (selIndex < 0) {
                    int index = ((DiffDatas)((CompareFileDialog)CompareFileDialog.this).diffListDatas.get((int)0)).index;
                    CompareFileDialog.this.leftList.setSelectedIndex(index);
                    CompareFileDialog.this.leftList.ensureIndexIsVisible(index);
                    return;
                }
                for (DiffDatas element : CompareFileDialog.this.diffListDatas) {
                    if (selIndex >= element.index) continue;
                    CompareFileDialog.this.leftList.setSelectedIndex(element.index);
                    CompareFileDialog.this.leftList.ensureIndexIsVisible(element.index);
                    return;
                }
            }
        });
        this.preBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (null == CompareFileDialog.this.diffListDatas || CompareFileDialog.this.diffListDatas.isEmpty()) {
                    return;
                }
                int selIndex = CompareFileDialog.this.leftList.getSelectedIndex();
                if (selIndex < 0) {
                    int index = ((DiffDatas)((CompareFileDialog)CompareFileDialog.this).diffListDatas.get((int)(((CompareFileDialog)CompareFileDialog.this).diffListDatas.size() - 1))).index;
                    CompareFileDialog.this.leftList.setSelectedIndex(index);
                    CompareFileDialog.this.leftList.ensureIndexIsVisible(index);
                    return;
                }
                for (int i = CompareFileDialog.this.diffListDatas.size() - 1; i >= 0; --i) {
                    DiffDatas element = (DiffDatas)CompareFileDialog.this.diffListDatas.get(i);
                    if (selIndex <= element.index) continue;
                    CompareFileDialog.this.leftList.setSelectedIndex(element.index);
                    CompareFileDialog.this.leftList.ensureIndexIsVisible(element.index);
                    return;
                }
            }
        });
    }

    public void setLeftFileInfo(String strFilePath) {
        if (strFilePath == null || strFilePath.equals("")) {
            return;
        }
        this.leftFileText.setText(strFilePath);
        this.leftFileText.setToolTipText(strFilePath);
    }

    public void setRightFileInfo(String strFilePath) {
        if (strFilePath == null || strFilePath.equals("")) {
            return;
        }
        this.rightFileText.setText(strFilePath);
        this.rightFileText.setToolTipText(strFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCompareContentAndInfo(String strLeftInfo, String strLeftContent, String strRightInfo, String strRightContent) {
        this.setLeftFileInfo(strLeftInfo);
        this.setRightFileInfo(strRightInfo);
        ArrayList<String> leftFileInfoList = new ArrayList<String>();
        BufferedReader leftBuffer = null;
        try {
            leftBuffer = new BufferedReader(new StringReader(strLeftContent));
            if (null != leftBuffer) {
                String line = leftBuffer.readLine();
                while (line != null) {
                    leftFileInfoList.add(line);
                    line = leftBuffer.readLine();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            if (leftBuffer != null) {
                try {
                    leftBuffer.close();
                }
                catch (IOException localIOException1) {
                    DCDebugTracer.trace(localIOException1);
                }
            }
        }
        finally {
            if (leftBuffer != null) {
                try {
                    leftBuffer.close();
                }
                catch (IOException localIOException2) {
                    DCDebugTracer.trace(localIOException2);
                }
            }
        }
        ArrayList<String> rightFileInfoList = new ArrayList<String>();
        BufferedReader rightBuffer = null;
        try {
            rightBuffer = new BufferedReader(new StringReader(strRightContent));
            if (null != rightBuffer) {
                String line = rightBuffer.readLine();
                while (line != null) {
                    rightFileInfoList.add(line);
                    line = rightBuffer.readLine();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, this.m_resMgr.getResString("error.message.invalid.path"), this.m_resMgr.getResString("error.message.title"), 0);
            if (rightBuffer != null) {
                try {
                    rightBuffer.close();
                }
                catch (IOException localIOException4) {
                    DCDebugTracer.trace(localIOException4);
                }
            }
        }
        finally {
            if (rightBuffer != null) {
                try {
                    rightBuffer.close();
                }
                catch (IOException localIOException5) {
                    DCDebugTracer.trace(localIOException5);
                }
            }
        }
        ConfigFileControl.getInstance().compareBetweenFile(leftFileInfoList, rightFileInfoList);
        this.setLeftModel(ConfigFileControl.getInstance().getCompareFileLeftModel());
        this.setRightModel(ConfigFileControl.getInstance().getCompareFileRightModel());
        this.initBtnStatus();
        this.getContentPane().repaint();
    }

    public void setRightFileInfoDirect(String fileStringLeft, String fileStringRight) {
        if (fileStringLeft == null) {
            return;
        }
        this.leftFileText.setText(fileStringLeft);
        if (fileStringRight == null) {
            return;
        }
        this.rightFileText.setText(fileStringRight);
    }

    public void setRightFileDesc(String description) {
        this.rightFileText.setText(description);
    }

    public void setLeftModel(DefaultComboBoxModel leftModel) {
        this.leftList.setModel(leftModel);
        int size = leftModel.getSize();
        if (null == this.diffListDatas || this.diffListDatas.size() != size) {
            this.diffListDatas = new ArrayList();
            for (int i = 0; i < size; ++i) {
                LCSStrWrapper sw = (LCSStrWrapper)leftModel.getElementAt(i);
                int type = sw.type;
                if (type == 0) continue;
                this.diffListDatas.add(new DiffDatas(i, sw.type));
                this.setDiffIndex(i);
            }
        }
        if (this.hasSetRightModel) {
            this.refresh();
        }
        this.hasSetLeftModel = true;
    }

    public void setRightModel(DefaultComboBoxModel rightModel) {
        this.rightList.setModel(rightModel);
        int size = rightModel.getSize();
        if (null == this.diffListDatas || this.diffListDatas.size() != size) {
            this.diffListDatas = new ArrayList();
            for (int i = 0; i < size; ++i) {
                LCSStrWrapper sw = (LCSStrWrapper)rightModel.getElementAt(i);
                int type = sw.type;
                if (type == 0) continue;
                this.diffListDatas.add(new DiffDatas(i, sw.type));
                this.setDiffIndex(i);
            }
        }
        if (this.hasSetLeftModel) {
            this.refresh();
        }
        this.hasSetRightModel = true;
    }

    private void refresh() {
        int pbW = this.leftList.getPreferredScrollableViewportSize().width;
        int pcW = this.rightList.getPreferredScrollableViewportSize().width;
        int mW = Math.max(pbW, pcW);
        if (pbW != mW) {
            this.leftList.setFixedCellWidth(mW);
        }
        if (pcW != mW) {
            this.rightList.setFixedCellWidth(mW);
        }
        Dimension txtSize = new Dimension(mW, 30);
        this.leftFileText.setPreferredSize(txtSize);
        this.rightFileText.setPreferredSize(txtSize);
    }

    private int getSelectedIndex(int y) {
        if (null == this.m_iDiffLines || null == this.m_iDiffYCoordinates) {
            return -1;
        }
        int iDiffLineCount = this.m_iDiffLines.length;
        int index = -1;
        int minV = 5;
        int iPos = -1;
        for (int i = 0; i < iDiffLineCount; ++i) {
            int tmpV = Math.abs(this.m_iDiffYCoordinates[i] - y);
            if (0 == tmpV) {
                iPos = i;
                break;
            }
            if (minV <= tmpV) continue;
            minV = tmpV;
            iPos = i;
        }
        index = iPos >= 0 ? this.m_iDiffLines[iPos] : (y - this.m_trackBounds.y) * this.leftList.getModel().getSize() / this.m_trackBounds.height;
        return index;
    }

    private void setButtonEnabled(int iSelectedIndex) {
        if (null == this.diffListDatas || this.diffListDatas.isEmpty()) {
            this.preBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
            return;
        }
        if (this.m_iFirstDiffIndex == this.m_iLastDiffIndex && iSelectedIndex == this.m_iFirstDiffIndex) {
            this.preBtn.setEnabled(false);
            this.nextBtn.setEnabled(false);
        } else if (iSelectedIndex <= this.m_iFirstDiffIndex) {
            this.preBtn.setEnabled(false);
            this.nextBtn.setEnabled(true);
        } else if (iSelectedIndex >= this.m_iLastDiffIndex) {
            this.preBtn.setEnabled(true);
            this.nextBtn.setEnabled(false);
        } else {
            this.preBtn.setEnabled(true);
            this.nextBtn.setEnabled(true);
        }
    }

    private void setDiffIndex(int index) {
        if (this.m_iFirstDiffIndex == -1) {
            this.m_iFirstDiffIndex = index;
        }
        if (this.m_iLastDiffIndex == -1) {
            this.m_iLastDiffIndex = index;
        }
        if (this.m_iFirstDiffIndex > index) {
            this.m_iFirstDiffIndex = index;
        }
        if (this.m_iLastDiffIndex < index) {
            this.m_iLastDiffIndex = index;
        }
    }

    private void initBtnStatus() {
        int selIndex = this.leftList.getSelectedIndex();
        if (selIndex < 0) {
            if (null == this.diffListDatas || this.diffListDatas.isEmpty()) {
                this.nextBtn.setEnabled(false);
                this.preBtn.setEnabled(false);
                return;
            }
            int index = ((DiffDatas)this.diffListDatas.get((int)0)).index;
            this.leftList.setSelectedIndex(index);
            this.leftList.ensureIndexIsVisible(index);
            return;
        }
        for (DiffDatas element : this.diffListDatas) {
            if (selIndex >= element.index) continue;
            this.leftList.setSelectedIndex(element.index);
            this.leftList.ensureIndexIsVisible(element.index);
            return;
        }
    }

    static /* synthetic */ int[] access$402(CompareFileDialog x0, int[] x1) {
        x0.m_iDiffLines = x1;
        return x1;
    }

    static /* synthetic */ int[] access$502(CompareFileDialog x0, int[] x1) {
        x0.m_iDiffYCoordinates = x1;
        return x1;
    }

    private static final class DiffDatas {
        int index;
        Color color;

        public DiffDatas(int index, int type) {
            this.index = index;
            if (type == 1) {
                this.color = UIConstants.ADD_COLOR;
            } else if (type == 2) {
                this.color = UIConstants.DELETE_COLOR;
            } else if (type == 3) {
                this.color = UIConstants.MODIFY_COLOR;
            }
        }
    }

    public class VScrollBarUI
    extends MetalScrollBarUI {
        private Color thumbColor;
        private Color thumbShadow;
        private Color thumbHighlightColor;
        private int iScrollBarHeight = 0;

        @Override
        protected void configureScrollBarColors() {
            super.configureScrollBarColors();
            this.thumbColor = UIManager.getColor("ScrollBar.thumb");
            this.thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
            this.thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
        }

        @Override
        protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
            super.paintTrack(g, c, trackBounds);
            if (this.iScrollBarHeight != trackBounds.height) {
                CompareFileDialog.this.m_isFirst = true;
                this.iScrollBarHeight = trackBounds.height;
            }
            Vector<Integer> tmpLineVec = null;
            Vector<Integer> tmpYCoordinateVec = null;
            if (CompareFileDialog.this.m_isFirst) {
                tmpLineVec = new Vector<Integer>();
                tmpYCoordinateVec = new Vector<Integer>();
            }
            for (DiffDatas element : CompareFileDialog.this.diffListDatas) {
                g.setColor(element.color);
                int cd = trackBounds.y + element.index * trackBounds.height / CompareFileDialog.this.leftList.getModel().getSize();
                cd = cd == 0 ? 1 : cd;
                g.drawLine(trackBounds.x, cd, trackBounds.width, cd);
                if (!CompareFileDialog.this.m_isFirst) continue;
                tmpYCoordinateVec.add(cd);
                tmpLineVec.add(element.index);
            }
            if (CompareFileDialog.this.m_isFirst && null != tmpLineVec) {
                int iDiffLineCount = tmpLineVec.size();
                CompareFileDialog.access$402(CompareFileDialog.this, new int[iDiffLineCount]);
                CompareFileDialog.access$502(CompareFileDialog.this, new int[iDiffLineCount]);
                for (int i = 0; i < iDiffLineCount; ++i) {
                    ((CompareFileDialog)CompareFileDialog.this).m_iDiffYCoordinates[i] = (Integer)tmpYCoordinateVec.get(i);
                    ((CompareFileDialog)CompareFileDialog.this).m_iDiffLines[i] = (Integer)tmpLineVec.get(i);
                }
                CompareFileDialog.this.m_isFirst = false;
                tmpLineVec = null;
                tmpYCoordinateVec = null;
            }
            CompareFileDialog.this.m_trackBounds = this.getTrackBounds();
        }

        @Override
        protected void paintThumb(Graphics pictorial, JComponent assembly, Rectangle border) {
            if (!assembly.isEnabled()) {
                return;
            }
            boolean isLToR = assembly.getComponentOrientation().isLeftToRight();
            pictorial.translate(border.x, border.y);
            if (this.scrollbar.getOrientation() == 1) {
                if (!this.isFreeStanding) {
                    if (!isLToR) {
                        ++border.width;
                        pictorial.translate(-1, 0);
                    } else {
                        border.width += 2;
                    }
                }
                pictorial.setColor(this.thumbColor);
                pictorial.fillRect(border.width - 5, 0, border.width - 3, border.height - 1);
                pictorial.fillRect(1, 0, 3, border.height - 1);
                pictorial.setColor(this.thumbShadow);
                pictorial.drawRect(0, 0, border.width - 2, border.height - 1);
                pictorial.setColor(this.thumbHighlightColor);
                pictorial.drawLine(1, 1, border.width - 3, 1);
                pictorial.drawLine(1, 1, 1, border.height - 1);
                pictorial.drawLine(border.width - 3, 1, border.width - 3, border.height - 1);
                if (!this.isFreeStanding) {
                    if (!isLToR) {
                        --border.width;
                        pictorial.translate(1, 0);
                    } else {
                        border.width -= 2;
                    }
                }
            }
            pictorial.translate(-border.x, -border.y);
        }
    }
}

