/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sf.filemanager;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.UserInfo;
import com.swimap.external.sf.filemanager.AbstractFileManager;
import com.swimap.external.sf.filemanager.FileAttribute;
import com.swimap.external.sf.filemanager.Progress;
import com.swimap.imap.ssl.util.SFTPSetting;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sf.filemanager.FileManagerCommon;
import com.swimap.sf.filemanager.SFTPUserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SFTPFileManager
extends AbstractFileManager {
    private static final IviewLogger log = IviewLogger.getLogger(SFTPFileManager.class, (String)"FRM");
    private static final String UnixFileSeparator = "/";
    private static final String CHANNEL_TYPE = "sftp";
    private static final int BufferSize = 1024;
    private String localFileEncoding = "utf-8";
    private String remoteFileEncoding = "utf-8";
    private String localRoot = System.getProperty("user.dir");
    private String remoteRoot = "/";
    private String _ip;
    private String _port;
    private String _username;
    private String _ps;
    private Session session;
    private ChannelSftp channel;
    private static final int READ_DATA_TIMEOUT = 30000;
    private Map<String, String> _properties = new HashMap<String, String>();

    public SFTPFileManager() {
    }

    public SFTPFileManager(String ip, String port, String username, String ps) {
        this._ip = ip;
        this._port = port;
        this._username = username;
        this._ps = ps;
    }

    @Override
    public int connect(String ip, String port, String username, String ps) {
        this._ip = ip;
        this._port = port;
        this._username = username;
        this._ps = ps;
        return this.connect();
    }

    private void openSession() throws Exception {
        JSch jsch = new JSch();
        SFTPSetting setting = SFTPSetting.getInstance();
        String keyfile = null;
        boolean usePublicKeyAuth = setting.isUsePublicKeyAuth();
        if (usePublicKeyAuth) {
            keyfile = setting.getKeyPath();
        } else {
            keyfile = System.getProperty("FTPManager.privatekeyfilepath");
            boolean bl = usePublicKeyAuth = keyfile != null && !keyfile.equals("") && new File(keyfile).exists();
        }
        if (usePublicKeyAuth) {
            try {
                jsch.addIdentity(keyfile);
                this.session = jsch.getSession(this._username, this._ip, Integer.valueOf(this._port).intValue());
                Properties configProps = new Properties();
                configProps.put("PreferredAuthentications", "publickey");
                configProps.setProperty("StrictHostKeyChecking", "no");
                this.session.setConfig(configProps);
                this.session.setUserInfo((UserInfo)new SFTPUserInfo(setting));
                this.session.setTimeout(30000);
                this.session.connect();
                return;
            }
            catch (Exception e) {
                if (setting.isTryPasswordAuthWhenFail()) {
                    log.warn((Object)"Login using PubKeyAuth failed. Try PassworAuth.", (Throwable)e);
                }
                log.error((Object)"Login using PubKeyAuth failed. ", (Throwable)e);
                return;
            }
        }
        this.session = jsch.getSession(this._username, this._ip, Integer.valueOf(this._port).intValue());
        Properties properties = new Properties();
        properties.put("PreferredAuthentications", "password,keyboard-interactive");
        properties.setProperty("StrictHostKeyChecking", "no");
        this.session.setConfig(properties);
        this.session.setPassword(this._ps);
        this.session.setTimeout(30000);
        this.session.connect();
    }

    @Override
    public int connect() {
        try {
            this.openSession();
            this.channel = (ChannelSftp)this.session.openChannel(CHANNEL_TYPE);
            this.channel.connect();
            this.channel.setFilenameEncoding(this.remoteFileEncoding);
            this.remoteRoot = this.channel.pwd();
        }
        catch (Exception e) {
            log.error((Object)("Connect to ftp server failed: " + this._ip + ":" + this._port), (Throwable)e);
            return 1;
        }
        return 0;
    }

    @Override
    public int disconnect() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String remotefile, String localfile, Progress progress) {
        try {
            int n = this.downloadImpl(remotefile, localfile, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String remotefile, String localfile, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotefile, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localfile, this.getLocalSeparator());
        FileAttribute attr = this.listRemote(remote, false);
        if (attr == null) {
            return 1;
        }
        double step = 100.0 / ((double)(attr.getSize() + 1024L) / 1024.0);
        step = step > 1.0 ? step : 1.0;
        int error = this.downloadFile(remote, local, progress, 1024, step);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int downloadFile(String remotefile, String localfile, Progress progress, int buffersize, double step) {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = this.channel.get(remotefile);
            File tempfile = new File(localfile);
            String overwrite = this._properties.get("ftp.overwrite");
            if ("false".equalsIgnoreCase(overwrite) && tempfile.exists()) {
                log.debug((Object)("Local file already exists:" + localfile));
                int n = 1;
                return n;
            }
            File parent = tempfile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                log.warn((Object)("Failed to create directory:" + tempfile));
                int n = 1;
                return n;
            }
            os = new FileOutputStream(tempfile);
            int n = this.writedata(is, os, buffersize, progress, step);
            return n;
        }
        catch (Exception e) {
            log.error((Object)"Error in download.", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (FileManagerCommon.closeStream(is, os)) {
                return 1;
            }
        }
    }

    private int writedata(InputStream is, OutputStream os, int buffersize, Progress progress, double progressStep) {
        byte[] buffer = new byte[buffersize];
        double curd = 0.0;
        if (progress != null) {
            curd = progress.getProgress();
            if (progress.canceled()) {
                return 2;
            }
        }
        try {
            int count;
            int totalcount = 0;
            while ((count = is.read(buffer)) != -1) {
                os.write(buffer, 0, count);
                if ((totalcount += count) < buffersize) continue;
                totalcount -= buffersize;
                if (progress == null) continue;
                if (progress.canceled()) {
                    return 2;
                }
                curd = (curd = progressStep + curd) >= 100.0 ? 99.0 : curd;
                progress.setProgress((int)curd);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error in download file", (Throwable)e);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String remotedir, String localdir, boolean recursive, Progress progress) {
        try {
            int n = this.downloadImpl(remotedir, localdir, recursive, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String remotedir, String localdir, boolean recursive, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotedir, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localdir, this.getLocalSeparator());
        FileAttribute attr = this.listRemote(remote, recursive);
        if (attr == null || !attr.isDirectory()) {
            return 1;
        }
        long size = attr.getTotalFileSize(recursive);
        double step = 100.0 / ((double)(size + 1024L) / 1024.0);
        step = step > 1.0 ? step : 1.0;
        int error = this.downloadDir(remote, local, progress, 1024, step, recursive, attr);
        return error;
    }

    private int downloadDir(String remotedir, String localdir, Progress progress, int buffersize, double step, boolean recursive, FileAttribute attr) {
        int error = 0;
        File tempfile = new File(localdir);
        if (!tempfile.exists() && !tempfile.mkdirs()) {
            log.error((Object)("Failed to make directory: " + tempfile));
            return 1;
        }
        if (recursive) {
            for (FileAttribute child : attr.getChildren()) {
                error = !child.isDirectory() ? this.downloadFile(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step) : this.downloadDir(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step, recursive, child);
                if (error == 0) continue;
                return error;
            }
        } else {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.downloadFile(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step);
                }
                if (error == 0) continue;
                return error;
            }
        }
        return error;
    }

    @Override
    public String getLocalFileEncoding() {
        return this.localFileEncoding;
    }

    @Override
    public String getLocalRoot() {
        return this.localRoot;
    }

    @Override
    public String getLocalSeparator() {
        return File.separator;
    }

    @Override
    public String getRemoteFileEncoding() {
        return this.remoteFileEncoding;
    }

    @Override
    public String getRemoteRoot() {
        return this.remoteRoot;
    }

    @Override
    public String getRemoteSeparator() {
        return UnixFileSeparator;
    }

    @Override
    public FileAttribute listLocal(String localfile, boolean recursive) {
        String filename = FileManagerCommon.convertFileName(this.getLocalRoot(), localfile, this.getLocalSeparator());
        File file = new File(filename);
        if (!file.exists()) {
            log.debug((Object)("local file not exist:" + localfile));
            return null;
        }
        return this.listLocal(file, recursive);
    }

    private FileAttribute listLocal(File file, boolean recursive) {
        FileAttribute attr = new FileAttribute();
        attr.setName(file.getName());
        if (file.isDirectory()) {
            File[] children;
            attr.setDirectory(true);
            for (File child : children = file.listFiles()) {
                if (recursive) {
                    attr.addChild(this.listLocal(child, recursive));
                    continue;
                }
                FileAttribute c = new FileAttribute();
                c.setDirectory(child.isDirectory());
                if (!c.isDirectory()) {
                    c.setSize(child.length());
                }
                c.setName(child.getName());
                attr.addChild(c);
            }
        } else {
            attr.setDirectory(false);
            attr.setSize(file.length());
        }
        return attr;
    }

    @Override
    public FileAttribute listRemote(String remotefile, boolean recursive) {
        String file = FileManagerCommon.convertFileName(this.getRemoteRoot(), remotefile, this.getRemoteSeparator());
        int index = file.lastIndexOf(this.getRemoteSeparator());
        FileAttribute attr = null;
        String filename = file.substring(index + 1);
        try {
            Vector namest = this.channel.ls(file);
            Vector<ChannelSftp.LsEntry> names = new Vector<ChannelSftp.LsEntry>();
            boolean dir = false;
            for (ChannelSftp.LsEntry entry : namest) {
                if (entry.getAttrs().isDir() && (entry.getFilename().equals(".") || entry.getFilename().equals(".."))) {
                    dir = true;
                    continue;
                }
                names.add(entry);
            }
            if (names.size() == 0) {
                attr = new FileAttribute();
                attr.setDirectory(true);
                attr.setName(filename);
            } else if (names.size() == 1 && !dir) {
                attr = new FileAttribute();
                attr.setDirectory(false);
                attr.setName(filename);
                attr.setSize(((ChannelSftp.LsEntry)names.get(0)).getAttrs().getSize());
            } else {
                attr = new FileAttribute();
                attr.setDirectory(true);
                attr.setName(filename);
                this.fillChild(file, attr, names, recursive);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in list file", (Throwable)e);
        }
        return attr;
    }

    private void fillChild(String file, FileAttribute attr, Vector<ChannelSftp.LsEntry> names, boolean recursive) {
        for (ChannelSftp.LsEntry e : names) {
            FileAttribute childattr;
            SftpATTRS a = e.getAttrs();
            if (a.isDir()) {
                if (recursive) {
                    String child = file + UnixFileSeparator + e.getFilename();
                    childattr = this.listRemote(child, recursive);
                } else {
                    childattr = new FileAttribute();
                    childattr.setName(e.getFilename());
                    childattr.setDirectory(true);
                    childattr.setSize(0L);
                }
                attr.addChild(childattr);
                continue;
            }
            childattr = new FileAttribute();
            childattr.setName(e.getFilename());
            childattr.setDirectory(false);
            childattr.setSize(a.getSize());
            attr.addChild(childattr);
        }
    }

    @Override
    public void setLocalFileEncoding(String charset) {
        this.localFileEncoding = charset;
    }

    @Override
    public void setLocalRoot(String localRoot) {
        this.localRoot = FileManagerCommon.convertFileName(this.localRoot, localRoot, this.getLocalSeparator());
    }

    @Override
    public void setProperty(String key, String value) {
        this._properties.put(key, value);
    }

    @Override
    public void setRemoteFileEncoding(String charset) {
        this.remoteFileEncoding = charset;
    }

    @Override
    public void setRemoteRoot(String remoteRoot) {
        this.remoteRoot = FileManagerCommon.convertFileName(this.remoteRoot, remoteRoot, this.getRemoteSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String localfile, String remotefile, Progress progress) {
        try {
            int n = this.uploadImpl(localfile, remotefile, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String localfile, String remotefile, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotefile, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localfile, this.getLocalSeparator());
        FileAttribute attr = this.listLocal(local, false);
        if (attr == null) {
            return 1;
        }
        double step = 100.0 / ((double)(attr.getSize() + 1024L) / 1024.0);
        int error = this.uploadFile(local, remote, progress, 1024, step);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadFile(String localfile, String remotefile, Progress progress, int buffersize, double step) {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            os = this.channel.put(remotefile);
            is = new FileInputStream(localfile);
            if (progress != null) {
                progress.setProgress(0);
            }
            int n = this.writedata(is, os, buffersize, progress, step);
            return n;
        }
        catch (Exception e) {
            log.error((Object)("Error in upload " + localfile + " to " + remotefile), (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (FileManagerCommon.closeStream(is, os)) {
                return 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String localdir, String remotedir, boolean recursive, Progress progress) {
        try {
            int n = this.uploadImpl(localdir, remotedir, recursive, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String localdir, String remotedir, boolean recursive, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotedir, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localdir, this.getLocalSeparator());
        FileAttribute attr = this.listLocal(local, recursive);
        if (attr == null || !attr.isDirectory()) {
            return 1;
        }
        long size = attr.getTotalFileSize(recursive);
        double step = 100.0 / ((double)(size + 1024L) / 1024.0);
        int error = this.uploadDir(local, remote, progress, 1024, step, recursive, attr);
        return error;
    }

    @Override
    public int mkdir(String dir) {
        try {
            this.channel.mkdir(dir);
        }
        catch (Exception e) {
            log.error((Object)("Error making dir:" + dir));
            return 1;
        }
        return 0;
    }

    private int uploadDir(String localfile, String remotefile, Progress progress, int buffersize, double step, boolean recursive, FileAttribute attr) {
        int error = 0;
        if (recursive) {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.uploadFile(localfile + this.getLocalSeparator() + child.getName(), remotefile + this.getRemoteSeparator() + child.getName(), progress, buffersize, step);
                } else {
                    String r = remotefile + this.getRemoteSeparator() + child.getName();
                    this.mkdir(r);
                    error = this.uploadDir(localfile + this.getLocalSeparator() + child.getName(), r, progress, buffersize, step, recursive, child);
                }
                if (error == 0) continue;
                return error;
            }
        } else {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.uploadFile(localfile + this.getLocalSeparator() + child.getName(), remotefile + this.getRemoteSeparator() + child.getName(), progress, buffersize, step);
                }
                if (error == 0) continue;
                return error;
            }
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String localPath, String root, String[] remoteFiles, Progress progress) {
        try {
            int n = this.downloadImpl(localPath, root, remoteFiles, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String localPath, String root, String[] remoteFiles, Progress progress) {
        String remoteroot = FileManagerCommon.convertFileName(this.remoteRoot, root, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localPath, this.getLocalSeparator());
        long size = 0L;
        double steppart = 100.0 / (double)remoteFiles.length;
        int error = 0;
        for (int i = 0; i < remoteFiles.length; ++i) {
            String localtemp;
            double step = steppart;
            if (progress != null) {
                progress.setProgress((int)(step * (double)i));
            }
            String r = FileManagerCommon.convertFileName(this.remoteRoot, remoteFiles[i], this.getRemoteSeparator());
            if (remoteroot != null && !r.startsWith(remoteroot)) {
                log.error((Object)"Not all files started with root.");
                return 1;
            }
            FileAttribute attr = this.listRemote(r, false);
            if (attr == null || attr.isDirectory()) {
                log.error((Object)("File not exists or is a directory: " + r));
                return 1;
            }
            size = attr.getSize();
            double d = step = (step /= (double)(size + 1024L) / 1024.0) > 0.0 ? step : 1.0E-5;
            if (remoteroot != null) {
                localtemp = r.substring(remoteroot.length());
            } else {
                int index = r.lastIndexOf(this.getRemoteSeparator());
                localtemp = r.substring(index + 1);
            }
            error = this.downloadFile(r, local + this.getLocalSeparator() + localtemp, progress, 1024, step);
            if (error != 0) break;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String root, String[] localFiles, String remotePath, Progress progress) {
        try {
            int n = this.uploadImpl(root, localFiles, remotePath, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String root, String[] localFiles, String remotepath, Progress progress) {
        String remotepathfull = FileManagerCommon.convertFileName(this.remoteRoot, remotepath, this.getRemoteSeparator());
        String localrootfull = FileManagerCommon.convertFileName(this.localRoot, root, this.getLocalSeparator());
        long size = 0L;
        double steppart = 100.0 / (double)localFiles.length;
        int error = 0;
        for (int i = 0; i < localFiles.length; ++i) {
            String localtemp;
            double step = steppart;
            if (progress != null) {
                progress.setProgress((int)(step * (double)i));
            }
            String fullpath = FileManagerCommon.convertFileName(this.localRoot, localFiles[i], this.getLocalSeparator());
            if (localrootfull != null && !fullpath.startsWith(localrootfull)) {
                log.error((Object)"Not all files started with root.");
                return 1;
            }
            FileAttribute attr = this.listLocal(fullpath, false);
            if (attr == null || attr.isDirectory()) {
                log.error((Object)("File not exists or is a directory: " + fullpath));
                return 1;
            }
            size = attr.getSize();
            double d = step = (step /= (double)(size + 1024L) / 1024.0) > 0.0 ? step : 1.0E-5;
            if (localrootfull != null) {
                localtemp = fullpath.substring(localrootfull.length());
            } else {
                int index = fullpath.lastIndexOf(this.getLocalSeparator());
                localtemp = fullpath.substring(index + 1);
            }
            error = this.uploadFile(fullpath, remotepathfull + this.getRemoteSeparator() + localtemp, progress, 1024, step);
            if (error != 0) break;
        }
        return error;
    }

    private void exitSafe(Progress progress) {
        if (progress != null) {
            progress.setProgress(100);
        }
    }
}

