/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sf.filemanager;

import com.swimap.external.sf.filemanager.FileAttribute;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileManagerCommon {
    private static final IviewLogger log = IviewLogger.getLogger(FileManagerCommon.class, (String)"FRM");

    public static String convertFileName(String root, String name, String separator) {
        if (name == null || root == null || separator == null) {
            return null;
        }
        if (!FileManagerCommon.isAbsolute(root)) {
            return null;
        }
        String filename = name.equals("") ? root : (FileManagerCommon.isAbsolute(name) ? name : (root.endsWith("/") || root.endsWith("\\") ? root + name : root + separator + name));
        filename = filename.replace("/", separator);
        if ((filename = filename.replace("\\", separator)).endsWith(separator) && !filename.equals(separator)) {
            filename = filename.substring(0, filename.length() - 1);
        }
        return filename;
    }

    private static boolean isAbsolute(String path) {
        return path.startsWith("/") || path.startsWith("\\") || path.matches("^[a-zA-Z]:\\\\.*") || path.matches("^[a-zA-Z]:/.*");
    }

    public static FileAttribute parseFileAttribute(String attr) {
        FileAttribute result = new FileAttribute();
        if (attr == null) {
            return null;
        }
        char[] chars = attr.toCharArray();
        if (attr.matches("[drwx\\-]{10}[\\s]{1,}[\\d]{1,}[\\s]{1,}[\\d]{1,}[\\s]{1,}[\\d]{1,}[\\s]{1,}[\\d]{1,}\\s[\\s:\\da-zA-Z]{12}\\s.+")) {
            char[] perm = new char[10];
            System.arraycopy(chars, 0, perm, 0, 10);
            int i = 9;
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            while (!FileManagerCommon.isBlank(chars[++i])) {
            }
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            while (!FileManagerCommon.isBlank(chars[++i])) {
            }
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            while (!FileManagerCommon.isBlank(chars[++i])) {
            }
            StringBuilder size = new StringBuilder();
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            char c = chars[i];
            size.append(c);
            while (!FileManagerCommon.isBlank(c = chars[++i])) {
                size.append(c);
            }
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            i += 12;
            StringBuilder name = new StringBuilder();
            while (FileManagerCommon.isBlank(chars[++i])) {
            }
            while (i < chars.length) {
                c = chars[i++];
                name.append(c);
            }
            result.setDirectory(chars[0] == 'd');
            result.setName(name.toString());
            result.setSize(Long.parseLong(size.toString()));
        } else if (attr.matches("[drwx\\-]{10}.+[\\d]{2}:[\\d]{2}\\s.+")) {
            result.setDirectory(chars[0] == 'd');
            String[] array = attr.split("[\\d]{2}:[\\d]{2}");
            result.setName(array[array.length - 1].trim());
            result.setSize(Integer.MAX_VALUE);
            log.info((Object)("Guessed file attr: " + attr));
        } else {
            log.info((Object)("Unparsed file attr: " + attr));
            return null;
        }
        return result;
    }

    private static boolean isBlank(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean closeStream(InputStream is, OutputStream os) {
        boolean fail = false;
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed close OutputStream.", (Throwable)e);
            fail = true;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed close InputStream.", (Throwable)e);
            fail = true;
        }
        return fail;
    }
}

