/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sf.filemanager;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.log.IviewLogger;

public class FTPSetting {
    private static final IviewLogger log = IviewLogger.getLogger(FTPSetting.class, (String)"FRM");
    private final String SSH_PARANAME = "FileTransferMode";
    private final String IS_PASSIVE = "SupportPassive";
    private String ftpType = "FTP";
    private boolean passive = true;

    public FTPSetting() {
        this.init();
    }

    public String getFtpType() {
        return this.ftpType;
    }

    public boolean isPassive() {
        return this.passive;
    }

    private void init() {
        DataTable dataTable = this.getProfile();
        if (null != dataTable && dataTable.size() > 0) {
            DataRecord dataRecord = null;
            String key = "";
            String value = "";
            for (int i = 0; i < dataTable.size(); ++i) {
                dataRecord = dataTable.get(i);
                key = dataRecord.get(0);
                value = dataRecord.get(1);
                if ("FileTransferMode".equals(key)) {
                    this.ftpType = value;
                    continue;
                }
                if (!"SupportPassive".equals(key)) continue;
                this.passive = Boolean.parseBoolean(value);
            }
        } else {
            log.info((Object)"No user profile found.");
        }
    }

    private DataTable getProfile() {
        try {
            RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.getFTPSettings");
            RpcResponse rsp = req.invoke();
            RpcMessage msg = rsp.getMessage();
            return msg.getTable("FtpSettingsTable");
        }
        catch (Exception e) {
            log.debug((Object)"failed to get the ftp setting information.");
            return null;
        }
    }
}

