/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sf.filemanager;

import com.swimap.external.sf.filemanager.FileAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FTPImpl {
    private FTPClientFrame ftpClient = new FTPClientFrame();

    public boolean serverIsOpen() {
        return this.ftpClient.isConnected();
    }

    public void openServer(String ip, int parseInt) throws IOException {
        this.ftpClient.connect(ip, parseInt);
    }

    public void ascii() throws IOException {
        if (!this.ftpClient.setFileType(0)) {
            throw new IOException("Unable set ASCII_FILE_TYPE");
        }
    }

    public void binary() throws IOException {
        if (!this.ftpClient.setFileType(2)) {
            throw new IOException("Unable set BINARY_FILE_TYPE");
        }
    }

    public void cd(String remotefile) throws IOException {
        if (!this.ftpClient.changeWorkingDirectory(remotefile)) {
            throw new IOException("Unable change dir to " + remotefile);
        }
    }

    public void closeServer() throws IOException {
        this.ftpClient.logout();
        this.ftpClient.disconnect();
    }

    public InputStream get(String remotefile) throws IOException {
        InputStream result = this.ftpClient.retrieveFileStream(remotefile);
        if (result == null) {
            throw new IOException("Unable get file " + remotefile);
        }
        return result;
    }

    public FileAttribute[] list() throws IOException {
        FTPFile[] result = this.ftpClient.listFiles();
        if (result == null) {
            throw new IOException("List files return null.");
        }
        FileAttribute[] fa = new FileAttribute[result.length];
        for (int i = 0; i < result.length; ++i) {
            FTPFile temp = result[i];
            if (temp == null) {
                throw new IOException("Failed to parse file attribute.");
            }
            FileAttribute item = new FileAttribute();
            item.setDirectory(result[i].isDirectory());
            item.setName(result[i].getName());
            item.setSize(result[i].getSize());
            fa[i] = item;
        }
        return fa;
    }

    public void mkdir(String dir) throws IOException {
        if (!this.ftpClient.makeDirectory(dir)) {
            throw new IOException("Failed make dir " + dir);
        }
    }

    public OutputStream put(String remotefile) throws IOException {
        OutputStream os = this.ftpClient.storeFileStream(remotefile);
        if (os == null) {
            throw new IOException("Unable store file " + remotefile);
        }
        return os;
    }

    public String pwd() throws IOException {
        String dir = this.ftpClient.printWorkingDirectory();
        if (dir == null) {
            throw new IOException("Can not retrieve current dir");
        }
        dir = dir.replaceAll("\"", "");
        return dir;
    }

    public void login(String username, String ps) throws IOException {
        if (!this.ftpClient.login(username, ps)) {
            throw new IOException("Invalid user or password supplied.");
        }
    }

    public void setConnectTimeout(int timeout) {
        this.ftpClient.setConnectTimeout(timeout);
    }

    public void setReadTimeout(int readDataTimeout) {
        this.ftpClient.setTimeOut(readDataTimeout);
    }

    public void setEncoding(String remoteFileEncoding) {
        this.ftpClient.setControlEncoding(remoteFileEncoding);
    }

    public boolean completePendingCommand() {
        try {
            return this.ftpClient.completePendingCommand();
        }
        catch (IOException e) {
            return false;
        }
    }

    public void enterLocalPassiveMode() {
        this.ftpClient.enterLocalPassiveMode();
    }

    public void enterLocalActiveMode() {
        this.ftpClient.enterLocalActiveMode();
    }

    class FTPClientFrame
    extends FTPClient {
        FTPClientFrame() {
        }

        public void setTimeOut(int timeout) {
            this._timeout_ = timeout;
        }
    }
}

