/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sf.filemanager;

import com.swimap.external.sf.filemanager.AbstractFileManager;
import com.swimap.external.sf.filemanager.FileAttribute;
import com.swimap.external.sf.filemanager.Progress;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sf.filemanager.FTPImpl;
import com.swimap.sf.filemanager.FTPSetting;
import com.swimap.sf.filemanager.FileManagerCommon;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class FTPFileManager
extends AbstractFileManager {
    private static final IviewLogger log = IviewLogger.getLogger(FTPFileManager.class, (String)"FRM");
    private static final String UnixFileSeparator = "/";
    private static final int BufferSize = 1024;
    private String localFileEncoding = "utf-8";
    private String remoteFileEncoding = "utf-8";
    private String localRoot = System.getProperty("user.dir");
    private String remoteRoot = "/";
    private String _ip;
    private String _port;
    private String _username;
    private String _ps;
    private FTPImpl ftpImpl;
    private static final int READ_DATA_TIMEOUT = 30000;
    private Map<String, String> _properties = new HashMap<String, String>();
    private static final String ftp_overwrite = "ftp.overwrite";
    private static final String ftp_mode = "ftp.mode";
    private static final String ftp_connecttimeout = "ftp.connecttimeout";

    public FTPFileManager() {
    }

    public FTPFileManager(String ip, String port, String username, String ps) {
        this._ip = ip;
        this._port = port;
        this._username = username;
        this._ps = ps;
    }

    @Override
    public int connect(String ip, String port, String username, String ps) {
        this._ip = ip;
        this._port = port;
        this._username = username;
        this._ps = ps;
        return this.connect();
    }

    void setFtpImpl(FTPImpl impl) {
        this.ftpImpl = impl;
    }

    @Override
    public int connect() {
        if (this.ftpImpl == null || !this.ftpImpl.serverIsOpen()) {
            this.ftpImpl = new FTPImpl();
        }
        this.ftpImpl.setEncoding(this.remoteFileEncoding);
        try {
            int timeout = this.gettimeout(this._properties.get(ftp_connecttimeout));
            if (timeout != 0) {
                this.ftpImpl.setConnectTimeout(timeout);
            }
            this.ftpImpl.setReadTimeout(30000);
            this.ftpImpl.openServer(this._ip, Integer.parseInt(this._port));
            this.ftpImpl.login(this._username, this._ps);
            boolean isPassvie = new FTPSetting().isPassive();
            if (isPassvie) {
                this.ftpImpl.enterLocalPassiveMode();
            } else {
                this.ftpImpl.enterLocalActiveMode();
            }
            this.remoteRoot = this.ftpImpl.pwd();
        }
        catch (Exception e) {
            log.error((Object)("Connect to ftp server failed: " + this._ip + ":" + this._port), (Throwable)e);
            return 1;
        }
        return 0;
    }

    private int gettimeout(String s) {
        int result = 0;
        if (s == null) {
            return 0;
        }
        try {
            result = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            result = 0;
        }
        return result;
    }

    @Override
    public int disconnect() {
        if (this.ftpImpl != null) {
            try {
                this.ftpImpl.closeServer();
            }
            catch (Exception e) {
                log.info((Object)"Ignore this error.", (Throwable)e);
            }
        }
        return 0;
    }

    private int writedata(InputStream is, OutputStream os, int buffersize, Progress progress, double progressStep) {
        byte[] buffer = new byte[buffersize];
        double curd = 0.0;
        if (progress != null) {
            curd = progress.getProgress();
            if (progress.canceled()) {
                return 2;
            }
        }
        try {
            int count;
            int totalcount = 0;
            while ((count = is.read(buffer)) != -1) {
                os.write(buffer, 0, count);
                if ((totalcount += count) < buffersize) continue;
                totalcount -= buffersize;
                if (progress == null) continue;
                if (progress.canceled()) {
                    return 2;
                }
                curd = (curd = progressStep + curd) >= 100.0 ? 99.0 : curd;
                progress.setProgress((int)curd);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error in download file", (Throwable)e);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int downloadFile(String remotefile, String localfile, Progress progress, int buffersize, double step) {
        int result = 1;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            String v = this._properties.get(ftp_mode);
            if (v != null && v.equals("ascii")) {
                this.ftpImpl.ascii();
            } else {
                this.ftpImpl.binary();
            }
            is = this.ftpImpl.get(remotefile);
            File tempfile = new File(localfile);
            String overwrite = this._properties.get(ftp_overwrite);
            if ("false".equalsIgnoreCase(overwrite) && tempfile.exists()) {
                log.debug((Object)("Local file already exists:" + localfile));
                int n = 1;
                return n;
            }
            File parent = tempfile.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                log.warn((Object)("Failed to create directory:" + tempfile));
                int n = 1;
                return n;
            }
            os = new FileOutputStream(tempfile);
            result = this.writedata(is, os, buffersize, progress, step);
        }
        catch (IOException e) {
            log.error((Object)("Error in download." + remotefile), (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (FileManagerCommon.closeStream(is, os)) {
                return 1;
            }
        }
        if (!this.ftpImpl.completePendingCommand()) {
            return 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String remotefile, String localfile, Progress progress) {
        try {
            int n = this.downloadImpl(remotefile, localfile, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String remotefile, String localfile, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.getRemoteRoot(), remotefile, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.getLocalRoot(), localfile, this.getLocalSeparator());
        FileAttribute attr = this.listRemote(remote, false);
        if (attr == null) {
            return 1;
        }
        double step = 100.0 / ((double)(attr.getSize() + 1024L) / 1024.0);
        step = step > 1.0 ? step : 1.0;
        int error = this.downloadFile(remote, local, progress, 1024, step);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String remotedir, String localdir, boolean recursive, Progress progress) {
        try {
            int n = this.downloadImpl(remotedir, localdir, recursive, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String remotedir, String localdir, boolean recursive, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotedir, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localdir, this.getLocalSeparator());
        FileAttribute attr = this.listRemote(remote, recursive);
        if (attr == null || !attr.isDirectory()) {
            return 1;
        }
        long size = attr.getTotalFileSize(recursive);
        double step = 100.0 / ((double)(size + 1024L) / 1024.0);
        step = step > 1.0 ? step : 1.0;
        int error = this.downloadDir(remote, local, progress, 1024, step, recursive, attr);
        return error;
    }

    private int downloadDir(String remotedir, String localdir, Progress progress, int buffersize, double step, boolean recursive, FileAttribute attr) {
        int error = 0;
        File tempfile = new File(localdir);
        if (!tempfile.exists() && !tempfile.mkdirs()) {
            log.error((Object)("Failed to make directory: " + tempfile));
            return 1;
        }
        if (recursive) {
            for (FileAttribute child : attr.getChildren()) {
                error = !child.isDirectory() ? this.downloadFile(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step) : this.downloadDir(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step, recursive, child);
                if (error == 0) continue;
                return error;
            }
        } else {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.downloadFile(remotedir + this.getRemoteSeparator() + child.getName(), localdir + this.getLocalSeparator() + child.getName(), progress, buffersize, step);
                }
                if (error == 0) continue;
                return error;
            }
        }
        return error;
    }

    @Override
    public String getLocalSeparator() {
        return File.separator;
    }

    @Override
    public String getRemoteSeparator() {
        return UnixFileSeparator;
    }

    @Override
    public String getLocalRoot() {
        return this.localRoot;
    }

    @Override
    public String getRemoteRoot() {
        return this.remoteRoot;
    }

    @Override
    public FileAttribute listLocal(String localfile, boolean recursive) {
        String filename = FileManagerCommon.convertFileName(this.localRoot, localfile, this.getLocalSeparator());
        File file = new File(filename);
        if (!file.exists()) {
            log.debug((Object)("File not exist:" + localfile));
            return null;
        }
        return this.listLocal(file, recursive);
    }

    private FileAttribute listLocal(File file, boolean recursive) {
        FileAttribute attr = new FileAttribute();
        attr.setName(file.getName());
        if (file.isDirectory()) {
            File[] children;
            attr.setDirectory(true);
            for (File child : children = file.listFiles()) {
                if (recursive) {
                    attr.addChild(this.listLocal(child, recursive));
                    continue;
                }
                FileAttribute c = new FileAttribute();
                c.setDirectory(child.isDirectory());
                if (!c.isDirectory()) {
                    c.setSize(child.length());
                }
                c.setName(child.getName());
                attr.addChild(c);
            }
        } else {
            attr.setDirectory(false);
            attr.setSize(file.length());
        }
        return attr;
    }

    private boolean isDirectory(String remotefile) {
        try {
            this.ftpImpl.cd(remotefile);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private void fillChild(String file, FileAttribute parent, boolean recursive) throws IOException {
        FileAttribute[] names;
        this.ftpImpl.cd(file);
        for (FileAttribute temp : names = this.ftpImpl.list()) {
            if (temp == null || ".".equals(temp.getName()) || "..".equals(temp.getName())) continue;
            parent.addChild(temp);
            if (!temp.isDirectory() || !recursive) continue;
            String child = file + UnixFileSeparator + temp.getName();
            this.fillChild(child, temp, recursive);
        }
    }

    private void fillFile(String parent, FileAttribute attr) {
        FileAttribute temp = this.listRemote(parent, false);
        if (temp != null && temp.getChildren().size() > 0) {
            for (FileAttribute t : temp.getChildren()) {
                if (!t.getName().equals(attr.getName())) continue;
                attr.setSize(t.getSize());
            }
        }
    }

    @Override
    public FileAttribute listRemote(String remotefile, boolean recursive) {
        try {
            String file = FileManagerCommon.convertFileName(this.getRemoteRoot(), remotefile, this.getRemoteSeparator());
            int index = file.lastIndexOf(this.getRemoteSeparator());
            FileAttribute attr = null;
            String filename = file.substring(index + 1);
            String parent = file.substring(0, index);
            if (this.isDirectory(file)) {
                attr = new FileAttribute();
                attr.setDirectory(true);
                attr.setName(filename);
                this.fillChild(file, attr, recursive);
            } else {
                attr = new FileAttribute();
                attr.setDirectory(false);
                attr.setName(filename);
                this.fillFile(parent, attr);
            }
            return attr;
        }
        catch (IOException e) {
            log.error((Object)"List failed:", (Throwable)e);
            return null;
        }
    }

    @Override
    public void setLocalRoot(String localRoot) {
        this.localRoot = FileManagerCommon.convertFileName(this.localRoot, localRoot, this.getLocalSeparator());
    }

    @Override
    public void setRemoteRoot(String remoteRoot) {
        this.remoteRoot = FileManagerCommon.convertFileName(this.remoteRoot, remoteRoot, this.getRemoteSeparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String localfile, String remotefile, Progress progress) {
        try {
            int n = this.uploadImpl(localfile, remotefile, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String localfile, String remotefile, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotefile, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localfile, this.getLocalSeparator());
        FileAttribute attr = this.listLocal(local, false);
        if (attr == null) {
            return 1;
        }
        double step = 100.0 / ((double)(attr.getSize() + 1024L) / 1024.0);
        int error = this.uploadFile(local, remote, progress, 1024, step);
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int uploadFile(String localfile, String remotefile, Progress progress, int buffersize, double step) {
        int result = 1;
        FileInputStream is = null;
        OutputStream os = null;
        try {
            String v = this._properties.get(ftp_mode);
            if (v != null && v.equals("ascii")) {
                this.ftpImpl.ascii();
            } else {
                this.ftpImpl.binary();
            }
            os = this.ftpImpl.put(remotefile);
            is = new FileInputStream(localfile);
            if (progress != null) {
                progress.setProgress(0);
            }
            result = this.writedata(is, os, buffersize, progress, step);
        }
        catch (IOException e) {
            log.error((Object)"Error in upload:", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            if (FileManagerCommon.closeStream(is, os)) {
                return 1;
            }
        }
        if (!this.ftpImpl.completePendingCommand()) {
            return 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String localdir, String remotedir, boolean recursive, Progress progress) {
        try {
            int n = this.uploadImpl(localdir, remotedir, recursive, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String localdir, String remotedir, boolean recursive, Progress progress) {
        String remote = FileManagerCommon.convertFileName(this.remoteRoot, remotedir, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localdir, this.getLocalSeparator());
        FileAttribute attr = this.listLocal(local, recursive);
        if (attr == null || !attr.isDirectory()) {
            return 1;
        }
        long size = attr.getTotalFileSize(recursive);
        double step = 100.0 / ((double)(size + 1024L) / 1024.0);
        int error = this.uploadDir(local, remote, progress, 1024, step, recursive, attr);
        return error;
    }

    private int uploadDir(String localfile, String remotefile, Progress progress, int buffersize, double step, boolean recursive, FileAttribute attr) {
        int error = 0;
        if (recursive) {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.uploadFile(localfile + this.getLocalSeparator() + child.getName(), remotefile + this.getRemoteSeparator() + child.getName(), progress, buffersize, step);
                } else {
                    String r = remotefile + this.getRemoteSeparator() + child.getName();
                    this.mkdir(r);
                    error = this.uploadDir(localfile + this.getLocalSeparator() + child.getName(), r, progress, buffersize, step, recursive, child);
                }
                if (error == 0) continue;
                return error;
            }
        } else {
            for (FileAttribute child : attr.getChildren()) {
                if (!child.isDirectory()) {
                    error = this.uploadFile(localfile + this.getLocalSeparator() + child.getName(), remotefile + this.getRemoteSeparator() + child.getName(), progress, buffersize, step);
                }
                if (error == 0) continue;
                return error;
            }
        }
        return error;
    }

    @Override
    public String getLocalFileEncoding() {
        return this.localFileEncoding;
    }

    @Override
    public String getRemoteFileEncoding() {
        return this.remoteFileEncoding;
    }

    @Override
    public void setLocalFileEncoding(String charset) {
        this.localFileEncoding = charset;
    }

    @Override
    public void setRemoteFileEncoding(String charset) {
        this.remoteFileEncoding = charset;
    }

    @Override
    public void setProperty(String key, String value) {
        this._properties.put(key, value);
    }

    @Override
    public int mkdir(String dir) {
        try {
            this.ftpImpl.mkdir(dir);
        }
        catch (Exception e) {
            log.error((Object)("Error in making dir." + dir), (Throwable)e);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int download(String localPath, String root, String[] remoteFiles, Progress progress) {
        try {
            int n = this.downloadImpl(localPath, root, remoteFiles, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int downloadImpl(String localPath, String root, String[] remoteFiles, Progress progress) {
        String remoteroot = FileManagerCommon.convertFileName(this.remoteRoot, root, this.getRemoteSeparator());
        String local = FileManagerCommon.convertFileName(this.localRoot, localPath, this.getLocalSeparator());
        long size = 0L;
        double steppart = 100.0 / (double)remoteFiles.length;
        int error = 0;
        for (int i = 0; i < remoteFiles.length; ++i) {
            String localtemp;
            double step = steppart;
            if (progress != null) {
                progress.setProgress((int)(step * (double)i));
            }
            String r = FileManagerCommon.convertFileName(this.remoteRoot, remoteFiles[i], this.getRemoteSeparator());
            if (remoteroot != null && !r.startsWith(remoteroot)) {
                log.error((Object)"Not all files started with root.");
                return 1;
            }
            FileAttribute attr = this.listRemote(r, false);
            if (attr == null || attr.isDirectory()) {
                log.error((Object)("File not exists or is a directory: " + r));
                return 1;
            }
            size = attr.getSize();
            double d = step = (step /= (double)(size + 1024L) / 1024.0) > 0.0 ? step : 1.0E-5;
            if (remoteroot != null) {
                localtemp = r.substring(remoteroot.length());
            } else {
                int index = r.lastIndexOf(this.getRemoteSeparator());
                localtemp = r.substring(index + 1);
            }
            error = this.downloadFile(r, local + this.getLocalSeparator() + localtemp, progress, 1024, step);
            if (error != 0) break;
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String root, String[] localFiles, String remotePath, Progress progress) {
        try {
            int n = this.uploadImpl(root, localFiles, remotePath, progress);
            return n;
        }
        finally {
            this.exitSafe(progress);
        }
    }

    private int uploadImpl(String root, String[] localFiles, String remotePath, Progress progress) {
        String remotepathfull = FileManagerCommon.convertFileName(this.remoteRoot, remotePath, this.getRemoteSeparator());
        String localrootfull = FileManagerCommon.convertFileName(this.localRoot, root, this.getLocalSeparator());
        long size = 0L;
        double steppart = 100.0 / (double)localFiles.length;
        int error = 0;
        for (int i = 0; i < localFiles.length; ++i) {
            String localtemp;
            double step = steppart;
            if (progress != null) {
                progress.setProgress((int)(step * (double)i));
            }
            String fullpath = FileManagerCommon.convertFileName(this.localRoot, localFiles[i], this.getLocalSeparator());
            if (localrootfull != null && !fullpath.startsWith(localrootfull)) {
                log.error((Object)"Not all files started with root.");
                return 1;
            }
            FileAttribute attr = this.listLocal(fullpath, false);
            if (attr == null || attr.isDirectory()) {
                log.error((Object)("File not exists or is a directory: " + fullpath));
                return 1;
            }
            size = attr.getSize();
            double d = step = (step /= (double)(size + 1024L) / 1024.0) > 0.0 ? step : 1.0E-5;
            if (localrootfull != null) {
                localtemp = fullpath.substring(localrootfull.length());
            } else {
                int index = fullpath.lastIndexOf(this.getLocalSeparator());
                localtemp = fullpath.substring(index + 1);
            }
            error = this.uploadFile(fullpath, remotepathfull + this.getRemoteSeparator() + localtemp, progress, 1024, step);
            if (error != 0) break;
        }
        return error;
    }

    private void exitSafe(Progress progress) {
        if (progress != null) {
            progress.setProgress(100);
        }
    }
}

