/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.viewframework.systemsettings.ui;

import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.viewframework.systemsettings.RegionSettings;
import com.swimap.iview.viewframework.systemsettings.datasource.DataSource;
import com.swimap.iview.viewframework.systemsettings.model.RegionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class TimeModeSetting
extends BaseClientSettings
implements ItemListener {
    private static final String HELP_ID = "iVIEW.regionconfig.timemodesetting";
    private static final IviewLogger log = IviewLogger.getLogger(TimeModeSetting.class, (String)"FRM");
    private JRadioButton serverRBtn = new JRadioButton(ClientUtilModule.getString("ServerTime"));
    private JRadioButton clientBtn = new JRadioButton(ClientUtilModule.getString("ClientTime"));
    protected static final Dimension SIZE = new Dimension(120, 120);
    protected static final Dimension PANELSIZE = new Dimension(500, 400);
    public static final String MODULE_NAME = "Time_Mode";
    private JPanel panel = null;
    protected DataSource dataSource = RegionSettings.getInstance().getDatasource();
    protected RegionModel regionModel = RegionSettings.getInstance().getRegionModel();
    private boolean isChanged = false;

    protected void jbInit() throws Exception {
        this.panel = new JPanel();
        this.panel.setDebugGraphicsOptions(0);
        this.panel.setInputVerifier(null);
        this.panel.setLayout(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder(new Insets(12, 12, 12, 12));
        this.panel.setBorder(emptyBorder);
        this.initData();
        this.serverRBtn.addItemListener(this);
        this.clientBtn.addItemListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.serverRBtn);
        bg.add(this.clientBtn);
        JPanel tmSettingPanel = new JPanel();
        tmSettingPanel.setLayout(new GridBagLayout());
        tmSettingPanel.add((Component)this.serverRBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 12, 0), 0, 0));
        tmSettingPanel.add((Component)this.clientBtn, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.add((Component)tmSettingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.putClientProperty("HELP_ID_PROPERTY", HELP_ID);
        HelpManager.getInstance().enableHelpKey((Component)this.panel, HELP_ID);
        this.setName();
    }

    private void setName() {
        this.serverRBtn.setName("SysMgr_TimeModeSetting_ServerRBtn");
        this.clientBtn.setName("SysMgr_TimeModeSetting_ClientBtn");
    }

    protected void initJRadioButtons() {
        if (this.dataSource.getLocregcfgXMLConfig().getCurTimeMode().getValue() == 0) {
            this.serverRBtn.setSelected(true);
        } else {
            this.clientBtn.setSelected(true);
        }
    }

    protected void initData() {
        this.initJRadioButtons();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.notifyChange();
    }

    public void doSetting() {
        ValueNamePair timeMode = null;
        timeMode = this.serverRBtn.isSelected() ? new ValueNamePair(0, "TimeMode") : new ValueNamePair(2, "TimeMode");
        this.regionModel.fireTimeModeChanged(timeMode);
    }

    protected void fireExampleShowChanged() {
    }

    public TimeModeSetting(ModuleManager moduleMgr) throws ModuleManagementException {
        super(moduleMgr);
    }

    public boolean apply() {
        if (!this.isChanged()) {
            return true;
        }
        this.doSetting();
        if (!RegionSettings.getInstance().getDatasource().configXMLDataToServer()) {
            FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), Boolean.valueOf(false), ClientUtilModule.getString("TimeMode_Setting_Failed"));
        } else {
            FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), Boolean.valueOf(true), ClientUtilModule.getString("Log_In_Again"));
        }
        this.isChanged = false;
        return true;
    }

    public boolean exit() {
        try {
            this.initData();
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
        return true;
    }

    public JPanel getSettingsPanel() {
        if (this.panel == null) {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
        return this.panel;
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabLabel() {
        return ClientUtilModule.getString("TimeMode");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    private void notifyChange() {
        SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
        ssm.clientSettingChanged(this.getModuleName(), true);
        this.isChanged = true;
    }

    public int getTitleDescription() {
        return 1;
    }
}

