/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.viewframework.systemsettings.ui;

import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.format.NumberFormatUtil;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.viewframework.systemsettings.RegionSettings;
import com.swimap.iview.viewframework.systemsettings.datasource.DataSource;
import com.swimap.iview.viewframework.systemsettings.model.RegionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class NumberSetting
extends BaseClientSettings {
    private static final IviewLogger log = IviewLogger.getLogger(NumberSetting.class, (String)"FRM");
    private final Dimension COMPONENTSIZE = new Dimension(160, 21);
    private final Dimension COMPONENTSIZE_LEFT = new Dimension(240, 21);
    private final Dimension VGAP8 = new Dimension(1, 8);
    private final String HELPID = "iVIEW.regionconfig.numbersetting";
    public static final String MODULE_NAME = "Number_Setting";
    private JComboBox numerDigitCombo = new JComboBox();
    private JComboBox groupCombo = new JComboBox();
    private JComboBox zeroShowCombo = new JComboBox();
    private JTextField jTextField1 = new JTextField();
    private JTextField jTextField2 = new JTextField();
    private JPanel panel = null;
    protected DataSource dataSource = RegionSettings.getInstance().getDatasource();
    protected RegionModel regionModel = RegionSettings.getInstance().getRegionModel();
    protected String title;
    protected boolean isChanged = false;
    private static final int CONTAIN_SIZE = 20;
    protected Vector<JComboBox> changedComboVec = new Vector(20);

    public NumberSetting(ModuleManager moduleMgr) throws ModuleManagementException {
        super(moduleMgr);
    }

    protected void jbInit() throws Exception {
        this.panel = new JPanel();
        this.initData();
        Border emptryBorder = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.panel.setBorder(emptryBorder);
        this.panel.setLayout(new BorderLayout(0, 2));
        this.panel.add((Component)this.initNumberConfigPanel(), "North");
        this.panel.add((Component)this.initExamplePanel(), "Center");
        this.panel.putClientProperty("HELP_ID_PROPERTY", "iVIEW.regionconfig.numbersetting");
        HelpManager.getInstance().enableHelpKey((Component)this.panel, "iVIEW.regionconfig.numbersetting");
        this.addItemListener();
        this.fireExampleShowChanged();
        this.setName();
    }

    private void setName() {
        this.jTextField1.setName("UTIL_NumberSetting_positive");
        this.jTextField2.setName("UTIL_NumberSetting_negative");
        this.numerDigitCombo.setName("UTIL_NumberSetting_numerDigitCombo");
        this.groupCombo.setName("UTIL_NumberSetting_groupCombo");
        this.zeroShowCombo.setName("UTIL_NumberSetting_zeroShowCombo");
    }

    private JPanel initExamplePanel() {
        Dimension EXAMPANELSIZE = new Dimension(435, 86);
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        jLabel1.setPreferredSize(this.COMPONENTSIZE_LEFT);
        jLabel2.setPreferredSize(this.COMPONENTSIZE_LEFT);
        this.jTextField1.setPreferredSize(this.COMPONENTSIZE);
        this.jTextField1.setEditable(false);
        this.jTextField2.setPreferredSize(this.COMPONENTSIZE);
        this.jTextField2.setEditable(false);
        jLabel1.setText(ClientUtilModule.getString("Positive"));
        jLabel2.setText(ClientUtilModule.getString("Negative"));
        JPanel examplePanel = new JPanel();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(), ClientUtilModule.getString("ShowExample"));
        CompoundBorder showExampleBorder = BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 0, 6, 0));
        examplePanel.setBorder(showExampleBorder);
        examplePanel.setMinimumSize(EXAMPANELSIZE);
        examplePanel.setPreferredSize(EXAMPANELSIZE);
        examplePanel.setLayout(new BoxLayout(examplePanel, 1));
        examplePanel.add(this.initControlPanel(jLabel1, this.jTextField1));
        examplePanel.add(Box.createRigidArea(this.VGAP8));
        examplePanel.add(this.initControlPanel(jLabel2, this.jTextField2));
        examplePanel.add(Box.createRigidArea(this.VGAP8));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)examplePanel, "North");
        return jPanel;
    }

    private JPanel initNumberConfigPanel() {
        Dimension CONFIGPANELSIZE = new Dimension(435, 100);
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        jLabel1.setPreferredSize(this.COMPONENTSIZE_LEFT);
        jLabel2.setPreferredSize(this.COMPONENTSIZE_LEFT);
        jLabel3.setPreferredSize(this.COMPONENTSIZE_LEFT);
        this.numerDigitCombo.setPreferredSize(this.COMPONENTSIZE);
        this.groupCombo.setPreferredSize(this.COMPONENTSIZE);
        this.zeroShowCombo.setPreferredSize(this.COMPONENTSIZE);
        jLabel1.setText(ClientUtilModule.getString("NumerDigit"));
        jLabel2.setText(ClientUtilModule.getString("NumberGroup"));
        jLabel3.setText(ClientUtilModule.getString("NumberZeroShow"));
        JPanel settingPanel = new JPanel();
        settingPanel.setMinimumSize(CONFIGPANELSIZE);
        settingPanel.setPreferredSize(CONFIGPANELSIZE);
        settingPanel.setLayout(new BoxLayout(settingPanel, 1));
        settingPanel.add(this.initControlPanel(jLabel1, this.numerDigitCombo));
        settingPanel.add(Box.createRigidArea(this.VGAP8));
        settingPanel.add(this.initControlPanel(jLabel2, this.groupCombo));
        settingPanel.add(Box.createRigidArea(this.VGAP8));
        settingPanel.add(this.initControlPanel(jLabel3, this.zeroShowCombo));
        settingPanel.add(Box.createRigidArea(this.VGAP8));
        JPanel numberConfigPanel = new JPanel(new BorderLayout());
        numberConfigPanel.add((Component)settingPanel, "North");
        return numberConfigPanel;
    }

    private JPanel initControlPanel(JLabel label, JComponent component) {
        Dimension HGAP12 = new Dimension(12, 1);
        Dimension HGAP17 = new Dimension(17, 1);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(HGAP17));
        panel.add(label);
        panel.add(component);
        panel.add(Box.createRigidArea(HGAP12));
        return panel;
    }

    private void addItemListener() {
        this.numerDigitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NumberSetting.this.performItemStateChanged(itemEvent, NumberSetting.this.numerDigitCombo, NumberSetting.this.getCurNumberDigitafterZeroFromServerXMLConfig());
            }
        });
        this.groupCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NumberSetting.this.performItemStateChanged(itemEvent, NumberSetting.this.groupCombo, NumberSetting.this.getCurNumberGroupFormatFromServerXMLConfig());
            }
        });
        this.zeroShowCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                NumberSetting.this.performItemStateChanged(itemEvent, NumberSetting.this.zeroShowCombo, NumberSetting.this.getCurNumberShowFormatWithZeroFromServerXMLConfig());
            }
        });
    }

    protected void initData() {
        this.initComboData(this.dataSource.getRegionconfigXMLConfig().getNumberDigitafterZeros(), this.getCurNumberDigitafterZeroFromServerXMLConfig(), this.numerDigitCombo);
        this.initComboData(this.dataSource.getRegionconfigXMLConfig().getNumberGroupFormats(), this.getCurNumberGroupFormatFromServerXMLConfig(), this.groupCombo);
        this.initComboData(this.dataSource.getRegionconfigXMLConfig().getNumberShowFormatfromZeros(), this.getCurNumberShowFormatWithZeroFromServerXMLConfig(), this.zeroShowCombo);
    }

    private ValueNamePair getCurNumberGroupFormatFromServerXMLConfig() {
        return this.dataSource.getLocregcfgXMLConfig().getCurNumberGroupFormat();
    }

    private ValueNamePair getCurNumberShowFormatWithZeroFromServerXMLConfig() {
        return this.dataSource.getLocregcfgXMLConfig().getCurNumberShowFormatWithZero();
    }

    private ValueNamePair getCurNumberDigitafterZeroFromServerXMLConfig() {
        return this.dataSource.getLocregcfgXMLConfig().getCurNumberDigitafterZero();
    }

    protected void fireExampleShowChanged() {
        String groupStr = ((ValueNamePair)this.groupCombo.getSelectedItem()).toString();
        int digitafterZero = ((ValueNamePair)this.numerDigitCombo.getSelectedItem()).getValue();
        String positiveStr = NumberFormatUtil.getFormatNumber((String)"123456789.1234", (String)groupStr, (int)digitafterZero, (boolean)true);
        StringBuffer negetiveStr = new StringBuffer();
        negetiveStr.append("-");
        negetiveStr.append(positiveStr);
        this.jTextField1.setText(positiveStr);
        this.jTextField2.setText(negetiveStr.toString());
    }

    public boolean apply() {
        if (!this.isChanged()) {
            return true;
        }
        this.doSetting();
        if (!RegionSettings.getInstance().getDatasource().configXMLDataToServer()) {
            FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), Boolean.valueOf(false), ClientUtilModule.getString("Number_Setting_Failed"));
        } else {
            FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), Boolean.valueOf(true), ClientUtilModule.getString("Log_In_Again"));
        }
        this.isChanged = false;
        return true;
    }

    private void doSetting() {
        int comboVec = this.changedComboVec.size();
        for (int i = 0; i < comboVec; ++i) {
            JComboBox combo = this.changedComboVec.get(i);
            if (combo.equals(this.numerDigitCombo)) {
                this.regionModel.fireDigitafterZeroChanged((ValueNamePair)combo.getSelectedItem());
                continue;
            }
            if (combo.equals(this.groupCombo)) {
                this.regionModel.fireNumberGroupFormatChanged((ValueNamePair)combo.getSelectedItem());
                continue;
            }
            if (!combo.equals(this.zeroShowCombo)) continue;
            this.regionModel.fireNumberIsShowWithZero((ValueNamePair)combo.getSelectedItem());
        }
        this.clearData();
    }

    public boolean exit() {
        if (!this.isChanged()) {
            return true;
        }
        this.initData();
        return true;
    }

    public JPanel getSettingsPanel() {
        if (this.panel == null) {
            try {
                this.jbInit();
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
        return this.panel;
    }

    public Icon getTabIcon() {
        return null;
    }

    public String getTabLabel() {
        return ClientUtilModule.getString("Number");
    }

    protected void initComboData(ValueNamePair[] pairs, ValueNamePair curPair, JComboBox combo) {
        combo.removeAllItems();
        for (int i = 0; i < pairs.length; ++i) {
            combo.addItem(pairs[i]);
        }
        if (pairs.length == 1) {
            combo.setEnabled(false);
        }
        combo.setSelectedItem(curPair);
    }

    public boolean isChanged() {
        return this.changedComboVec.size() > 0;
    }

    public void clearData() {
        this.changedComboVec.clear();
        this.isChanged = false;
    }

    protected void notifyStatus() {
        if (this.isChanged()) {
            this.notifyChange();
        }
    }

    protected void performItemStateChanged(ItemEvent itemEvent, JComboBox combo, ValueNamePair pair) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getItem().equals(pair)) {
                if (this.changedComboVec.contains(combo)) {
                    this.changedComboVec.remove(combo);
                }
            } else if (!this.changedComboVec.contains(combo)) {
                this.changedComboVec.add(combo);
            }
            this.notifyStatus();
            this.fireExampleShowChanged();
        }
    }

    private void notifyChange() {
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public int getTitleDescription() {
        return 1;
    }
}

