/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.viewframework.systemsettings.datasource;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class XMLConfig {
    private static final IviewLogger log = IviewLogger.getLogger(XMLConfig.class, (String)"FRM");
    public static final int INVALIDVALUE = -255;
    private final String NUMBERSETTING = "NumberSetting";
    private final String NUMBERDIGITAFTERZERO = "DigitafterZero";
    private final String NUMBERGROUPFORMAT = "GroupFormat";
    private final String NUMBERSHOWFORMATFROMZERO = "ShowFormatfromZero";
    private final String ZONEDSTSETTING = "ZoneDSTSetting";
    private final String TIMEMODE = "TimeMode";
    private final String TIMEMODEVISIBLE = "TimeModelVisible";
    private PARA curNumberDigitafterZero;
    private PARA curNumberGroupFormat;
    private PARA curNumberShowFormatfromZero;
    private PARA curTimeMode;
    private PARA curTimeModeVisible;
    private ArrayList<?> numberDigitafterZeroList;
    private ArrayList<?> numberGroupFormatList;
    private ArrayList<?> numberShowFormatfromZeroList;
    private CommStyleInfo info;
    private boolean isLanguageChanged = false;
    private CommStyleParser commStyleParser = PluginManager.getInstance().getPlugin("ClientUtilModule").getCommStyleParser();

    public XMLConfig(String xmlFileName, boolean _isClient) {
        this.info = this.commStyleParser.getUserCommStyleInfo(xmlFileName);
        try {
            this.read(this.info);
        }
        catch (Exception ex) {
            log.error((Object)ex.toString(), (Throwable)ex);
        }
    }

    public void read(CommStyleInfo _info) {
        AreaDescContainer[] areas = _info.getAreaDescContainer();
        AreaDescContainer area = new AreaDescContainer();
        Locale locale = Locale.getDefault();
        if (areas.length == 1) {
            area = areas[0];
            if (!locale.getLanguage().equals(area.getAreaName().substring(0, 2))) {
                area.setAreaName(locale.getLanguage() + '_' + locale.getCountry());
                this.isLanguageChanged = true;
            }
        } else {
            for (int i = 0; i < areas.length; ++i) {
                if ("CN".equals(locale.getCountry()) && "zh".equals(locale.getLanguage())) {
                    if (!"zh_CN".equals(areas[i].getAreaName())) continue;
                    area = areas[i];
                    continue;
                }
                if (!"en_US".equals(areas[i].getAreaName())) continue;
                area = areas[i];
            }
        }
        DescContainer[] desc = area.getDescContainer();
        for (int i = 0; i < desc.length; ++i) {
            if (desc[i].getDescName().equals("NumberSetting")) {
                this.readNumberSetting(desc[i]);
                continue;
            }
            if (!desc[i].getDescName().equals("ZoneDSTSetting")) continue;
            this.readZoneDSTSetting(desc[i]);
        }
    }

    public boolean configXMLDataToServer() {
        try {
            this.commStyleParser.writeToUser(this.info);
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            return false;
        }
        return true;
    }

    public void createDefaultCommInfo() {
        this.info = new CommStyleInfo();
        this.info.addAreaDescContainer(this.createNewAreaDescContainer());
    }

    private AreaDescContainer createNewAreaDescContainer() {
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        areaDescContainer.setAreaName("en_US");
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName("NumberSetting");
        DescContainer _descContainer = this.createNewDescContainer("DigitafterZero");
        descContainer.addDescContainer(_descContainer);
        this.numberDigitafterZeroList = _descContainer.getPARAS().getPARAArrayList();
        this.curNumberDigitafterZero = (PARA)this.numberDigitafterZeroList.get(0);
        _descContainer = this.createNewDescContainer("GroupFormat");
        descContainer.addDescContainer(_descContainer);
        this.numberGroupFormatList = _descContainer.getPARAS().getPARAArrayList();
        this.curNumberGroupFormat = (PARA)this.numberGroupFormatList.get(0);
        _descContainer = this.createNewDescContainer("ShowFormatfromZero");
        descContainer.addDescContainer(_descContainer);
        this.numberShowFormatfromZeroList = _descContainer.getPARAS().getPARAArrayList();
        this.curNumberShowFormatfromZero = (PARA)this.numberShowFormatfromZeroList.get(0);
        areaDescContainer.addDescContainer(descContainer);
        return areaDescContainer;
    }

    private DescContainer createNewDescContainer(String str) {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(str);
        descContainer.setPARAS(this.createPARAS());
        return descContainer;
    }

    private PARAS createPARAS() {
        PARAS paras = new PARAS();
        paras.addPARA(this.createPARA());
        return paras;
    }

    private PARA createPARA() {
        PARA para = new PARA();
        para.setName("");
        para.setValue(String.valueOf(-255));
        return para;
    }

    private void readNumberSetting(DescContainer _desc) {
        DescContainer[] descs = _desc.getDescContainer();
        for (int i = 0; i < descs.length; ++i) {
            if (descs[i].getDescName().equals("GroupFormat")) {
                this.numberGroupFormatList = descs[i].getPARAS().getPARAArrayList();
                this.curNumberGroupFormat = (PARA)this.numberGroupFormatList.get(0);
                continue;
            }
            if (descs[i].getDescName().equals("DigitafterZero")) {
                this.numberDigitafterZeroList = descs[i].getPARAS().getPARAArrayList();
                this.curNumberDigitafterZero = (PARA)this.numberDigitafterZeroList.get(0);
                continue;
            }
            if (!descs[i].getDescName().equals("ShowFormatfromZero")) continue;
            this.numberShowFormatfromZeroList = descs[i].getPARAS().getPARAArrayList();
            this.curNumberShowFormatfromZero = (PARA)this.numberShowFormatfromZeroList.get(0);
        }
    }

    private void readZoneDSTSetting(DescContainer _desc) {
        PARA[] allPara = _desc.getPARAS().getPARA();
        for (int i = 0; i < allPara.length; ++i) {
            if ("TimeMode".equals(allPara[i].getName())) {
                this.curTimeMode = allPara[i];
                continue;
            }
            if (!"TimeModelVisible".equals(allPara[i].getName())) continue;
            this.curTimeModeVisible = allPara[i];
        }
    }

    private ValueNamePair get(Collection<?> collection, int value) {
        for (PARA para : collection) {
            if (Integer.valueOf(para.getValue()) != value) continue;
            return this.getValueNamePairWithPARA(para);
        }
        return null;
    }

    private ValueNamePair[] getAll(Collection<?> collection) {
        ValueNamePair[] valueNamePairs = new ValueNamePair[collection.size()];
        int index = 0;
        for (PARA para : collection) {
            int value = Integer.valueOf(para.getValue());
            valueNamePairs[index] = new ValueNamePair(value, para.getName());
            ++index;
        }
        return valueNamePairs;
    }

    public ValueNamePair getNumberDigitafterZeroWithType(int typeValue) {
        return this.get(this.numberDigitafterZeroList, typeValue);
    }

    public ValueNamePair getNumberGroupFormatWithType(int typeValue) {
        return this.get(this.numberGroupFormatList, typeValue);
    }

    public ValueNamePair getNumberShowFormatfromZeroWithType(int typeValue) {
        return this.get(this.numberShowFormatfromZeroList, typeValue);
    }

    public ValueNamePair[] getNumberDigitafterZeros() {
        return this.getAll(this.numberDigitafterZeroList);
    }

    public ValueNamePair[] getNumberGroupFormats() {
        return this.getAll(this.numberGroupFormatList);
    }

    public ValueNamePair[] getNumberShowFormatfromZeros() {
        return this.getAll(this.numberShowFormatfromZeroList);
    }

    public CommStyleInfo getInfo() {
        return this.info;
    }

    private ValueNamePair getValueNamePairWithPARA(PARA para) {
        try {
            int value = Integer.valueOf(para.getValue());
            return new ValueNamePair(value, para.getName());
        }
        catch (Exception e) {
            return new ValueNamePair(-255, "");
        }
    }

    private void setValueNamePairToPARA(PARA para, ValueNamePair pair) {
        para.setName(pair.getName());
        para.setValue(String.valueOf(pair.getValue()));
    }

    public ValueNamePair getCurNumberDigitafterZero() {
        return this.getValueNamePairWithPARA(this.curNumberDigitafterZero);
    }

    public ValueNamePair getCurNumberGroupFormat() {
        return this.getValueNamePairWithPARA(this.curNumberGroupFormat);
    }

    public ValueNamePair getCurNumberShowFormatWithZero() {
        return this.getValueNamePairWithPARA(this.curNumberShowFormatfromZero);
    }

    public ValueNamePair getCurTimeMode() {
        return this.getValueNamePairWithPARA(this.curTimeMode);
    }

    public void setCurTimeMode(ValueNamePair _curTimeMode) {
        this.setValueNamePairToPARA(this.curTimeMode, _curTimeMode);
    }

    public void setCurNumberShowFormatfromZero(ValueNamePair _curNumberShowFormatfromZero) {
        this.setValueNamePairToPARA(this.curNumberShowFormatfromZero, _curNumberShowFormatfromZero);
    }

    public void setCurNumberGroupFormat(ValueNamePair _curNumberGroupFormat) {
        this.setValueNamePairToPARA(this.curNumberGroupFormat, _curNumberGroupFormat);
    }

    public void setCurNumberDigitafterZero(ValueNamePair _curNumberDigitafterZero) {
        this.setValueNamePairToPARA(this.curNumberDigitafterZero, _curNumberDigitafterZero);
    }

    public ValueNamePair getCurTimeModeVisible() {
        return this.getValueNamePairWithPARA(this.curTimeModeVisible);
    }

    public static boolean isValid(ValueNamePair pair) {
        boolean valid = false;
        if (pair != null && pair.getName() != null && pair.getValue() != -255) {
            valid = true;
        }
        return valid;
    }

    public boolean isIsLanguageChanged() {
        return this.isLanguageChanged;
    }
}

