/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.viewframework.systemsettings;

import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.iview.viewframework.systemsettings.datasource.DataSource;
import com.swimap.iview.viewframework.systemsettings.model.RegionModel;
import com.swimap.iview.viewframework.systemsettings.ui.NumberSetting;
import com.swimap.iview.viewframework.systemsettings.ui.TimeModeSetting;
import com.swimap.iview.viewframework.systemsettings.util.NumberFormat;
import com.swimap.iview.viewframework.systemsettings.util.TimeDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class RegionSettings {
    private static final IviewLogger log = IviewLogger.getLogger(RegionSettings.class, (String)"FRM");
    private RegionModel regionModel;
    private DataSource datasource;
    private OutputManager outputManager = FrameworkUtilities.getOutputManager();
    public static final String REGION_MANAGER_NAME = "ViewFrameworkModule";
    List<String> messageList = new LinkedList<String>();
    private static RegionSettings instance = new RegionSettings();
    private static final int NO_INIT = -1;
    private int numberSettingsID = -1;
    private int disconnectSettingID = -1;
    private int timeModeSettingsID = -1;
    private final String NoSETTINGSEQUENCEID = "500";
    private final String TIMESETTINGSEQUENCEID = "800";

    private RegionSettings() {
    }

    public static RegionSettings getInstance() {
        return instance;
    }

    public void registerSystemSettingsPage(ModuleManager moduleMgr) throws ModuleManagementException {
        this.regionModel = new RegionModel();
        NumberFormat.init();
        TimeDateFormat.init();
        this.showMessageList();
        SystemSettingsManager s = FrameworkUtilities.getSystemSettingsManager();
        NumberSetting number_setting = new NumberSetting(moduleMgr);
        this.numberSettingsID = s.addClientModuleSettingsWithSequence("500", (BaseClientSettings)number_setting, "Number_Setting", null);
        try {
            if (0 == RegionSettings.getInstance().getDatasource().getLocregcfgXMLConfig().getCurTimeModeVisible().getValue()) {
                System.setProperty("time_model_visible", "false");
            } else {
                TimeModeSetting time_mode_setting = new TimeModeSetting(moduleMgr);
                this.timeModeSettingsID = s.addClientModuleSettingsWithSequence("800", (BaseClientSettings)time_mode_setting, "Time_Mode", null);
                System.setProperty("time_model_visible", "true");
            }
        }
        catch (ModuleManagementException e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    private void showMessageList() {
        Iterator<String> it = this.messageList.iterator();
        while (it.hasNext()) {
            this.outputManager.addMessage(REGION_MANAGER_NAME, it.next());
        }
        this.messageList.clear();
    }

    public RegionModel getRegionModel() {
        return this.regionModel;
    }

    public DataSource getDatasource() {
        if (this.datasource == null) {
            this.datasource = new DataSource();
        }
        return this.datasource;
    }

    public void clear() {
        SystemSettingsManager s = FrameworkUtilities.getSystemSettingsManager();
        if (s != null) {
            s.removeSetting(this.numberSettingsID);
            s.removeSetting(this.disconnectSettingID);
            if (this.timeModeSettingsID != -1) {
                s.removeSetting(this.timeModeSettingsID);
            }
        }
        this.datasource = null;
    }
}

