/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.templates.pagingtree.client;

import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.templates.pagingtree.client.PageMapIndex;
import com.swimap.iview.templates.pagingtree.csi.ITreeService;
import com.swimap.iview.templates.pagingtree.csi.TreeViewNode;
import com.swimap.iview.util.log.IviewLogger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class RpcTreeServiceProxy
implements ITreeService,
SocketClient.Listener {
    private static final IviewLogger log = IviewLogger.getLogger(RpcTreeServiceProxy.class, (String)"FRM");
    private long id = 0L;
    private boolean connected = true;
    private static final String CHANGE_EXPAND_STATE = "imap.tree.service.changeExpandState";
    private final String SHOW_FIRST_CHILD = "imap.tree.service.showFirstChild";
    private static final String CLOSE = "imap.tree.service.close";
    private static final String GET_KEYS = "imap.tree.service.getKeys";
    private static final String GET_PARENT_ROW = "imap.tree.service.getParentRow";
    private static final String GET_ROW_COUNT = "imap.tree.service.getRowCount";
    private static final String LOAD_BY_KEY = "imap.tree.service.loadByKey";
    private static final String LOAD_BY_KEYS = "imap.tree.service.loadByKeys";
    private static final String GET_ROWS = "imap.tree.service.getRows";
    private static final String LOAD_PAGE = "imap.tree.service.loadPage";
    private static final String SORT = "imap.tree.service.sort";
    private static final String RECONNECTED = "imap.tree.service.reconnected";
    private static final String RELOAD = "imap.tree.service.reload";
    private static final String GET_VIEW_NODES = "imap.tree.service.getViewNodes";
    private static final String LOAD_Print_PAGE = "imap.tree.service.loadPrintPage";
    private static final String INIT_PRINT = "imap.tree.service.initPrint";
    private static final String CLEAR_PRINT = "imap.tree.service.clearPrintInfo";
    private static final String GET_NEXT_MATCH = "imap.tree.service.getNextMatch";

    public RpcTreeServiceProxy(long id) {
        this.id = id;
        RpcRequest.getSocketClient().addListener((SocketClient.Listener)this);
    }

    @Deprecated
    public int changeExpandState(int row) throws Exception {
        RpcRequest rpcRequest = RpcNaming.createRequest((String)CHANGE_EXPAND_STATE);
        rpcRequest.addArgument("id", (Object)this.id);
        rpcRequest.addArgument("row", (Object)row);
        log.info((Object)"sys | changeExpandState | invoke start.");
        RpcResponse rpcResponse = rpcRequest.invoke();
        log.info((Object)"sys | changeExpandState | invoke end.");
        return rpcResponse.getMessage().getInt("count");
    }

    public int changeExpandState(int row, PageMapIndex pmi) throws Exception {
        RpcRequest rpcRequest = RpcNaming.createRequest((String)CHANGE_EXPAND_STATE);
        rpcRequest.addArgument("id", (Object)this.id);
        rpcRequest.addArgument("row", (Object)row);
        log.info((Object)"sys | changeExpandState | invoke start.");
        RpcResponse rpcResponse = rpcRequest.invoke();
        log.info((Object)"sys | changeExpandState | invoke end.");
        pmi.setRowCount(rpcResponse.getMessage().getInt("count"));
        pmi.setSerialNumber(rpcResponse.getMessage().getInt("serialNumber"));
        return rpcResponse.getMessage().getInt("count");
    }

    public int showFirstChild(int row, boolean recursion, PageMapIndex pmi) throws Exception {
        RpcRequest rpcRequest = RpcNaming.createRequest((String)"imap.tree.service.showFirstChild");
        rpcRequest.addArgument("id", (Object)this.id);
        rpcRequest.addArgument("row", (Object)row);
        rpcRequest.addArgument("recursion", (Object)recursion);
        log.info((Object)"sys | showFirstChild | invoke start.");
        RpcResponse rpcResponse = rpcRequest.invoke();
        log.info((Object)("firstChildRow is" + rpcResponse.getMessage().getInt("firstChildRow")));
        log.info((Object)"sys | showFirstChild | invoke end.");
        pmi.setRowCount(rpcResponse.getMessage().getInt("rowCount"));
        pmi.setSerialNumber(rpcResponse.getMessage().getInt("serialNumber"));
        return rpcResponse.getMessage().getInt("firstChildRow");
    }

    public void close() {
        RpcRequest.getSocketClient().removeListener((SocketClient.Listener)this);
        if (this.connected) {
            try {
                RpcRequest req = RpcNaming.createRequest((String)CLOSE);
                req.addArgument("id", (Object)this.id);
                log.info((Object)"sys | close | invoke start.");
                req.invokeOneway();
                log.info((Object)"sys | close | invoke end.");
            }
            catch (Exception e) {
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    public List<String> getKeys(int[] rows) throws Exception {
        DataTable rowTable = new DataTable("rows");
        rowTable.setColumns(new String[]{"row"});
        for (int row : rows) {
            rowTable.add(new Object[]{row});
        }
        RpcRequest req = RpcNaming.createRequest((String)GET_KEYS);
        req.addArgument("id", (Object)this.id);
        req.addTable(rowTable);
        log.info((Object)"sys | getKeys | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getKeys | invoke end.");
        ArrayList<String> keys = new ArrayList<String>();
        DataTable keyTable = rsp.getMessage().getTable("keys");
        for (DataRecord r : keyTable) {
            keys.add(r.get(0));
        }
        return keys;
    }

    public int getParentRow(int row) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)GET_PARENT_ROW);
        req.addArgument("id", (Object)this.id);
        req.addArgument("row", (Object)row);
        log.info((Object)"sys | getParentRow | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getParentRow | invoke end.");
        return rsp.getMessage().getInt("parentRow");
    }

    public int getRowCount() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)GET_ROW_COUNT);
        req.addArgument("id", (Object)this.id);
        log.info((Object)"sys | getRowCount | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getRowCount | invoke end.");
        return rsp.getMessage().getInt("count");
    }

    public int loadByKey(String key, PageMapIndex pmi) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)LOAD_BY_KEY);
        req.addArgument("id", (Object)this.id);
        req.addArgument("key", (Object)key);
        log.info((Object)"sys | loadByKey | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | loadByKey | invoke end.");
        pmi.setRowCount(rsp.getMessage().getInt("rowCount"));
        pmi.setSerialNumber(rsp.getMessage().getInt("serialNumber"));
        return rsp.getMessage().getInt("row");
    }

    public int[] loadByKeys(String[] keys, PageMapIndex pmi) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)LOAD_BY_KEYS);
        req.addArgument("id", (Object)this.id);
        req.addArgument("keys", (Object)keys);
        log.info((Object)"sys | loadByKeys | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | loadByKeys | invoke end.");
        pmi.setRowCount(rsp.getMessage().getInt("rowCount"));
        pmi.setSerialNumber(rsp.getMessage().getInt("serialNumber"));
        return rsp.getMessage().getIntArray("rows");
    }

    public int[] getRows(String ... keys) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)GET_ROWS);
        req.addArgument("id", (Object)this.id);
        req.addArgument("keys", (Object)keys);
        log.info((Object)"sys | getRows | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getRows | invoke end.");
        return rsp.getMessage().getIntArray("rows");
    }

    public List<TreeViewNode> loadPage(int startRow, int pageSize, PageMapIndex pmi) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)LOAD_PAGE);
        req.addArgument("id", (Object)this.id);
        req.addArgument("startRow", (Object)startRow);
        req.addArgument("pageSize", (Object)pageSize);
        log.info((Object)"sys | loadPage | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | loadPage | invoke end.");
        DataTable table = rsp.getMessage().getTable("page");
        pmi.setRowCount(rsp.getMessage().getInt("rowCount"));
        pmi.setSerialNumber(rsp.getMessage().getInt("serialNumber"));
        return RpcTreeServiceProxy.getNodesFromDataTable(table);
    }

    public void sort(String sortName, boolean isAscent) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)SORT);
        req.addArgument("id", (Object)this.id);
        req.addArgument("name", (Object)sortName);
        req.addArgument("ascent", (Object)isAscent);
        log.info((Object)"sys | sort | invoke start.");
        req.invoke();
        log.info((Object)"sys | sort | invoke end.");
    }

    public void connectionBroken(URI uri) {
        this.connected = false;
    }

    public void connectionResumed(URI uri) {
        this.connected = true;
        try {
            RpcRequest req = RpcNaming.createRequest((String)RECONNECTED);
            req.addArgument("id", (Object)this.id);
            log.info((Object)"sys | connectionResumed | invoke start.");
            ClientUtilModule.invoker(req);
            log.info((Object)"sys | connectionResumed | invoke end.");
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void refresh(int row) {
        try {
            RpcRequest req = RpcNaming.createRequest((String)RELOAD);
            req.addArgument("id", (Object)this.id);
            req.addArgument("row", (Object)row);
            log.info((Object)"sys | refresh | invoke start.");
            req.invoke();
            log.info((Object)"sys | refresh | invoke end.");
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
        }
    }

    public List<TreeViewNode> getViewNodes(int[] rows) throws Exception {
        long t1 = System.currentTimeMillis();
        ArrayList<TreeViewNode> page = new ArrayList<TreeViewNode>();
        RpcRequest req = RpcNaming.createRequest((String)GET_VIEW_NODES);
        req.addArgument("id", (Object)this.id);
        req.addArgument("rows", (Object)rows);
        log.info((Object)"sys | getViewNodes | invoke start.");
        log.trace((Object)("getViewNodes 2 :" + System.currentTimeMillis()));
        long t2 = System.currentTimeMillis();
        RpcResponse rsp = req.invoke();
        long t3 = System.currentTimeMillis();
        log.trace((Object)("getViewNodes | req.invoke() time:" + (t3 - t2)));
        log.info((Object)"sys | getViewNodes | invoke end.");
        DataTable table = rsp.getMessage().getTable("page");
        TreeViewNode node = null;
        for (DataRecord record : table) {
            DataTable statusTable;
            node = new TreeViewNode(record.get("key"), record.get("label"), record.getBoolean("leaf"));
            node.setExpanded(record.getBoolean("expanded"));
            node.setLevel(record.getInt("level"));
            DataTable attrs = record.getTable("attrs");
            if (attrs != null) {
                for (DataRecord attr : attrs) {
                    node.add(attr.get(0));
                }
            }
            if ((statusTable = record.getTable("status")) != null) {
                int pos = 0;
                while (pos < statusTable.size()) {
                    pos = RpcTreeServiceProxy.getStatus(statusTable, node, pos);
                }
            }
            page.add(node);
        }
        long t4 = System.currentTimeMillis();
        log.trace((Object)("getViewNodes | all time:" + (t4 - t1)));
        log.info((Object)("sys | getViewNodes | loadPage, size = " + page.size()));
        return page;
    }

    public void restartService(URI uri) {
    }

    public void reconnectCountout(URI uri) {
    }

    public int initPrint() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)INIT_PRINT);
        req.addArgument("id", (Object)this.id);
        log.info((Object)"sys | initPrint | invoke start.");
        RpcResponse rpcResponse = req.invoke();
        log.info((Object)"sys | initPrint | invoke end.");
        return rpcResponse.getMessage().getInt("count");
    }

    public List<TreeViewNode> loadPrintPage(int startRow, int pageSize) throws Exception {
        ArrayList<TreeViewNode> page = new ArrayList<TreeViewNode>();
        RpcRequest req = RpcNaming.createRequest((String)LOAD_Print_PAGE);
        req.addArgument("id", (Object)this.id);
        req.addArgument("startRow", (Object)startRow);
        req.addArgument("pageSize", (Object)pageSize);
        log.info((Object)"sys | loadPrintPage | invoke start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | loadPrintPage | invoke end.");
        DataTable table = rsp.getMessage().getTable("page");
        TreeViewNode node = null;
        for (DataRecord record : table) {
            DataTable statusTable;
            node = new TreeViewNode(record.get("key"), record.get("label"), record.getBoolean("leaf"));
            node.setExpanded(record.getBoolean("expanded"));
            node.setLevel(record.getInt("level"));
            DataTable attrs = record.getTable("attrs");
            if (attrs != null) {
                for (DataRecord attr : attrs) {
                    node.add(attr.get(0));
                }
            }
            if ((statusTable = record.getTable("status")) != null) {
                int pos = 0;
                while (pos < statusTable.size()) {
                    pos = RpcTreeServiceProxy.getStatus(statusTable, node, pos);
                }
            }
            page.add(node);
        }
        return page;
    }

    public void clearPrintInfo() throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)CLEAR_PRINT);
        req.addArgument("id", (Object)this.id);
        log.info((Object)"sys | clearPrintInfo | invoke start.");
        req.invoke();
        log.info((Object)"sys | clearPrintInfo | invoke end.");
    }

    public static List<int[]> getNodesStatusFromDataTable(DataTable table) {
        ArrayList<int[]> page = new ArrayList<int[]>();
        if (table == null) {
            return page;
        }
        int[] status = null;
        for (DataRecord record : table) {
            DataTable statusTable = record.getTable("status");
            if (statusTable != null && statusTable.size() > 0) {
                status = new int[statusTable.size()];
                int i = 0;
                for (DataRecord statusItem : statusTable) {
                    status[i++] = statusItem.getInt(0);
                }
            }
            page.add(status);
            status = null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("status number:" + page.size()));
        }
        return page;
    }

    public static List<TreeViewNode> getNodesFromDataTable(DataTable table) {
        ArrayList<TreeViewNode> page = new ArrayList<TreeViewNode>();
        if (table == null) {
            return page;
        }
        TreeViewNode node = null;
        for (DataRecord record : table) {
            DataTable statusTable;
            node = new TreeViewNode(record.get("key"), record.get("label"), record.getBoolean("leaf"));
            node.setExpanded(record.getBoolean("expanded"));
            node.setLevel(record.getInt("level"));
            DataTable attrs = record.getTable("attrs");
            if (attrs != null) {
                for (DataRecord attr : attrs) {
                    node.add(attr.get(0));
                }
            }
            if ((statusTable = record.getTable("status")) != null) {
                int pos = 0;
                while (pos < statusTable.size()) {
                    pos = RpcTreeServiceProxy.getStatus(statusTable, node, pos);
                }
            }
            page.add(node);
        }
        return page;
    }

    private static int getStatus(DataTable statusTable, TreeViewNode node, int pos) {
        String statusName = statusTable.get(pos).get(0);
        int length = statusTable.get(++pos).getInt(0);
        ++pos;
        int[] status = new int[length];
        for (int i = 0; i < length; ++i) {
            status[i] = statusTable.get(pos).getInt(0);
            ++pos;
        }
        node.setStatus(statusName, status);
        return pos;
    }

    public String getNextMatch(String prefix, int row) throws Exception {
        RpcRequest rpcRequest = RpcNaming.createRequest((String)GET_NEXT_MATCH);
        rpcRequest.addArgument("id", (Object)this.id);
        rpcRequest.addArgument("prefix", (Object)prefix);
        rpcRequest.addArgument("row", (Object)row);
        log.info((Object)"sys | getNextMatch | invoke start.");
        RpcResponse rpcResponse = rpcRequest.invoke();
        boolean found = rpcResponse.getMessage().getBoolean("found");
        String matchKey = null;
        if (found) {
            matchKey = rpcResponse.getMessage().getString("matchedKey");
        }
        log.info((Object)("sys | getNextMatch | invoke end. Match key is : " + matchKey));
        return matchKey;
    }
}

