/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.systemmgr;

import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class SystemMgrServicePushClient
implements RpcServerPushHandler {
    private static final IviewLogger log = IviewLogger.getLogger(SystemMgrServicePushClient.class, (String)"FRM");
    private static final String ASWithoutGUIEvent = "SystemManager.ASWithoutGUIEvent";
    private static final String SHUTDOWN_NMS = "SystemMonitor.ShutDownNMSEvent";
    private static final String TITLE = "Title";
    private static final String MESSAGE = "Message";

    public void open() {
        log.info((Object)"sys | open | before RpcServerPush.addHandler(emEventType, this).");
        RpcServerPush.addHandler((String)ASWithoutGUIEvent, (RpcServerPushHandler)this);
        RpcServerPush.addHandler((String)SHUTDOWN_NMS, (RpcServerPushHandler)this);
        log.info((Object)"sys | open | after RpcServerPush.addHandler(emEventType, this).");
    }

    public void close() {
        log.info((Object)"sys | close | before RpcServerPush.removeHandler(this).");
        RpcServerPush.removeHandler((RpcServerPushHandler)this);
        log.info((Object)"sys | close | after RpcServerPush.removeHandler(this).");
    }

    public void handleServerPush(RpcEvent event) {
        if (null == event) {
            log.info((Object)"sys | handleServerPush | event is null.");
            return;
        }
        String eventType = event.getType();
        if (eventType != null && event.getType().equals(SHUTDOWN_NMS)) {
            log.trace((Object)"Displaying message for SystemMonitor.ShutDownNMSEvent");
            OptionPane.showWarningDialog((Component)FrameworkUtilities.getCurrentActiveFrame(), (Object)ClientUtilModule.getString("SHUTDOWN_NMS_MESSAGE"));
            log.trace((Object)"SystemMonitor.ShutDownNMSEvent displayed");
            return;
        }
        log.info((Object)"sys | handleServerPush | handle event start.");
        RpcMessage rpcMessage = event.getMessage();
        final String title = rpcMessage.getString(TITLE);
        final String message = rpcMessage.getString(MESSAGE);
        boolean showType = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                log.info((Object)"sys | handleServerPush | show message start.");
                OptionPane.showMessageDialog((Component)FrameworkUtilities.getMainFrame(), (Object)message, (String)title, (int)1);
            }
        });
    }
}

