/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.profile.localPersistence;

import com.swimap.iview.util.log.IviewLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipContent {
    private static final IviewLogger log = IviewLogger.getLogger(ZipContent.class, (String)"FRM");
    private static final String ENCODING = "utf-8";
    private static final int EACH_READ_BYTES = 1024;
    private static final String ZIPENTRY_NAME = "content";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String fileContent) throws IOException {
        byte[] byArray;
        if (fileContent == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream(outputStream);
            ZipEntry zipEntry = new ZipEntry(ZIPENTRY_NAME);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(fileContent.getBytes(ENCODING));
            zipOutputStream.closeEntry();
            outputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            ZipContent.close(outputStream);
            ZipContent.close(zipOutputStream);
            throw throwable;
        }
        ZipContent.close(outputStream);
        ZipContent.close(zipOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompression(byte[] bytes) throws IOException {
        String string;
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        ByteArrayOutputStream outputStream = null;
        try {
            inputStream = new ByteArrayInputStream(bytes);
            zipInputStream = new ZipInputStream(inputStream);
            zipInputStream.getNextEntry();
            outputStream = new ByteArrayOutputStream();
            byte[] output = new byte[1024];
            int b = -1;
            while ((b = zipInputStream.read(output)) != -1) {
                outputStream.write(output, 0, b);
            }
            outputStream.flush();
            string = new String(outputStream.toByteArray(), ENCODING).trim();
        }
        catch (Throwable throwable) {
            ZipContent.close(zipInputStream);
            ZipContent.close(inputStream);
            ZipContent.close(outputStream);
            throw throwable;
        }
        ZipContent.close(zipInputStream);
        ZipContent.close(inputStream);
        ZipContent.close(outputStream);
        return string;
    }

    private static void close(Closeable object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (IOException e) {
                log.error((Object)"fail to close the ZipContent stream", (Throwable)e);
            }
        }
    }
}

