/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.profile.localPersistence;

import com.swimap.iview.profile.localPersistence.GuiProfile;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class JdbcSqlit {
    private static final IviewLogger log = IviewLogger.getLogger(JdbcSqlit.class, (String)"FRM");
    private static final String CREATE_TABLE_SQL = "create table localgui (filename varchar(256) primary key, changed int, content text)";
    private static final String INSERT_SQL = "insert into localgui(filename, changed, content) values(?,?,?)";
    private static final String UPDATE_SQL = "update localgui set changed = ?, content = ? where filename = ?";
    private static final String GET_CONTENT_SQL = "select content from localgui where filename = ?";
    private static final String GET_HASCHANGED_SQL = "select filename, content from localgui where changed=?";
    private static final String DB_FOLDER = "output" + File.separator + "Guiprofile";
    private final String dbName;
    private Connection conn;
    private final Object syncObject = new Object();

    public JdbcSqlit() throws Exception {
        String[] fileList;
        File file = new File(DB_FOLDER);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        for (String string : fileList = file.list()) {
            File deleteFile = new File(file.getAbsoluteFile() + File.separator + string);
            deleteFile.delete();
        }
        this.dbName = DB_FOLDER + File.separator + UUID.randomUUID().toString();
        Class.forName("org.sqlite.JDBC");
        this.conn = DriverManager.getConnection("jdbc:sqlite:" + this.dbName);
        this.initial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initial() throws SQLException {
        PreparedStatement prst = null;
        Object object = this.syncObject;
        synchronized (object) {
            try {
                prst = this.conn.prepareStatement(CREATE_TABLE_SQL);
                prst.execute();
            }
            catch (Throwable throwable) {
                JdbcSqlit.clostPrst(prst);
                throw throwable;
            }
            JdbcSqlit.clostPrst(prst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(GuiProfile localGui) throws SQLException {
        PreparedStatement prst = null;
        Object object = this.syncObject;
        synchronized (object) {
            try {
                prst = this.conn.prepareStatement(INSERT_SQL);
                prst.setString(1, localGui.getFileName());
                prst.setBoolean(2, localGui.isChanged());
                prst.setString(3, localGui.getContent());
                prst.execute();
            }
            catch (Throwable throwable) {
                JdbcSqlit.clostPrst(prst);
                throw throwable;
            }
            JdbcSqlit.clostPrst(prst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(GuiProfile localGui) throws SQLException {
        PreparedStatement prst = null;
        Object object = this.syncObject;
        synchronized (object) {
            try {
                prst = this.conn.prepareStatement(UPDATE_SQL);
                prst.setBoolean(1, localGui.isChanged());
                prst.setString(2, localGui.getContent());
                prst.setString(3, localGui.getFileName());
                prst.execute();
            }
            catch (Throwable throwable) {
                JdbcSqlit.clostPrst(prst);
                throw throwable;
            }
            JdbcSqlit.clostPrst(prst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContent(GuiProfile localGui) throws SQLException {
        PreparedStatement prst = null;
        ResultSet resultSet = null;
        Object object = this.syncObject;
        synchronized (object) {
            try {
                prst = this.conn.prepareStatement(GET_CONTENT_SQL);
                prst.setString(1, localGui.getFileName());
                resultSet = prst.executeQuery();
                if (resultSet.next()) {
                    localGui.setContent(resultSet.getString(1));
                }
            }
            catch (Throwable throwable) {
                JdbcSqlit.closeResultSet(resultSet);
                JdbcSqlit.clostPrst(prst);
                throw throwable;
            }
            JdbcSqlit.closeResultSet(resultSet);
            JdbcSqlit.clostPrst(prst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GuiProfile> getHasChanged() throws SQLException {
        PreparedStatement prst = null;
        ResultSet resultSet = null;
        Object object = this.syncObject;
        synchronized (object) {
            ArrayList<GuiProfile> arrayList;
            try {
                prst = this.conn.prepareStatement(GET_HASCHANGED_SQL);
                prst.setBoolean(1, true);
                resultSet = prst.executeQuery();
                ArrayList<GuiProfile> localGuis = new ArrayList<GuiProfile>();
                while (resultSet.next()) {
                    GuiProfile localGui = new GuiProfile();
                    localGui.setFileName(resultSet.getString(1));
                    localGui.setContent(resultSet.getString(2));
                    localGuis.add(localGui);
                }
                arrayList = localGuis;
            }
            catch (Throwable throwable) {
                JdbcSqlit.closeResultSet(resultSet);
                JdbcSqlit.clostPrst(prst);
                throw throwable;
            }
            JdbcSqlit.closeResultSet(resultSet);
            JdbcSqlit.clostPrst(prst);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.syncObject;
        synchronized (object) {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    log.error((Object)"fail to close connection for db", (Throwable)e);
                }
            }
            File file = new File(this.dbName);
            file.delete();
        }
    }

    private static void clostPrst(PreparedStatement prst) {
        if (prst != null) {
            try {
                prst.close();
            }
            catch (SQLException e) {
                log.error((Object)"fail to close preparedStament", (Throwable)e);
            }
        }
    }

    private static void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error((Object)"fail to close resultSet", (Throwable)e);
            }
        }
    }
}

