/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.profile;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.iview.util.log.IviewLogger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class RemoteProfileParserRpc {
    public static final int REMOTE_PROFILE_TYPE = 0;
    public static final int GUI_PROFILE_TYPE = 2;
    private static final IviewLogger log = IviewLogger.getLogger(RemoteProfileParserRpc.class, (String)"FRM");
    private static RemoteProfileParserRpc instance = new RemoteProfileParserRpc();

    public static RemoteProfileParserRpc getInstance() {
        return instance;
    }

    protected byte[] getProfile(String fileName) throws Exception {
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.getProfile");
        req.addArgument("fileName", (Object)fileName);
        log.info((Object)"sys | getProfile | req.invoke() start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getProfile | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        return msg.getByteArray("content");
    }

    protected void saveProfile(Map<String, Object> files, int profileType) throws Exception {
        if (files == null) {
            return;
        }
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.saveProfiles");
        req.addArgument("profileType", (Object)String.valueOf(profileType));
        String tableName = "profileFileTable";
        String fileNameColum = "FileName";
        String fileContentColum = "FileContent";
        Set<String> dataset = files.keySet();
        DataTable table = new DataTable(tableName, new String[]{fileNameColum, fileContentColum});
        for (String fileName : dataset) {
            Object fileContent = files.get(fileName);
            DataRecord record = new DataRecord(table);
            record.set(fileNameColum, (Object)fileName);
            record.set(fileContentColum, fileContent);
            table.add(record);
        }
        req.addTable(table);
        log.info((Object)"sys | saveProfile | req.invoke() start.");
        req.invoke();
        log.info((Object)"sys | saveProfile | req.invoke() end.");
    }

    protected List<String> getFileIndex() throws Exception {
        String[] content;
        RpcRequest req = RpcNaming.createRequest((String)"sys.manage.profile.ds.getFileIndex");
        log.info((Object)"sys | getFileIndex | req.invoke() start.");
        RpcResponse rsp = req.invoke();
        log.info((Object)"sys | getFileIndex | req.invoke() end.");
        RpcMessage msg = rsp.getMessage();
        Vector<String> list = new Vector<String>();
        for (String str : content = msg.getStringArray("content")) {
            list.add(str);
        }
        return list;
    }
}

