/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.profile;

import com.swimap.external.sm.client.base.SessionService;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.profile.RemoteProfileParserRpc;
import com.swimap.iview.util.log.IviewLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class RemoteProfileParser
implements IProfileParser {
    private static final IviewLogger log = IviewLogger.getLogger(RemoteProfileParser.class, (String)"FRM");
    private static final String ENCODING = "utf-8";
    private static final String PREFIX = "style/users/";
    private static List<String> fileIndex = null;

    public String read(String fileName) throws FileNotFoundException {
        log.info((Object)("sys | read | [fileName]=" + fileName));
        if (fileName.startsWith(PREFIX) && !RemoteProfileParser.getFileList().contains(fileName.replace('\\', '/'))) {
            throw new FileNotFoundException();
        }
        try {
            String userName = SessionService.getInstance().getCurUserName();
            String info = new String(RemoteProfileParserRpc.getInstance().getProfile(fileName), ENCODING);
            info = this.getInfo(info);
            log.info((Object)("sys | read | [fileName]=" + fileName + "[userName]=" + userName + "[info]=" + info));
            return info;
        }
        catch (Exception e) {
            log.error((Object)"read file from server faild");
            throw new FileNotFoundException("RPCError");
        }
    }

    private String getInfo(String info) {
        try {
            byte[] bytes = info.getBytes("UTF-8");
            bytes = this.dePaddingBytes(bytes);
            return new String(bytes, "UTF-8");
        }
        catch (Exception e) {
            return info;
        }
    }

    private byte[] dePaddingBytes(byte[] target) {
        int len;
        int plainlen = len = target.length;
        for (int i = len - 1; i >= 0 && target[i] == 0; --i) {
            --plainlen;
        }
        if (plainlen == 0) {
            return new byte[0];
        }
        byte[] newbyte = new byte[plainlen];
        System.arraycopy(target, 0, newbyte, 0, plainlen);
        return newbyte;
    }

    public void write(String info, String fileName) throws IOException {
        log.info((Object)("sys | write | [fileName]=" + fileName));
        try {
            HashMap<String, Object> fileData = new HashMap<String, Object>();
            fileData.put(fileName, info.getBytes(ENCODING));
            RemoteProfileParserRpc.getInstance().saveProfile(fileData, 0);
            fileName = fileName.replace('\\', '/');
            if (fileName.startsWith(PREFIX) && !RemoteProfileParser.getFileList().contains(fileName)) {
                RemoteProfileParser.getFileList().add(fileName);
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new IOException();
        }
    }

    public static synchronized List<String> getFileList() {
        if (fileIndex == null) {
            fileIndex = new Vector<String>();
            try {
                fileIndex = RemoteProfileParserRpc.getInstance().getFileIndex();
                String index = "";
                for (int i = 0; i < fileIndex.size(); ++i) {
                    String line = fileIndex.get(i);
                    index = index + line + ";";
                    fileIndex.set(i, line.replace('\\', '/'));
                }
                log.info((Object)("index:" + index));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return fileIndex;
    }

    public static void clearFileIndex() {
        fileIndex = null;
    }
}

